*************************************************************************
*     
*     Subroutine fillpedsig.f
*     
*     - fills bad, pedestal and sigma variables with respective values from
*     level0 histograms, in order to perform cluster identification !???
*     - fills bad, pedestal_t and sigma_t variables with respective truncated
*     values from level0 histograms, in order to perform data decompression
*     
*     needs:
*     - level0 pedestal, sigma and badstrip histograms
*     
*     output variables:
*     - bad
*     - pedestal
*     - pedestal_t
*     - sigma
*     - sigma_t
*     
*     to be called inside ./reduction.f
*     
*************************************************************************


      subroutine fillpedsigfromdefault()

      include 'commontracker.f'
      include 'common_reduction.f'
      include 'common_c2f.f'
      include 'calib.f'

      external nvk
      external nst

c------------------------------------------------------------------------
c     
c     local variables
c     
c------------------------------------------------------------------------

      REAL hmemor(10000000)
      integer Iquest(100)    
      COMMON /pawc/hmemor
      save /pawc/
C
      Common /QUEST/ Iquest
      save /quest/
     
      real content(nstrips_view) !temporary array
      parameter (lun_data_file=70) !data file id number

c      character*60 fname_param 


      CALL HLIMIT(10000000)

      IQUEST(10)=65000          

      c2f_error=0


      if(C2F_DEBUG.eq.1)print*,c2f_path(1:c2f_pathlen)
      call HROPEN(lun_data_file,
     $     'CALIB'
     $     ,c2f_path(1:c2f_pathlen) !<<<< C2F
     $     ,'QP',4096,istat)    !opens
      if(istat.ne.0)then
         c2f_error=1
         goto 19
      endif      
      call HRIN(0,9999,0) 


c------------------------------------------------------------------------
c     
c     loops on views filling badstrip, pedestal and sigma variables from
c     level0 histograms
c     
c------------------------------------------------------------------------

      do iv=1,nviews
         call HUNPAK(id_hi_bad+iv,content,' ',0) !puts histo contents in an array
         do is=1,nstrips_view   !fills variables with array values
            bad(iv,nvk(is),nst(is))=INT(content(is))
         enddo

         call HUNPAK(id_hi_ped+iv,content,' ',0)
         do is=1,nstrips_view
            pedestal(iv,nvk(is),nst(is))=content(is)
cc            print*,'ped',pedestal(iv,nvk(is),nst(is))
            pedestal_t(iv,nvk(is),nst(is))=AINT(content(is)) !truncated value
cc            print*,'ped_t',pedestal_t(iv,nvk(is),nst(is))
         enddo

         call HUNPAK(id_hi_sig+iv,content,' ',0)
         do is=1,nstrips_view
            sigma(iv,nvk(is),nst(is))=content(is)
            sigma_t(iv,nvk(is),nst(is))=ANINT(content(is)) !truncated value
         enddo

         do is=1,nstrips_view!inversione (a volte ritornano, quasi...) badstrip!???
            if(bad(iv,nvk(is),nst(is)).eq.1) then
               bad(iv,nvk(is),nst(is))=0
            else
               bad(iv,nvk(is),nst(is))=1
            endif
         enddo

      enddo
      
      do iview=1,nviews
        call HDELET(id_hi_bad+iview)
        call HDELET(id_hi_ped+iview)
        call HDELET(id_hi_sig+iview)
      enddo
      call HREND('CALIB')
      close(lun_data_file)  
      


c$$$  C     
c$$$  C     inversione vista 11: devo riinvertire i valori contenuti negli istogrammi
c$$$  C     per poter decomprimere i dati compressi (che sono stati messi a diritto 
c$$$  C     nel vettore datatracker, senza inversione 11). quello che mi serve e' di
c$$$  C     riinvertire pedestal_t(11,nvk(is),nst(is)) e (anche se forse non lo uso)
c$$$  C     sigma_t(11,nvk(is),nst(is)) !??? 
c$$$  C     
c$$$  do is=1,nstrips_view
c$$$  content(is) = pedestal_t(11,nvk(is),nst(is))
c$$$  enddo
c$$$  
c$$$  do is=1,nstrips_view
c$$$  offset=5121
c$$$  if(is.le.2048) offset=3073
c$$$  if(is.le.1024) offset=1025
c$$$  iss=offset-is
c$$$  
c$$$  pedestal_t(11,nvk(iss),nst(iss)) = content(is)
c$$$  enddo
c$$$  
c$$$  
c$$$  do is=1,nstrips_view
c$$$  content(is) = sigma_t(11,nvk(is),nst(is))
c$$$  enddo
c$$$  
c$$$  do is=1,nstrips_view
c$$$  offset=5121
c$$$  if(is.le.2048) offset=3073
c$$$  if(is.le.1024) offset=1025
c$$$  iss=offset-is
c$$$  
c$$$  sigma_t(11,nvk(iss),nst(iss)) = content(is)
c$$$  enddo
c$$$  C     
c$$$  C     fine inversione vista 11 !???
c$$$  C     
 19   continue
      return
      end
