/**
 * \file TrkLevel1.cpp
 * \author Elena Vannuccini
 */
#include <TrkLevel1.h>
#include <iostream>
using namespace std;
//......................................
// F77 routines
//......................................
extern "C" {
	
//	int readetaparam_(); 
	float cog_(int*,int*);
	float pfaeta_(int*,float*);
	float pfaeta2_(int*,float*);
	float pfaeta3_(int*,float*);
	float pfaeta4_(int*,float*);
	
}
//--------------------------------------
//
//
//--------------------------------------
TrkCluster::TrkCluster(){
	
	view     = 0;
	maxs     = 0;
	indmax   = 0;
	
	CLlength = 0;
	clsignal = 0; 
	clsigma  = 0; 
	cladc    = 0; 
	clbad    = 0; 

};
//--------------------------------------
//
//
//--------------------------------------
TrkCluster::~TrkCluster(){
	
	delete [] clsignal; 
	delete [] clsigma; 
	delete [] cladc; 
	delete [] clbad; 
};
//--------------------------------------
//
//
//--------------------------------------
TrkCluster::TrkCluster(const TrkCluster& t){
	
	view     = t.view;
	maxs     = t.maxs;
	indmax   = t.indmax;
	
	CLlength = t.CLlength;	
	clsignal = new Float_t[CLlength];
	clsigma  = new Float_t[CLlength];
	cladc    = new Int_t[CLlength];
	clbad    = new Bool_t[CLlength];
	for(Int_t i=0; i<CLlength;i++){
		clsignal[i] = t.clsignal[i]; 
		clsigma[i]  = t.clsigma[i]; 
		cladc[i]    = t.cladc[i]; 
		clbad[i]    = t.clbad[i]; 
	};

};
//--------------------------------------
//
//
//--------------------------------------
/**
 * Evaluate the cluster signal including a maximum number of adjacent 
 * strips, around maxs, having a significant signal. 
 * @param nstrip   Maximum number of strips.
 * @param cut      Inclusion cut ( s > cut*sigma ).
 * If nstrip<=0 only the inclusion cut is used to determine the cluster size.
 */
Float_t TrkCluster::GetSignal(Int_t nstrip, Float_t cut){
	
    Float_t s = 0;
    
    if( nstrip<=0 ){
// 	    for(Int_t is = 0; is < CLlength; is++){
// 		Float_t scut = cut*clsigma[is];
// 		if(clsignal[is] > scut) s += clsignal[is];
// 	    };
	for(Int_t is = indmax+1; is < CLlength; is++){
	    Float_t scut = cut*clsigma[is];
	    if(clsignal[is] > scut) s += clsignal[is];
	    else break;
	};
	for(Int_t is = indmax; is >=0; is--){
	    Float_t scut = cut*clsigma[is];
	    if(clsignal[is] > scut) s += clsignal[is];
	    else break;
	};
	return s;
    };
    
    
    Int_t il = indmax;
    Int_t ir = indmax;
    Int_t inc = 0;

    if( clsignal[indmax] < cut*clsigma[indmax] ) return 0;

    while ( inc < nstrip ){
	Float_t sl = -100000;
	Float_t sr = -100000;
	if( il >= 0       ) sl = clsignal[il];
	if( ir < CLlength ) sr = clsignal[ir];
	if( sl == sr && inc == 0 ){
	    s += clsignal[il]; //cout << inc<<" - "<< clsignal[il]<<" "<<s<<endl;
	    il--; 
	    ir++;
	}else if ( sl >= sr && sl > cut*clsigma[il] && inc !=0 ){
	    s += sl;//cout << inc<<" - "<< clsignal[il]<<" "<<s<<endl;
	    il--; 
	}else if ( sl < sr && sr > cut*clsigma[ir] ){
	    s += sr;//cout << inc<<" - " << clsignal[ir]<<" "<<s<<endl;
	    ir++;
	}else break;
	
	inc++;
    }
    return s;
};

/**
 including a ( maximum ) fixed number of adjacent strips (with s>0) around the maxs. 
 * @param nstrip Number of strips.
 */
/**
 * Evaluate the cluster signal-to-noise, as defined by Turchetta, including a maximum number of adjacent strips, around maxs, having a significant signal. 
 * @param nstrip   Maximum number of strips.
 * @param cut      Inclusion cut ( s > cut*sigma ).
 * If nstrip<=0 only the inclusion cut is used to determine the cluster size.
 */
Float_t TrkCluster::GetSignalToNoise(Int_t nstrip, Float_t cut){
	
    Float_t sn = 0;
    
    if( nstrip<=0 ){
	for(Int_t is = indmax+1; is < CLlength; is++){
	    Float_t scut = cut*clsigma[is];
	    if(clsignal[is] > scut) sn += clsignal[is]/clsigma[is];
	    else break;
	};
	for(Int_t is = indmax; is >=0; is--){
	    Float_t scut = cut*clsigma[is];
	    if(clsignal[is] > scut) sn += clsignal[is]/clsigma[is];
	    else break;
	};
	return sn;
    };
    
    
    Int_t il = indmax;
    Int_t ir = indmax;
    Int_t inc = 0;

    if( clsignal[indmax] < cut*clsigma[indmax] ) return 0;

    while ( inc < nstrip ){
	Float_t sl = -100000;
	Float_t sr = -100000;
	if( il >= 0       ) sl = clsignal[il];
	if( ir < CLlength ) sr = clsignal[ir];
	if( sl == sr && inc == 0 ){
	    sn += clsignal[il]/clsigma[il]; 
	    il--; 
	    ir++;
	}else if ( sl >= sr && sl > cut*clsigma[il] && inc !=0 ){
	    sn += sl/clsigma[il];
	    il--; 
	}else if ( sl < sr && sr > cut*clsigma[ir] ){
	    sn += sr/clsigma[ir];
	    ir++;
	}else break;
	
	inc++;
    }
    return sn;
};
/**
 * Evaluate the cluster multiplicity.
 * @param cut Inclusion cut.
 */
Int_t TrkCluster::GetMultiplicity(Float_t cut){
	Int_t m = 0;
	for(Int_t is = 0; is < CLlength; is++){
		Float_t scut = cut*clsigma[is];
		if(clsignal[is] > scut) m++;
	};
	return m;
};
/**
 * True if the cluster contains bad strips.
 * @param nbad Number of strips around the maximum.
 */
Bool_t TrkCluster::IsBad(Int_t nbad){
	
/*	Float_t max = 0;	
	Int_t  imax = 0;	
	for(Int_t is = 0; is < CLlength; is++){
		if(clsignal[is] > max){
			max = clsignal[is];
			imax = is;
		};
	};
	
	Int_t il,ir;
	il = imax;
	ir = imax;*/
	
	Int_t il,ir;
	il = indmax;
	ir = indmax;
	for(Int_t i=1; i<nbad; i++){
		     if (ir == CLlength && il == 0)break;
		else if (ir == CLlength && il != 0)il--;
		else if (ir != CLlength && il == 0)ir++;
		else{
			if(clsignal[il-1] > clsignal[ir+1])il--;
			else ir++;
		}
	}
	Int_t isbad = 0;
	for(Int_t i=il; i<=ir; i++)isbad += clbad[i];
	
	return ( isbad != nbad );
};
//--------------------------------------
//
//
//--------------------------------------
void TrkCluster::Dump(){

	cout << "----- Cluster" << endl;
	cout << "View "<<view << " - Ladder "<<GetLadder()<<endl;
	cout << "Position of maximun "<< maxs <<endl;
	cout << "Multiplicity        "<< GetMultiplicity() <<endl;
	cout << "Tot signal          "<< GetSignal() << " (ADC channels)"<<endl ;
	cout << "Signal/Noise        "<< GetSignalToNoise();
	cout <<endl<< "Strip signals       ";
	for(Int_t i =0; i<CLlength; i++)cout << " " <<clsignal[i];
	cout <<endl<< "Strip sigmas        ";
	for(Int_t i =0; i<CLlength; i++)cout << " " <<clsigma[i];
	cout <<endl<< "Strip ADC           ";
	for(Int_t i =0; i<CLlength; i++)cout << " " <<cladc[i];
	cout <<endl<< "Strip BAD           ";
	for(Int_t i =0; i<CLlength; i++){
		if(i==indmax)cout << "  *" <<clbad[i]<<"*";
		else cout << " " <<clbad[i];
	}
	cout << endl;
	
}
//--------------------------------------
//
//
//--------------------------------------
/**
 * Method to fill a level1 struct with only one cluster (done to use F77 p.f.a. routines on a cluster basis). 
 */
cTrkLevel1* TrkCluster::GetLevel1Struct(){
		
//    cTrkLevel1* l1 = new cTrkLevel1;

    cTrkLevel1* l1 = &level1event_ ;
	
    l1->nclstr1 = 1;
    l1->view[0] = view;
    l1->ladder[0] = GetLadder();
    l1->maxs[0] = maxs;
    l1->mult[0] = GetMultiplicity();
    l1->dedx[0] = GetSignal();
    l1->indstart[0] = 1;
    l1->indmax[0]   = indmax+1;
    l1->totCLlength = CLlength;
    for(Int_t i=0; i<CLlength; i++){
	l1->clsignal[i] = clsignal[i];
	l1->clsigma[i] = clsigma[i];
	l1->cladc[i] = cladc[i];
	l1->clbad[i] = clbad[i];
    };
    
    return l1;
};
//--------------------------------------
//
//
//--------------------------------------
/**
 * Evaluates the Center-Of-Gravity (COG) of the cluster, in strips, relative to the strip with the maximum signal (TrkCluster::maxs).
 *	@param ncog Number of strips to evaluate COG. 	
 * If ncog=0, the COG of the cluster is evaluated according to the cluster multiplicity (defined by the inclusion cut). 
 * If ncog>0, the COG is evaluated using ncog strips, even if they have a negative signal (according to G.Landi)
 */
Float_t TrkCluster::GetCOG(Int_t ncog){
	
    int ic = 1;
    GetLevel1Struct();
    return cog_(&ncog,&ic);
	
};
/**
 * Evaluates the Center-Of-Gravity (COG) of the cluster, in strips, relative to the strip with the maximum signal (TrkCluster::maxs), 
 * choosing the number of strips according to the angle, as implemented for the eta-algorythm .
 *	@param angle Projected angle in degree. 	
 */
Float_t TrkCluster::GetCOG(Float_t angle){
	    
    Int_t neta  = 0;

//     Float_t eta = GetETA(0,angle);
//     for(neta=2; neta<10; neta++) if( eta == GetETA(neta,angle) ) break;
//    if(eta != GetETA(neta,angle) )cout << "Attenzione!! pasticcio "<<endl;

    if( view%2 ){   //Y
	neta=2;
    }else{          //X
	if( fabs(angle) <= 10. ){
	    neta = 2;
	}else if( fabs(angle) > 10. && fabs(angle) <= 15. ){
	    neta = 3;
	}else{
	    neta = 4;
	};
    };

    return GetCOG(neta);
	
};
//--------------------------------------
//
//
//--------------------------------------
/**
 * Evaluates the cluster position, in strips, relative to the strip with the maximum signal (TrkCluster::maxs), by applying the non-linear ETA-algorythm. 
 *  @param neta  Number of strips to evaluate ETA.
 *  @param angle Projected angle between particle track and detector plane.
 * Implemented values of neta are 2,3,4. If neta=0, ETA2, ETA3 and ETA4 are applied according to the angle.
 */
Float_t TrkCluster::GetETA(Int_t neta, float angle){
	
//    cout << "GetETA(neta,angle) "<< neta << " "<< angle;
//	LoadPfaParam();

    float ax = angle;
    int ic = 1;
    GetLevel1Struct();
    if(neta == 0)      return pfaeta_(&ic,&ax);
    else if(neta == 2) return pfaeta2_(&ic,&ax);
    else if(neta == 3) return pfaeta3_(&ic,&ax);
    else if(neta == 4) return pfaeta4_(&ic,&ax);
    else cout << "ETA"<<neta<<" not implemented\n";
    return 0;
    
};
 
//--------------------------------------
//
//
//--------------------------------------
TrkLevel1::TrkLevel1(){
    	
    Cluster = new TClonesArray("TrkCluster");
    
    for(Int_t i=0; i<12 ; i++){
	good[i] = -1;
	for(Int_t j=0; j<24 ; j++){
	    cn[j][i]=0;
//	    cnrms[j][i]=0;
	    cnn[j][i]=0;
	};
    };
}
//--------------------------------------
//
//
//--------------------------------------
void TrkLevel1::Dump(){
    
    cout<<"DSP status: ";
    for(Int_t i=0; i<12 ; i++)cout<<good[i]<<" ";
    cout<<endl;
    cout<<"VA1 mask : "<<endl;
    for(Int_t i=0; i<12 ; i++){
	for(Int_t ii=0; ii<24 ; ii++){
	    Int_t mask = cnn[ii][i];
	    if(mask>0)mask=1;
	    cout<<mask<<" ";
	}
	cout <<endl;
    }
    
    TClonesArray &t  = *Cluster;
    for(int i=0; i<this->nclstr(); i++)     ((TrkCluster *)t[i])->Dump();
    
}
//--------------------------------------
//
//
//--------------------------------------
/**
 * Fills a TrkLevel1 object with values from a struct cTrkLevel1 (to get data from F77 common).
 */
void TrkLevel1::SetFromLevel1Struct(cTrkLevel1 *l1){

    //  *** CLUSTER ***
    TrkCluster* t_cl = new TrkCluster();
    TClonesArray &t = *Cluster;
    for(int i=0; i<l1->nclstr1; i++){
	
	t_cl->view     = l1->view[i];
	t_cl->maxs     = l1->maxs[i];
	t_cl->indmax   = l1->indmax[i] - l1->indstart[i];
	
	Int_t from = l1->indstart[i] -1;
	Int_t to   = l1->totCLlength ;
	if(i != l1->nclstr1-1)to   = l1->indstart[i+1] -1 ;
	t_cl->CLlength = to - from ;
	
	t_cl->clsignal = new Float_t[t_cl->CLlength];
	t_cl->clsigma  = new Float_t[t_cl->CLlength];
	t_cl->cladc    = new Int_t[t_cl->CLlength];
	t_cl->clbad    = new Bool_t[t_cl->CLlength];
	Int_t index = 0;
	for(Int_t is = from; is < to; is++ ){
	    t_cl->clsignal[index] = (Float_t) l1->clsignal[is];
	    t_cl->clsigma[index]  = (Float_t) l1->clsigma[is];
	    t_cl->cladc[index]    = (Int_t)   l1->cladc[is];
	    t_cl->clbad[index]    = (Bool_t)  l1->clbad[is];
	    index++;
	};
	
	new(t[i]) TrkCluster(*t_cl);
    };
    
    delete t_cl;
    
    //  ****general variables****
    
    for(Int_t i=0; i<12 ; i++){
	good[i] = l1->good[i];
	for(Int_t j=0; j<24 ; j++){
	    cn[j][i]     = l1->cnev[j][i];
//	    cnrms[j][i]  = l1->cnrmsev[j][i];
	    cnn[j][i]    = l1->cnnev[j][i];
	};
    };
    
}
/**
 * Fills a struct cTrkLevel1 with values from a TrkLevel1 object (to put data into a F77 common).
 */

cTrkLevel1* TrkLevel1::GetLevel1Struct() {
	
    cTrkLevel1 *l1=0;
	//
    for(Int_t i=0; i<12 ; i++){
	l1->good[i] = good[i];
	for(Int_t j=0; j<24 ; j++){
	    l1->cnev[j][i]    = cn[j][i];
// 	    l1->cnrmsev[j][i] = cnrms[j][i];
	    l1->cnnev[j][i]   = cnn[j][i];
	};
    };
    
//  *** CLUSTERS ***
    l1->nclstr1 =  Cluster->GetEntries();
    for(Int_t i=0;i<l1->nclstr1;i++){
	
	l1->view[i]     = ((TrkCluster *)Cluster->At(i))->view;
	l1->maxs[i]     = ((TrkCluster *)Cluster->At(i))->maxs;
	// COMPLETARE //
	// COMPLETARE //
	// COMPLETARE //
	// COMPLETARE //
	// COMPLETARE //
	// COMPLETARE //
	
    }
    // COMPLETARE //
    // COMPLETARE //
    // COMPLETARE //
    // COMPLETARE //
    // COMPLETARE //
    // COMPLETARE //
    return l1;
}
//--------------------------------------
//
//
//--------------------------------------
void TrkLevel1::Clear(){
    
    for(Int_t i=0; i<12 ; i++){
	good[i] = -1;
	for(Int_t j=0; j<24 ; j++){
	    cn[j][i]    = 0;
//	    cnrms[j][i] = 0;
	    cnn[j][i]   = 0;
	};
    };
    //
    Cluster->Clear();
    
}
//--------------------------------------
//
//
//--------------------------------------
void TrkLevel1::Delete(){
	
    for(Int_t i=0; i<12 ; i++){
	good[i] = -1;
	for(Int_t j=0; j<24 ; j++){
	    cn[j][i]    = 0;
//	    cnrms[j][i] = 0;
	    cnn[j][i]   = 0;
	};
    };
    //
    Cluster->Delete();
    
}

//--------------------------------------
//
//
//--------------------------------------
TrkCluster *TrkLevel1::GetCluster(int is){

	if(is >= this->nclstr()){
		cout << "** TrkLevel1::GetCluster(int) ** Cluster "<< is << " does not exits! " << endl; 
		cout << "( Stored clusters nclstr() = "<< this->nclstr()<<" )" << endl;
		return 0;
	}
	TClonesArray &t = *(Cluster);
	TrkCluster *cluster = (TrkCluster*)t[is];
	return cluster;
}
//--------------------------------------
//
//
//--------------------------------------
/**
 * Load Position-Finding-Algorythm parameters (call the F77 routine).
 * 
 */
int TrkLevel1::LoadPfaParam(TString path){
	
	if( strcmp(path_.path,path.Data()) ){
	    cout <<"Loading p.f.a. parameters\n";
	    strcpy(path_.path,path.Data());
	    path_.pathlen = path.Length();
	    path_.error   = 0;
	    return readetaparam_();
	}	
	return 0;
}


ClassImp(TrkLevel1);
ClassImp(TrkCluster);
