/**
 * \file TrkLevel0.cpp
 * \author Elena Vannuccini
 */
#include <TrkLevel0.h>
using namespace pamela::tracker;

/**
 * Pass values from the TrkLevel0 object to a struct cTrkLevel0 (to put data in F77 common).
 */
void TrkLevel0::GetCommonVar(cTrkLevel0 *l0) {
     
    Int_t countrk=0;

    l0->good0         = good0;
    l0->TOTDATAlength = TOTDATAlength;
    for(Int_t ii=0;ii<12;ii++){
	l0->DAQmode[ii]         = DAQmode[ii];
	l0->DSPnumber[ii]       = DSPnumber[ii];
	l0->DATAlength[ii]      = DATAlength[ii];
	l0->eventn[ii]          = eventn[ii];
	l0->nclust[ii]          = nclust[ii];
	l0->cutc[ii]            = cutc[ii];
	l0->cutcl[ii]           = cutcl[ii];
	for(Int_t iii=0;iii<3;iii++){
	    l0->addrcluster[iii][ii] = addrcluster[ii][iii];
	    l0->signcluster[iii][ii] = signcluster[ii][iii];
	};
	l0->fc[ii]              = fc[ii];
	l0->compressiontime[ii] = compressiontime[ii];
	l0->fl5[ii]             = fl5[ii];
	l0->fl4[ii]             = fl4[ii];
	l0->fl3[ii]             = fl3[ii];
	l0->fl2[ii]             = fl2[ii];
	l0->fl1[ii]             = fl1[ii];
	l0->fl6[ii]             = fl6[ii];
	l0->checksum[ii]        = checksum[ii];
	for(Int_t j=0;j<DATAlength[ii];j++){
	    l0->datatracker[countrk] = TrackerData.At(countrk);
	    ++countrk;
	};
	l0->pnum[ii]            = pnum[ii];
	l0->cmdnum[ii]          = cmdnum[ii];
	l0->bid[ii]             = bid[ii];
	l0->alarm[ii]           = alarm[ii];
	l0->aswr[ii]            = aswr[ii];
    };

    
}

