*************************************************************************
*     
*     Common level2.f
*     
*     contains LEVEL2 ntuple variables definitions
*     
*************************************************************************

      PARAMETER (NTRKMAX=10)    !
      PARAMETER (NSINGMAX=nclstrmax)

      integer good2
      integer vkflag            !viking-chip flag (-1:masked 0:CN-failure 1:ok) 
      integer ntrk              !# identified tracks
      integer image             !flag to tag track-images
      real al_nt                !track state vector
      real coval                !covariance matrix
      integer xgood_nt             !mask of used planes
      integer ygood_nt             !*
      integer ls                   !10*ladder+sensor
      integer xbad              !number of bad strips
      integer ybad              !"
      real xm_nt                   !measured points
      real ym_nt                   !*
      real zm_nt                   !*
      real resx_nt                 !spatial resolution
      real resy_nt                 !*
      real tailx_nt                 !spatial resolution
      real taily_nt                 !*
      real chi2_nt                 !chi2
      integer nstep_nt             !chi2
      real xv_nt                   !calculated points
      real yv_nt                  !*
      real zv_nt                  !*
      real axv_nt                 !calculated angles (deg)
      real ayv_nt                  !*
      real dedx_x               !signal in MIP scaled to 300 micrometer
      real dedx_y               !signal in MIP scaled to 300 micrometer
      integer cltrx             !cluster ID (to associate level2 and level1)
      integer cltry             !cluster ID (to associate level2 and level1)
      integer nclsx             !# unassociated clusters  X views
      integer planex            !plane of single x
      real xs                   !center coord of single x
      real sgnlxs               !signal in MIP of single x
      integer clsx              !cluster ID (to associate level2 and level1)
      integer nclsy             !     "            "      Y views
      integer planey            !plane of single y
      real ys                   !center coord of single y
      real sgnlys               !signal in MIP of single y
      integer clsy              !cluster ID (to associate level2 and level1)
      integer multmaxx          !cluster multiplicity and max strip
      integer multmaxy          !cluster multiplicity and max strip
      real    seedx             !cluster seed
      real    seedy             !cluster seed
      real    xpu               !cluster coordinate in pitch units
      real    ypu               !cluster coordinate in pitch units

      common/level2event/
     $      good2(12)
     $     ,vkflag(12,24)
     $     ,nclsx,planex(NSINGMAX),xs(2,NSINGMAX),sgnlxs(NSINGMAX)
     $     ,clsx(NSINGMAX) 
     $     ,nclsy,planey(NSINGMAX),ys(2,NSINGMAX),sgnlys(NSINGMAX)
     $     ,clsy(NSINGMAX) 
     $     ,ntrk
     $     ,image(NTRKMAX)
     $     ,xm_nt(nplanes,NTRKMAX)
     $     ,ym_nt(nplanes,NTRKMAX)
     $     ,zm_nt(nplanes,NTRKMAX)
     $     ,resx_nt(nplanes,NTRKMAX)
     $     ,resy_nt(nplanes,NTRKMAX)
     $     ,tailx_nt(nplanes,NTRKMAX)
     $     ,taily_nt(nplanes,NTRKMAX)
     $     ,al_nt(5,NTRKMAX)
     $     ,coval(5,5,NTRKMAX)
     $     ,chi2_nt(NTRKMAX)
     $     ,nstep_nt(NTRKMAX)
     $     ,xgood_nt(nplanes,NTRKMAX)
     $     ,ygood_nt(nplanes,NTRKMAX)
     $     ,ls(nplanes,NTRKMAX)
     $     ,xbad(nplanes,NTRKMAX)
     $     ,ybad(nplanes,NTRKMAX)
     $     ,xv_nt(nplanes,NTRKMAX)
     $     ,yv_nt(nplanes,NTRKMAX)
     $     ,zv_nt(nplanes,NTRKMAX)
     $     ,axv_nt(nplanes,NTRKMAX)
     $     ,ayv_nt(nplanes,NTRKMAX)
     $     ,dedx_x(nplanes,NTRKMAX)
     $     ,dedx_y(nplanes,NTRKMAX)
     $     ,cltrx(nplanes,NTRKMAX)
     $     ,cltry(nplanes,NTRKMAX)
     $     ,multmaxx(nplanes,NTRKMAX)
     $     ,multmaxy(nplanes,NTRKMAX)
     $     ,seedx(nplanes,NTRKMAX)
     $     ,seedy(nplanes,NTRKMAX)
     $     ,xpu(nplanes,NTRKMAX)
     $     ,ypu(nplanes,NTRKMAX)

      SAVE/level2event/
*********************************************************

