C     Parameter definition for the program 
C
C     momanhough.f
C
C     Author: Vannuccini Elena
C     Date: 2004/2005
C
c------------------------------------------------------------------------
c     CUTS and other parameters
c------------------------------------------------------------------------

c*****************************************************
cccccc 10/9/2005 modified by david fedele  --> (1)
c
cccccc20/10/2005 modified by elena         --> (2)
c     (rilasciati i tagli per la hough transform, 
c      in attesa dell'allineamento delle colonne)
c****************************************************

      PARAMETER (PIGR=3.14)     !159265359)!(1)
*     -----------------------------------------------------
*     cuts on cluster signal
*     -----------------------------------------------------
      parameter (dedx_x_min=70.)
      parameter (dedx_y_min=50.)
*     -----------------------------------------------------
*     number of GOOD strips around MAXS
*     (NB this cut has been removed in track fitting but 
*     not in calibration)
*     -----------------------------------------------------
*      parameter (ngoodstr=1)   
      parameter (ngoodstr=2)   

*     -----------------------------------------------------
*     first cuts on the parameters determined with 
*     the hough transform, in order to exclude from the 
*     following analysis not physical dublets and triplets
*     (out of the geometrical acceptance of the apparatus)
*     -----------------------------------------------------
      parameter (alfyz1_max=70.7) !Y0
      parameter (alfyz2_max=0.47) !tg theta-yz (25 deg)
      parameter (alfxz1_max=80.7) !X0
      parameter (alfxz2_max=0.47) !tg theta-xz (25 deg)
*     -----------------------------------------------------
*     cut on the position of the circle center:
*     center inside the spectrometer volume is not physical
*     ==> THE TRIPLET IS REJECTED
*     -----------------------------------------------------
      parameter (xclimit=8.)    !cm

*     -----------------------------------------------------
*     Parameter normalization constants, needed to evaluate
*     distances in parameter space
*     -----------------------------------------------------
      parameter (Dalfayz1=0.1689e-2)
      parameter (Dalfayz2=0.4813e-4)
      parameter (Dalfaxz1=0.1974e-2)
      parameter (Dalfaxz2=0.7978e-4)
      parameter (Dalfaxz3=1.)
*     -----------------------------------------------------
*     Cut on normalized distances in parameter space. 
*     Doublets/triplets are recursively included in a cloud 
*     if the distance from any of the points already included
*     is less than this cut.
*     -----------------------------------------------------
c      parameter (cutdistyz=10.) !y0 / tg theta_yz space
c      parameter (cutdistxz=30.) !x0 / tg theta_xz space
      parameter (cutdistyz=20.) !y0 / tg theta_yz space   !(2)
      parameter (cutdistxz=60.) !x0 / tg theta_xz space   !(2)
*     (NB deflection is not considered in the selection criteria)

*     --------------------------------------------------
*     cloud selection
*     --------------------------------------------------
*     minimum number of COUPLES required in order to select a cloud
c      parameter (ncpyz_min=3)   !for a straight line
c      parameter (ncpxz_min=4)   !for a circle
      parameter (ncpyz_min=3)   !for a straight line   !(2)
      parameter (ncpxz_min=3)   !for a circle          !(2)
*     minimum number of POINTS required in order to select a cloud
c      parameter (nptyz_min=3)   !for a straight line
c      parameter (nptxz_min=6)   !for a circle
      parameter (nptyz_min=3)   !for a straight line   !(2)
      parameter (nptxz_min=3)   !for a circle          !(2)
*     minimum number of PLANES required in order to select a cloud
c      parameter (nplyz_min=3)   !for a straight line
c      parameter (nplxz_min=4)   !for a circle
      parameter (nplyz_min=3)   !for a straight line   !(2)
      parameter (nplxz_min=3)   !for a circle          !(2)
*     --------------------------------------------------

*     -----------------------------------------------------
*     minimum number of matching couples required to combine
*     XZ-YZ clouds and perform the fit
*     -----------------------------------------------------
c      parameter (ncpok=4)
      parameter (ncpok=3)       !(2)

*     -----------------------------------------------------
*     maximum value of deflection from Hough transform
*     accepted in order to perform the track fit
*     -----------------------------------------------------
c      parameter (defmax=10.) !GV-1
c      parameter (defmax=10000.) !GV-1
      parameter (defmax=25.)    !GV-1

*     -----------------------------------------------------
*     cut to include new couple or single clusters in the
*     track fitting, after the first fit
*     -----------------------------------------------------
c      parameter (clinc=4)
c      parameter (clinc=6)
      parameter (clinc=10)


