*************************************************************************
*     
*     Common level1.f
*     
*     contains LEVEL1 ntuple variables definitions
*     
*     to be included in:
*     - ../reduction/reduction.f
*     - ../analysis/analysis.f
*     - !???
*     
*     parameters:
*     - nclstrmax
*     - nclstrp
*    
*     11/9/2005 modified by david fedele to include general variables
*************************************************************************

      integer good1             !flag to mark good or noise events
c$$$      integer nev1              !level1 event number
c$$$      integer which_calib1       !calibration file identifier. see DW_DATE_NUM_calib.txt file
c$$$      integer swcode1            !version of the software
c$$$
c$$$      integer pkt_type1         !CPU packet type identifier. see http://people.roma2.infn.it/~cpu/HB_list.txt
c$$$      integer pkt_num1          !CPU packet number
c$$$      integer obt1              !CPU on-board time
c$$$      integer cpu_crc1           !CPU crc controll

c     CLUSTER block:
      integer nclstr1           !cluster number
      integer view(nclstrmax)   !view the cluster belongs to
      integer ladder(nclstrmax) !ladder the strip carrying the largest signal 
                                ! value belongs to
      integer maxs(nclstrmax)   !cluster strip carrying the largest signal value
      integer mult(nclstrmax)   !cluster multiplicity
      real dedx(nclstrmax)      !cluster multiplicity
      integer indstart(nclstrmax) !cluster starting point index in clsignal array
      integer indmax(nclstrmax) !cluster maximum point index in clsignal array
      integer totCLlength       !sum of all clusters length (to assign
                                ! dimension to clsignal array)
      real clsignal(maxlength)  !signal values of all strips belonging to clusters

      real cnev(nviews,nva1_view) !common noise of the event for a certain view and
                                ! VA1
c$$$      common/level1general/good1,nev1,which_calib1,swcode1,crc1
c$$$      common/level1cpu/pkt_type1,pkt_num1,obt1,cpu_crc1
c$$$      common/level1cluster/nclstr1,view,ladder,maxs,mult,dedx,indstart
c$$$     $     ,indmax,totCLlength,clsignal,cnev


      common/level1event/good1,nclstr1,view,ladder,maxs
     $     ,mult,dedx,indstart
     $     ,indmax,totCLlength,clsignal,cnev
      
      SAVE/level1event/
