*************************************************************************
*     
*     Common level2.f
*     
*     contains LEVEL2 ntuple variables definitions
*     
*************************************************************************

      PARAMETER (NTRKMAX=10)    !
      PARAMETER (NSINGMAX=100)

      integer good2             !flag to mark good or noise events
      integer crc               !DSP crc controll
      integer ntrk              !# identified tracks
      integer image             !flag to tag track-images
      real al_nt                !track state vector
      real coval                !covariance matrix
      integer xgood_nt             !mask of used planes
      integer ygood_nt             !*
      real xm_nt                   !measured points
      real ym_nt                   !*
      real zm_nt                   !*
      real resx_nt                 !spatial resolution
      real resy_nt                 !*
      real chi2_nt                 !chi2
      real xv_nt                   !calculated points
      real yv_nt                  !*
      real zv_nt                  !*
      real axv_nt                 !calculated angles (deg)
      real ayv_nt                  !*
      real dedx_x               !signal in MIP scaled to 300 micrometer
      real dedx_y               !signal in MIP scaled to 300 micrometer
      real bdl
      integer nclsx             !# unassociated clusters  X views
      integer planex            !plane of single x
      real xs                   !center coord of single x
      real sgnlxs               !signal in MIP of single x
      integer nclsy             !     "            "      Y views
      integer planey            !plane of single y
      real ys                   !center coord of single y
      real sgnlys               !signal in MIP of single y

      common/level2event/
     $      good2,crc(12)
     $     ,nclsx,planex(NSINGMAX),xs(2,NSINGMAX),sgnlxs(NSINGMAX) !(2)
     $     ,nclsy,planey(NSINGMAX),ys(2,NSINGMAX),sgnlys(NSINGMAX) !(2)
     $     ,ntrk
     $     ,image(NTRKMAX)
     $     ,xm_nt(nplanes,NTRKMAX)
     $     ,ym_nt(nplanes,NTRKMAX)
     $     ,zm_nt(nplanes,NTRKMAX)
     $     ,resx_nt(nplanes,NTRKMAX)
     $     ,resy_nt(nplanes,NTRKMAX)
     $     ,al_nt(5,NTRKMAX)
     $     ,coval(5,5,NTRKMAX)
     $     ,chi2_nt(NTRKMAX)
     $     ,xgood_nt(nplanes,NTRKMAX)
     $     ,ygood_nt(nplanes,NTRKMAX)
     $     ,xv_nt(nplanes,NTRKMAX)
     $     ,yv_nt(nplanes,NTRKMAX)
     $     ,zv_nt(nplanes,NTRKMAX)
     $     ,axv_nt(nplanes,NTRKMAX)
     $     ,ayv_nt(nplanes,NTRKMAX)
     $     ,dedx_x(nplanes,NTRKMAX)
     $     ,dedx_y(nplanes,NTRKMAX)
     $     ,bdl(NTRKMAX)

      SAVE/level2event/
*********************************************************

