*************************************************************************
*     
*     Common calib.f
*     
*     contains CALIB variables definitions
*     
*     
*************************************************************************

      real incutx               !cut to include strips in cluster definition
      real incuty
      parameter (clcutx=7.)     !cluster seed cut 
      parameter (clcuty=6.)
      parameter (incutx=4.)     !cut to include strips in cluster definition
      parameter (incuty=4.)

c------------------------------------------------------------------------
c     
c     some parameters to configure data reduction
c     
c------------------------------------------------------------------------
c$$$      real clcutx               !cluster seed cut 
c$$$      real clcuty
c$$$      real incutx               !cut to include strips in cluster definition
c$$$      real incuty
      integer pfaid             !if of PFA 
      common/sw/
     $     pfaid
c$$$     $     ,clcutx,clcuty
c$$$     $     ,incutx,incuty

      save/sw/

c------------------------------------------------------------------------
c     
c     pedestal, sigma and badstrip variables
c     
c------------------------------------------------------------------------

      real pedestal(nviews,nva1_view,nstrips_va1) !pedestal value
      real pedestal_t(nviews,nva1_view,nstrips_va1) !pedestal truncated value

      real sigma(nviews,nva1_view,nstrips_va1) !sigma value
      real sigma_t(nviews,nva1_view,nstrips_va1) !sigma truncated value

      integer bad(nviews,nva1_view,nstrips_va1) !bad strip flag matrix
                                ! (bad=0 --> good strip, bad=1 --> bad strip)
                                ! NB this is different in 2003 test with respect
                                ! to previous analysis

      common/pedsigbad/pedestal,pedestal_t,sigma,sigma_t,bad
      save/pedsigbad/



c------------------------------------------------------------------------
c     
c     VA1-mask
c     
c------------------------------------------------------------------------
c     VA1 mask, from the DB
c      0 = force mask
c      1 = ---> run-by-run mask ---> event-by-event mask
c     -1 = ---> event-by-event mask
c     -------------------------------------
      integer mask_vk(nviews,nva1_view)    
c     -------------------------------------
c     VA1 mask run-by-run (set to 0 if <SIG> < SIG_min)
c      0 = force mask
c      1 = ---> event-by-event mask
c     -------------------------------------
      integer mask_vk_run(nviews,nva1_view)
c     -------------------------------------
c     VA1 mask event-by-event (set to 0 if CN computation fails)
c      0 = force mask
c      1 = search clusters 
c     -------------------------------------
      integer mask_vk_ev(nviews,nva1_view) 

      integer mask(nviews,nva1_view,nstrips_va1) !effective mask

*     set from outside F77 routines
      common/mask/mask_vk,mask_vk_run
      save/mask/
*     set event-by-event
      common/maskev/mask_vk_ev,mask

c------------------------------------------------------------------------
c     
c     eta2, eta3, eta4 pfa correction parameters
c     
c------------------------------------------------------------------------
*     angular binning
      parameter (nangmax=21)    !maximum number of angular bins
      integer nangbin
      real angL(nangmax),angR(nangmax) !Left and Right bin limits

      parameter (netavalmax=500)   !eta2 points 
      integer netaval
      real eta2(netavalmax,nangmax)
      real feta2(netavalmax,nviews,nladders_view,nangmax)
      real eta3(netavalmax,nangmax)
      real feta3(netavalmax,nviews,nladders_view,nangmax)
      real eta4(netavalmax,nangmax)
      real feta4(netavalmax,nviews,nladders_view,nangmax)
      real fcorr(nviews,nladders_view,nangmax)
*     limit of application of pfa
      real e2fax,e2tax,e3fax,e3tax,e4fax,e4tax
      real e2fay,e2tay,e3fay,e3tay,e4fay,e4tay
      

c$$$      common/angbinning/nangbin,angL,angR
c$$$      save/angbinning/
c$$$      common/pfa/netaval,eta2,feta2,eta3,feta3,eta4,feta4
c$$$      save/pfa/
    
      common/pfa/nangbin,angL,angR
     $     ,netaval,eta2,feta2,eta3,feta3,eta4,feta4
     $     ,fcorr
     $     ,e2fax,e2tax,e3fax,e3tax,e4fax,e4tax
     $     ,e2fay,e2tay,e3fay,e3tay,e4fay,e4tay
      save/pfa/

c$$$*     limit of application of pfa
c$$$      parameter (e2fax=0.)
c$$$      parameter (e2tax=10.)
c$$$      parameter (e3fax=10.)
c$$$      parameter (e3tax=15.)
c$$$      parameter (e4fax=90.)
c$$$      parameter (e4tax=90.)
c$$$
c$$$      parameter (e2fay=0.)
c$$$      parameter (e2tay=20.)
c$$$      parameter (e3fay=90.)
c$$$      parameter (e3tay=90.)
c$$$      parameter (e4fay=90.)
c$$$      parameter (e4tay=90.)

c------------------------------------------------------------------------
c     
c     CHARGE CORRELATION
c     
c------------------------------------------------------------------------

c      parameter (chcut=3.)      !cut to associate two clusters
c      parameter (chcut=4.)      !cut to associate two clusters
      parameter (chcut=50.)      !cut to associate two clusters
      parameter (chsatx=1700.)   !saturation limit 
      parameter (chsaty=2500.)   !saturation limit 
      parameter (chmipx=200.)   !mip limit 
      parameter (chmipy=200.)   !mip limit 
*     above saturation limit correlation conditions are not applied
      real kch(nplanes,nladders_view) !angular coeff
      real cch(nplanes,nladders_view) !const
      real sch(nplanes,nladders_view) !sigma
      common/chargeco/kch,cch,sch
      save/chargeco/
c------------------------------------------------------------------------
c     
c     MIP
c
c     (mip signal, scaled to 300 micron, in ADC channels)
c     
c------------------------------------------------------------------------
      real mip(nviews,nladders_view)
      common/adc2mip/mip
      save/adc2mip/
