/**
 * \file TrkLevel0.h
 * \author Elena Vannuccini
 */
#ifndef trklevel0_h
#define trklevel0_h

#include <TGraph.h>

#include <TObject.h>
#include <physics/tracker/TrackerEvent.h>
#include <TrkParams.h>
//#include <TrkStruct.h>

using namespace pamela::tracker;

/**
 * \brief Class to describe tracker LEVEL0 data. 
 *
 */

//class TrkLevel0 : public TrackerEvent{
class TrkLevel0 : public TObject{

 private:

    TrackerEvent* yodaobj;

 public:

    TrkLevel0(){ yodaobj = 0; };
    ~TrkLevel0(){ if(yodaobj) delete yodaobj; };
    void Set(){ yodaobj = new TrackerEvent(); };    

    void GetLevel0Struct(cTrkLevel0 *);
    void SetFromLevel0Struct(cTrkLevel0 *);
    void GetLevel0Struct(){ GetLevel0Struct(&level0event_); };
    void SetFromLevel0Struct(){ SetFromLevel0Struct(&level0event_); };
    
    bool FillADC();
    bool GetCalibratedEvent( int, TGraph* );
    bool GetCalibratedEvent( int iview){ return GetCalibratedEvent(iview,NULL); };

    void* GetPointerToTrackerEvent(){ return &yodaobj; };
    TrackerEvent* GetTrackerEvent(){ return yodaobj; }
    int ProcessEvent();
    void Decode(int from,int to,bool &COMPRESSED,bool &FULL, int* datacomp, int* datafull);
    bool GetFullEvent(int iview, TGraph* graph);
    bool GetCompressedEvent(int iview, TGraph* graph);
    bool GetUnCompressedEvent(int iview, TGraph* graph);
    bool GetSigma(int iview, TGraph* graph);
    
    ClassDef(TrkLevel0,1);
 
};

/**
 * \brief Struct to decode tracker words
 *
 */
typedef struct trkword{
  int type;
  int decode;
};

#endif
