/**
 * \file TrkCalib.h
 * \author Elena Vannuccini
 */
#ifndef trkcalib_h
#define trkcalib_h


#include <TObject.h>
#include <CalibTrk1Event.h>
#include <CalibTrk2Event.h>
#include <TString.h>
#include <TH1F.h>

using namespace pamela;
#include <iostream>
#include <math.h> // EMILIANO: needed to compile with ROOT > 5.16/x
using namespace std;
/**
 * \brief Class to describe tracker calibration data. 
 *
 */

/**
 * \brief Class to describe tracker-calibration cpu-packets
 *
 *  Each cpu packet stores calibration parameters of 6 tracker DSPs (views). 
 *  The class stores an object of the YODA-class CalibTrk1Event, which can be used to describe 
 *  both tracker-calibration cpu-packets (for X- and Y-views).
 *
 */
class TrkCalib : public TObject{

 private:

 public:

    CalibTrk1Event* calib1;


    TrkCalib();
    ~TrkCalib();


//    void Reset();

    Int_t GetView(Int_t ipkt);

    Int_t   EvaluatePar(TString what, Int_t ipkt, Int_t ivk, Float_t* result);
    Float_t GetMean(TString, Int_t, Int_t);
    Float_t GetRMS(TString, Int_t, Int_t);
    Float_t GetMean(TString what, Int_t ipkt){ return GetMean(what,ipkt,0); };
    Float_t GetRMS(TString what, Int_t ipkt) { return GetRMS(what,ipkt,0); };
    Float_t GetNBAD(Int_t, Int_t);
    Float_t GetNBAD(Int_t ipkt) { return GetNBAD(ipkt,0); };
    Float_t GetNGOOD(Int_t, Int_t);
    Float_t GetNGOOD(Int_t ipkt) { return GetNGOOD(ipkt,0); };
    
    Float_t* Get(TString, Int_t, Int_t);
    Float_t* Get(TString what, Int_t ipkt) { return Get(what,ipkt,0); };

    TH1F* GetHisto(TString, Int_t, Int_t, Int_t);
    TH1F* GetHisto(TString what, Int_t ipkt, Int_t ivk) { return GetHisto(what,ipkt,ivk,1); };
    TH1F* GetHisto(TString what, Int_t ipkt) { return GetHisto(what,ipkt,0,1); };

    void HeaderDump(Int_t);

    void* GetPointerTo(){ return &calib1;};

    CalibTrk1Event* Get(){ return calib1; };

    ClassDef(TrkCalib,1);
};

#endif
//____V@mail.ru
