/**
 * \file TrkHough.h				
 * \author David Fedele
 */
#ifndef trkhough_h
#define trkhough_h

#include <TObject.h>

#include <TrkStruct.h>
#include <TrkLevel2.h>
/**
 * \brief Class to describe Hough variables. 
 */
// ==================================================================
class TrkHough : public TObject {

 private:

 public:
  
    Int_t ndblt; ///< number of doublets
    Float_t *alfayz1; //[ndblt]
    Float_t *alfayz2; //[ndblt]
    Int_t *db_cloud;  //[ndblt]

    Int_t ntrpt; ///< number of triplets
    Float_t *alfaxz1; //[ntrpt]
    Float_t *alfaxz2; //[ntrpt]
    Float_t *alfaxz3; //[ntrpt]
    Int_t *tr_cloud;  //[ntrpt]

    Int_t nclouds_yz; ///< number of yz clouds
    Float_t *alfayz1_av; //[nclouds_yz]
    Float_t *alfayz2_av; //[nclouds_yz]
    Int_t *ptcloud_yz;  //[nclouds_yz]

    Int_t nclouds_xz; ///< number of xz clouds
    Float_t *alfaxz1_av; //[nclouds_xz]
    Float_t *alfaxz2_av; //[nclouds_xz]
    Float_t *alfaxz3_av; //[nclouds_xz]
    Int_t *ptcloud_xz;  //[nclouds_xz]

    Int_t nclstr;
    Float_t totaltime;
    Float_t houghtime;
    Float_t fittime;

/*   Int_t ntracks; ///< n. track-candidates */
/*   Float_t *al0; //[ntracks] */
/*   Float_t *al1; //[ntracks] */
/*   Float_t *al2; //[ntracks] */
/*   Float_t *al3; //[ntracks] */
/*   Float_t *al4; //[ntracks] */

    TClonesArray *Candidates;        ///< track candidates
  


    TrkHough();

    void SetFromHoughStruct(cTrkHough*,cTrkCandidates*);
    void SetFromHoughStruct(cTrkHough *lh){ SetFromHoughStruct(lh,NULL); };
    void SetFromHoughStruct(){SetFromHoughStruct(&houghevent_,&trackcandidates_); };
    void Clear();
    void Delete();
  
    TClonesArray* GetCandidateArray(){return Candidates;};///< returns pointer to the track array
    TrkTrack*     GetCandidate(int i);

    Int_t GetNCandidates(){return Candidates->GetEntries();}    ///< number of candidates;

    TrkHough* GetTrkHough(){return this;}

    ~TrkHough(){ Delete(); };
  
    ClassDef(TrkHough,2);

};

#endif
