***************************************************************************
*
*     Common for the track analysis, performed by the routine mini.f
*
***************************************************************************
c      PARAMETER (PIGR=3.141592654)!???????????????????

*     -------------------------------------------------------------------------
*     A TRACK is defined by: 
*     - the measured points associated to it 
*     - their spatial resolution 
*     - the track status vector AL-pha 
*     
*     This common must be filled when calling mini_2. After the fit, 
*     the initial values of AL-pha (initial guess, for instance from Hough) 
*     are replaced with the minimization result.
*
*     About the measured points:
*     - a COUPLE defines a point in the space; in this case you should set
*
*       XGOOD     = 1
*       YGOOD     = 1
*       XM,YM,ZM  = coordinates of the point in cm
*       RESX      = spatial resolution of cl-x
*       RESY      = spatial resolution of cl-y
*
*     - a SINGLET (single cluster x/y) defines a segment AB, parallel to 
*       the x/y strips; in this case you should set, for example in the case
*       of a cl-x:
*
*       XGOOD     = 1
*       YGOOD     = 0
*       ZM        = average z coordinate of the segment AB in cm
*       XM_A,YM_A = coordinates of extreme point A
*       XM_B,YM_B = coordinates of extreme point B
*       RESX      = spatial resolution of cl-x
*
*     NB!!! ZM must be always initialized, at least with the mechanical positions
*
*     (All the needed quantities for couples and singlets can be evaluated
*     by means of the routine xyz_PAM)
*     -------------------------------------------------------------------------


      REAL*8 AL
      REAL*8 XM,YM,ZM
      REAL*8 XM_A,YM_A!,ZM_A
      REAL*8 XM_B,YM_B!,ZM_B
      REAL*8 RESX,RESY
      REAL*8 TAILX,TAILY
      REAL*8 XGOOD,YGOOD
      REAL*8 DEDXTRK_X          
      REAL*8 DEDXTRK_Y         
      REAL*8 ZINI     ! ***PP***
      REAL*8 PFIXED   ! ***PP***
      REAL*8 CHI2
      REAL*8 XV,YV,ZV
      REAL*8 AXV,AYV
      REAL*8 COV
      REAL*8 FACT
      INTEGER NSTEP
      INTEGER IDCAND            
      INTEGER TRACKMODE
      INTEGER ISTEPMIN
      COMMON/TRACK/
     $      AL(5)                                      !track parameters
     $     ,XM(NPLANES),YM(NPLANES),ZM(NPLANES)        !couple    => xyz point 
     $     ,XM_A(NPLANES),YM_A(NPLANES)!,ZM_A(NPLANES) !single cl => segment AB
     $     ,XM_B(NPLANES),YM_B(NPLANES)!,ZM_B(NPLANES) !
     $     ,RESX(NPLANES),RESY(NPLANES)                !spatial resolution
     $     ,TAILX(NPLANES),TAILY(NPLANES)              !tails in the resolution
     $     ,XGOOD(NPLANES),YGOOD(NPLANES)              !mask of included views
c     $     ,DEDXTRK(NPLANES)                           !energy release
     $     ,DEDXTRK_X(NPLANES),DEDXTRK_Y(NPLANES) 
     $     ,ZINI
     $     ,PFIXED
     $     ,CHI2
     $     ,XV(NPLANES),YV(NPLANES),ZV(NPLANES)
     $     ,AXV(NPLANES),AYV(NPLANES)
     $     ,COV(5,5)
     $     ,FACT                ! factor scale for tracking precision
     $     ,NSTEP
     $     ,IDCAND              !(2) track-candidate ID (to relate some level1 info)
     $     ,TRACKMODE           ! tracking mode, 0=normal, 1=with bremsstrahlung 
     $     ,ISTEPMIN            ! minimum number of step during tracking
c******************************************************
cccccc 06/10/2005 modified by elena vannuccini ---> (1)
cccccc 17/08/2006 modified by elena vannuccini ---> (2)
c******************************************************


*     -------------------------------------------------------------------------
*     The FIT info includes:
*     - REDUCED chi2 
*     - number of d.o.f.
*     - evaluated coordinates (track intersection with the silicon planes)
*     - projected angles
*     - parameter covariance matrix
*     -------------------------------------------------------------------------
c$$$      REAL*8 ZINI     ! ***PP***
c$$$      REAL*8 PFIXED   ! ***PP***
c$$$      REAL*8 CHI2
c$$$      REAL*8 XV,YV,ZV
c$$$      REAL*8 AXV,AYV
c$$$      REAL*8 COV
c$$$      COMMON/FIT_INFO/
c$$$     $      ZINI
c$$$     $     ,PFIXED
c$$$     $     ,CHI2
c$$$     $     ,XV(NPLANES),YV(NPLANES),ZV(NPLANES)
c$$$     $     ,AXV(NPLANES),AYV(NPLANES)
c$$$     $     ,COV(5,5)            



*     -------------------------------------------------------------------------
*     Other commons needed by the minimization procedures:
*     -------------------------------------------------------------------------
*     computation of chi^2 and its derivatives
      REAL*8 DAL
      REAL*8 CHI2D,CHI2DOLD,CHI2DD       !first and second derivatives of chi^2 
      REAL*8 DXDAL,DYDAL        !first derivatives of x and y on AL-pha 
      REAL*8 STEPAL             !
***PP***      REAL*8 ZINI               !z coordinate of reference plane
      COMMON/MINICOM/
     $      DAL(5)
     $     ,CHI2D(5),CHI2DOLD(5),CHI2DD(5,5)
     $     ,DXDAL(NPLANES,5),DYDAL(NPLANES,5)
     $     ,STEPAL(5)
***PP***     $     ,ZINI

*     -------------------------------------------------------------------------
*     convergence conditions 
      REAL*8 ALTOL              !tolerances on AL-pha parameters
      REAL*8 ALMAX,ALMIN        !maximum and minimum value for AL-pha parameters
      INTEGER ISTEPMAX          !maximum number of steps      
      COMMON/MINICON/
     $      ALTOL(5)
     $     ,ALMAX(5),ALMIN(5)
     $     ,ISTEPMAX


*     -------------------------------------------------------------------------
*     variables for the tracking (routine posxy)
      REAL*8 VECT,VECTINI,VOUT  !vectors for Runge-Kutta method
      REAL*8 TOLL               !tolerance from plane
      REAL*8 STEPMAX            !maximum number of steps
      REAL*8 CHARGE             !sign of electric charge
      COMMON/TRACKING/VECT(7),VECTINI(7),VOUT(7),TOLL,STEPMAX,
     $     CHARGE

     
