
C     These are the common blocks used in 
C
C     momanhough.f
C
C     Author: Vannuccini Elena
C     Date: 2004/2005
C

c      include 'level1.f'
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
c     SPEP 1                          CLUSTERS ----> COUPLES and SINGLETS
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
c     
c     Variables to associate X and Y clusters in each plane
c     according to 
c     * geometrical criteria 
c     * charge correlation
c     
c------------------------------------------------------------------------

*     maximum (total) number of STORED clusters
      parameter (nclstrmax_level2 = nclstrmax) ! same as level1

*     -----------------------------------------------------------
*     maximum number of cluster (per view) required to perform
*     track serching with full Hough transform
*     (singlets recovered during track refinement)
      parameter (nclusterlimit=6) 
*     -----------------------------------------------------------
*     maximum number of couples (per plane) required to perform
*     track serching with full Hough transform
*     (couples recovered during track refinement)
      parameter (ncouplelimit=8)

*     -----------------------------------------------------------
*     maximum number of STORED couples, per plane and total 
*     (to dimension the vectors)
c      parameter (ncouplemax=2*(nclstrmax_level2/nplanes)**2)
c      parameter (ncouplemaxtot=ncouplemax*nplanes)
       parameter (ncouplemax    = nclusterlimit*nclusterlimit)
       parameter (ncouplemaxtot = ncouplemax*nplanes)
*     -----------------------------------------------------------
*     maximum number of STORED couples
*     (if the identified couples exceeds this number the 
*     track identification is not performed and the event is 
*     tagged as not good)
c      parameter (ncp_max=10*nplanes)
c      parameter (ncp_max=10*nplanes)
c      parameter (ncp_max        = ncouplemaxtot)



*     -----------------------------------------------------------
*     mask of views
*     0 = ok
*     1 = n.clusters > nclusterlimit     
*     8 = n.couples  > ncouplelimit
*     2 = n.couples  > ncouplemax
*     3 = n.doublets > ndblt_max
*     4 = n.triplets > ntrpt_max
*     5 = n.clouds yz > ncloyz_max
*     6 = n.clouds xz > ncloxz_max
*     7 = n.track candidates > NTRACKSMAX
      integer mask_view(nviews)
      common/maskview/mask_view


*     -----------------------------------------------------------
*     --- CLUSTERS ----------------------------------------------
*     -----------------------------------------------------------
*     mask for GOOD cluster 
*      1 = good
*      0 = bad 
*     (- the three central strips should have BAD=0) NOT ANY MORE!
*     - the charge should be greater than 
*       DEDX_X_MIN and DEDX_Y_MIN respectivelly
      integer cl_good(nclstrmax_level2)  
*     -----------------------------------------------------------
*     mask for clusters associated to a track
*      1 = used
*      0 = not used
      integer cl_used(nclstrmax_level2)
      integer ncl_view(nviews)  !n.clusters per plane
*     -----------------------------------------------------------
      common/clusters/cl_good,cl_used,ncl_view

*     -----------------------------------------------------------
*     --- COUPLES -----------------------------------------------
*     -----------------------------------------------------------
*     Clusters are associated to form couples.
*     The j-th couple on i-th plane is formed by
*     clusters numbers CLX(i,j) and CLY(i,j)
      integer clx(nplanes,ncouplemax),cly(nplanes,ncouplemax)
*     number of couples
      integer ncp_plane(nplanes) !per plane
      integer ncp_tot            !total
*     -----------------------------------------------------------
*     COMMENT:
*     the  REAL number of couples is NCP_TOT, however the VIRTUAL 
*     number of couples is 2*NCP_TOT becouse of the 
*     ambiguity in Y view (2 sensors)
*     Each real couples has two images: one on sensor 1, 
*     the other on sensor 2
*     -----------------------------------------------------------
      common/couples/clx,cly,ncp_plane,ncp_tot
*     -----------------------------------------------------------
*     FUNCTIONS to retrieve couple info     
*     
*     id_cp(ip,icp,is) -- returns a GLOBAL couple ID, 
*                         given the plane, the sensor, 
*                         and the couple id  relative to the plane
*                         ID < 0 if sensor =1
*                         ID > 0 if sensor =2
*
*     Given the global couple ID:
*
*     ip_cp(id)        -- returns the plane number
*     is_cp(id)        -- returns the plane number
*     icp_cp(id)       -- returns the id number relative to the plane
*     -----------------------------------------------------------


*     -----------------------------------------------------------
*     --- SINGLETS ----------------------------------------------
*     -----------------------------------------------------------
*     single clusters, not associated in any couple
      integer ncls(nplanes)
      integer cls(nplanes,nclstrmax_level2)
*     -----------------------------------------------------------
*     mask for clusters not inlcuded in a couple
*      1 = single
*      0 = non single
      integer cl_single(nclstrmax_level2) 
*     -----------------------------------------------------------
      common/singlets/ncls,cls,cl_single


c+ + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c------------------------------------------------------------------------
c     HOUGH-TRANSFORM parameters
c------------------------------------------------------------------------
c + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +
c+ + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + + +

c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
c     SPEP 2                          COUPLES ----> DOUBLETS and TRIPLETS
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
c     
c     Variables to associate couples in 
C     
c     DOUBLETS for Y-Z view  
c     TRIPLETS for X-Z view
c     
c     The 3D particle track can be approximated with a straight line 
c     in the Y-Z view and with a circle sector in the X-Z view. 
c     The Hough trasform is applied independently to the two views. 
c     The parameters of the projected tracks are evaluated for each 
c     combination of points (doublets in YZ and triplets in XZ).
c     
c     Hence track candidates will be identified by looking for
c     "clusters" of points (CLOUDS) in the parameter space. 
c
c------------------------------------------------------------------------
      parameter (ndblt_max=5000)         !maximum number of doublets
      parameter (ntrpt_max=10*ndblt_max) !maximum number of triplets
*     -----------------------------------------------------------
*     number of doublets and triplets
      integer ndblt,ntrpt
*     -----------------------------------------------------------
*     List of couple absolute IDs that form doublets and triplets
      integer cpyz1(ndblt_max),cpyz2(ndblt_max)
      integer cpxz1(ntrpt_max),cpxz2(ntrpt_max),cpxz3(ntrpt_max)
*     -----------------------------------------------------------
*     parameters of the projected tracks
      real
     $     alfayz1(ndblt_max),  !Y0
     $     alfayz2(ndblt_max)   !tg theta-yz
      real
     $     alfaxz1(ntrpt_max),  !X0
     $     alfaxz2(ntrpt_max),  !tg theta-xz
     $     alfaxz3(ntrpt_max)   !1/r
*     -----------------------------------------------------------
      common/hough_param/
     $     alfayz1,  !Y0
     $     alfayz2,  !tg theta-yz
     $     alfaxz1,  !X0
     $     alfaxz2,  !tg theta-xz
     $     alfaxz3   !1/r
      common/doublets/ndblt,cpyz1,cpyz2
      common/triplets/ntrpt,cpxz1,cpxz2,cpxz3

c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
c     SPEP 3                 DOUBLETS and TRIPLETS ----> YZ and XZ-CLOUDS 
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
c     
c     Variables to group doublets and triplets in CLOUDS, according to 
c     their relative distance in parameter space.
c     The association is done indipendently on YZ and XZ views.
c
c------------------------------------------------------------------------      
      parameter (ncloyz_max=200)!maximum number of clouds
      parameter (ncloxz_max=200)!  "
*     -----------------------------------------------------------
*     Number of YZ and XZ clouds
      integer nclouds_yz,nclouds_xz
*     -----------------------------------------------------------
*     mask to store combinations of couples selected as clouds  
*     NOTATION:
*     0 = not selected
*     1 = selected couple image in SENSOR 1
*     2 = selected couple image in SENSOR 2
*     3 = selected both images
      integer cpcloud_yz(ncloyz_max,ncouplemaxtot)
      integer cpcloud_xz(ncloxz_max,ncouplemaxtot)
*     -----------------------------------------------------------
*     doublet and triplet ID in the selected clouds
      integer db_cloud(ndblt_max)
      integer tr_cloud(ntrpt_max)
*     -----------------------------------------------------------
*     number of points in the cloud
      integer ptcloud_yz(ncloyz_max)
      integer ptcloud_xz(ncloxz_max)
*     -----------------------------------------------------------
*     average parameters
      real alfayz1_av(ncloyz_max),alfayz2_av(ncloyz_max)
      real alfaxz1_av(ncloxz_max),alfaxz2_av(ncloxz_max)
     $     ,alfaxz3_av(ncloxz_max)
      common/clouds_yz/                   
     $     nclouds_yz                        
     $     ,alfayz1_av,alfayz2_av           
     $     ,ptcloud_yz,db_cloud,cpcloud_yz       
      common/clouds_xz/                   
     $      nclouds_xz                        
     $     ,alfaxz1_av,alfaxz2_av,alfaxz3_av 
     $     ,ptcloud_xz,tr_cloud,cpcloud_xz           

c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
c     SPEP 4                      YZ and XZ-CLOUDS ----> TRACK CANDIDATES 
c+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
c     
c     Variables to store information about track-candidates,
c     evaluated by combining YZ and XZ clouds.
c
c     NB ! ! !
c     
c     While until now the plane number followed the mechanical notation 
c     (1 to 6, from bottom to top), variables related to the tracks
c     are referred to the mini notation (1 to 6, from top to bottom)
c
c------------------------------------------------------------------------      

*     -----------------------------------------------------
*     default p.f.a. 
*     used to fit track candidates
*     -----------------------------------------------------
      character*5 PFAdef
      parameter (PFAdef='COG1')

c------------------------------------------------------------------------
c     variable related to track selection and fitting
c------------------------------------------------------------------------

*     track candidates
      PARAMETER (NTRACKSMAX=ncloyz_max*ncloxz_max)
      INTEGER NTRACKS           !number of track candidates
      REAL AL_STORE(5,NTRACKSMAX)
      REAL XM_STORE(NPLANES,NTRACKSMAX)
      REAL YM_STORE(NPLANES,NTRACKSMAX)
      REAL ZM_STORE(NPLANES,NTRACKSMAX)
      REAL RESX_STORE(NPLANES,NTRACKSMAX)
      REAL RESY_STORE(NPLANES,NTRACKSMAX)
      REAL XV_STORE(NPLANES,NTRACKSMAX)
      REAL YV_STORE(NPLANES,NTRACKSMAX)
      REAL ZV_STORE(NPLANES,NTRACKSMAX)
      REAL AXV_STORE(NPLANES,NTRACKSMAX)
      REAL AYV_STORE(NPLANES,NTRACKSMAX)
      REAL XGOOD_STORE(NPLANES,NTRACKSMAX)
      REAL YGOOD_STORE(NPLANES,NTRACKSMAX)
      INTEGER CP_STORE(NPLANES,NTRACKSMAX)
      INTEGER CLS_STORE(NPLANES,NTRACKSMAX)
      INTEGER SENSOR_STORE(NPLANES,NTRACKSMAX)
      INTEGER LADDER_STORE(NPLANES,NTRACKSMAX)
      REAL BX_STORE(NPLANES,NTRACKSMAX)
      REAL BY_STORE(NPLANES,NTRACKSMAX)
      REAL RCHI2_STORE(NTRACKSMAX)
      common/track_candidates/NTRACKS,AL_STORE
     $     ,XV_STORE,YV_STORE,ZV_STORE
     $     ,XM_STORE,YM_STORE,ZM_STORE
     $     ,RESX_STORE,RESY_STORE
     $     ,AXV_STORE,AYV_STORE
     $     ,XGOOD_STORE,YGOOD_STORE
     $     ,CP_STORE,CLS_STORE,SENSOR_STORE,LADDER_STORE
     $     ,BX_STORE,BY_STORE
     $     ,RCHI2_STORE


*     best-candidate selection 
      PARAMETER (CHI2MAX=15)



c------------------------------------------------------------------------
c     CUTS and other parameters
c------------------------------------------------------------------------
      PARAMETER (PIGR=3.14)     !159265359)!(1)
*     -----------------------------------------------------
*     cuts on cluster signal
*     -----------------------------------------------------
      parameter (dedx_x_min=0.)
      parameter (dedx_y_min=0.)
*     -----------------------------------------------------
*     number of GOOD strips around MAXS
*     (NB this cut has been removed in track fitting but 
*     not in calibration)
*     -----------------------------------------------------
      parameter (ngoodstr=2)   
*     -----------------------------------------------------
*     first cuts on the parameters determined with 
*     the hough transform, in order to exclude from the 
*     analysis non physical dublets and triplets
*     (out of the geometrical acceptance of the apparatus)
*     -----------------------------------------------------
*     geometrical acceptance whit 6 planes               
c$$$      parameter (alfyz1_max=8.7)  !Y0  (real acc+1cm)    
c$$$      parameter (alfyz2_max=0.47) !tg theta-yz (18+7deg) 
c$$$      parameter (alfxz1_max=9.5)  !X0  (real acc+1cm)    
c$$$      parameter (alfxz2_max=0.47) !tg theta-xz (18+7deg) 

c$$$*     geometrical acceptance whit the last 5 planes      
c$$$      parameter (alfyz1_max=12.4) !Y0  (real acc+1cm)   
c$$$      parameter (alfyz2_max=0.55) !tg theta-yz (22+7deg) 
c$$$      parameter (alfxz1_max=13.7) !X0  (real acc+1cm)    
c$$$      parameter (alfxz2_max=0.55) !tg theta-xz (22+7deg) 
c$$$
c$$$*     geometrical acceptance whit the last 4 planes      
c$$$      parameter (alfyz1_max=18.6) !Y0  (real acc+1cm)   
c$$$      parameter (alfyz2_max=0.70) !tg theta-yz (28+7deg)
c$$$      parameter (alfxz1_max=20.6) !X0  (real acc+1cm)   
c$$$      parameter (alfxz2_max=0.70) !tg theta-xz (28+7deg)
c$$$
*     geometrical acceptance whit the last 3 planes     
      parameter (alfyz1_max=31.0) !Y0  (real acc+1cm)   
      parameter (alfyz2_max=1.04) !tg theta-yz (39+7deg) 
      parameter (alfxz1_max=34.4) !X0  (real acc+1cm)   
      parameter (alfxz2_max=1.04) !tg theta-xz (39+7deg) 
*     -----------------------------------------------------
*     cut on the position of the circle center:
*     center inside the spectrometer volume is not physical
*     ==> THE TRIPLET IS REJECTED
*     -----------------------------------------------------
      parameter (xclimit=8.)    !cm
*     -----------------------------------------------------
*     Parameter normalization constants, needed to evaluate
*     distances in parameter space
*     -----------------------------------------------------

*     --- David ground 
c$$$      parameter (Dalfayz1=0.8864e-1) 
c$$$      parameter (Dalfayz2=0.6204e-3) 
c$$$      parameter (Dalfaxz1=0.2909e-1) 
c$$$      parameter (Dalfaxz2=0.2759e-2) 
*     --- David flight 
      parameter (Dalfayz1=0.64e-3) 
      parameter (Dalfayz2=0.54e-3) 
      parameter (Dalfaxz1=0.50e-3) 
      parameter (Dalfaxz2=0.12e-3) 
      parameter (Dalfaxz3=0.86e-5)


*     -----------------------------------------------------
*     Cut on normalized distances in parameter space. 
*     Doublets/triplets are recursively included in a cloud 
*     if the distance from any of the points already included
*     is less than this cut.
*     -----------------------------------------------------
*     --- David ground 
c$$$      parameter(cutystart=0.3)   
c$$$      parameter(cutystep=0.3)    
c$$$      parameter(cutxstart=1.) 
c$$$      parameter(cutxstep=1.)  
c$$$      parameter(maxcuty=100.) 
c$$$      parameter(maxcutx=150.) 
c$$$      parameter(nstepx=50)     !inclusion-cut increasing steps
c$$$      parameter(nstepy=50) 
*     --- David flight (preliminary)
c$$$      parameter(cutystart=7.)   
c$$$      parameter(cutystep=5.)              
c$$$      parameter(cutxstart=5.) 
c$$$      parameter(cutxstep=2.)  
c$$$      parameter(maxcuty=200.) 
c$$$      parameter(maxcutx=150.)  
c$$$      parameter(nstepx=5)       !inclusion-cut increasing steps
c$$$      parameter(nstepy=5)      
*     --- David flight 
      parameter(cutystart=30.)   
      parameter(cutystep=10.)              !buoni???
      parameter(cutxstart=5.) 
      parameter(cutxstep=2.)  
      parameter(maxcuty=1000.) 
      parameter(maxcutx=1000.)  
      parameter(nstepx=10)     !inclusion-cut increasing steps
      parameter(nstepy=30) 


      real cutdistyz            !y0 / tg theta_yz space   
      real cutdistxz            !x0 / tg theta_xz space   
      common/cutdi/cutdistyz,cutdistxz
*     (NB deflection is not considered in the selection criteria) 
*     --------------------------------------------------
*     cloud selection
*     --------------------------------------------------
      parameter(x_min_start=4) 
      parameter(x_min_step=1)  
      
      integer ncpxz_min 
      integer nptxz_min         !for a circle        
      integer nplxz_min         !for a circle       

      common/cutxclouds/ncpxz_min,nptxz_min,nplxz_min 

      parameter(y_min_start=3) 

      integer ncpyz_min       
      integer nptyz_min         !for a straight line 
      integer nplyz_min         !for a circle        
      common/cutyclouds/ncpyz_min,nptyz_min,nplyz_min
*     --------------------------------------------------

*     -----------------------------------------------------
*     minimum number of matching couples required to combine
*     XZ-YZ clouds and perform the fit
*     -----------------------------------------------------
      parameter (ncpok=3)      

*     -----------------------------------------------------
*     maximum value of deflection from Hough transform
*     accepted in order to perform the track fit
*     -----------------------------------------------------
c      parameter (defmax=10000.) !GV-1 
      parameter (defmax=100.) !GV-1 

*     -----------------------------------------------------
*     cut to include new couple or single clusters in the
*     track fitting, after the first fit
*     -----------------------------------------------------
c      parameter (clinc=3)
      parameter (clinc=7)



