/**
 * \file TrkLevel1.h
 * \author Elena Vannuccini
 */
#ifndef trklevel1_h
#define trklevel1_h

#include <TObject.h>
#include <TClonesArray.h>
#include <TRef.h>

#include <TrkStruct.h>

/**
 * \brief Class to describe tracker clusters. 
 *
 * A cluster is defined as a group of adjacent strips whose signals exceed noise by xxxx sigma
 */
// ==================================================================
class TrkCluster : public TObject {

private:


public:
	
	int view;
	int ladder;
	int maxs;
	int mult;
	float sgnl;
	
	int whichtrk;

	Int_t         CLlength;
	Float_t      *clsignal; //[CLlength]
	Float_t      *clsigma;  //[CLlength]
	Int_t        *cladc;    //[CLlength]
	Bool_t       *clbad;    //[CLlength]
		
    TrkCluster();
	~TrkCluster();
    TrkCluster(const TrkCluster&);

    void Dump();
	
    TrkCluster* GetTrkCluster(){return this;};

    friend class TrkLevel1;

    ClassDef(TrkCluster,1);

};

/**
 * \brief Class to describe tracker LEVEL1 data.
 *
 */
class TrkLevel1 : public TObject {

 private:

 public:

	Int_t         good1;
//	Int_t         crc[12];
	 
    TClonesArray *Cluster;        ///< clusters
		
	Float_t       cnev[24][12];
	Int_t         cnnev[24][12];
	Int_t         fshower[12];
	
    TrkLevel1();

	int nclstr() {return Cluster->GetEntries();}    ///< number of stored clusters

    void Dump();
    void SetFromLevel1Struct(cTrkLevel1 *);
	void GetLevel1Struct(cTrkLevel1 *) const;
    void Clear();

    TrkCluster*   GetCluster(int);
    
    TrkLevel1*    GetTrkLevel1(){return this;}
    TClonesArray* GetClusters(){return Cluster;};///< returns pointer to the cluster array
    
    ClassDef(TrkLevel1,1);

};

/**
 * \brief Classes to relate LEVEL1 data to LEVEL2.
 *
 */
// class TrkTrackRef : public TObject {
// 	public:
// 		TRef clx[6];
// 		TRef cly[6];
// 		
// 		TrkTrackRef();
// 		TrkTrackRef(const TrkTrackRef&);
// 		void Clear();
// 		
// 		ClassDef(TrkTrackRef,1);
// };
// class TrkLevel2Ref : public TObject {
// 
// 	public:
// 
// 		TClonesArray *Track;        ///< fitted tracks
// 		TClonesArray *SingletX;     ///< x singlets
// 		TClonesArray *SingletY;     ///< y singlets
// 		
// 		TrkLevel2Ref();
// 		void TrkLevel2Ref::SetFromLevel2Struct(cTrkLevel2 *l2);
// 		void Clear();
// 		
// 		ClassDef(TrkLevel2Ref,1);
// };


#endif
