

************************************************************************
*     
*     Common common_reduction.f
*     
*     contains variables used only in the execution of  reduction
*     
*     to be included in:
*     - reduction.f
*     
*     
*************************************************************************

      real adc(nviews,nva1_view,nstrips_va1)
      common/adc_value/adc

c------------------------------------------------------------------------
c     
c     common noise computation
c     
c------------------------------------------------------------------------
      parameter (scut=4.)!(scut=3.)
      parameter (NSTRIPMIN=10)!(NSTRIPMIN=64)!(NSTRIPMIN=10)!TEMPORANEO

      real    cn(nviews,nva1_view)      ! common noise values
      integer cnn(nviews,nva1_view)     ! >0 = number of strips used for cn computation
c                                          0 = failed  (less than NSTRIPMIN strips used) => temporarily masked
c                                         -1 = masked a-priori
      integer mask_vk_ev(nviews,nva1_view) ! mask of VA1s, local to the event (set to 0 if CN computation fails)

      integer clstr(nviews,nva1_view,nstrips_va1) !flag matrix to mark 
                                ! strips with signal and exclude them from
                                ! common noise computation
      integer strange(nviews,nva1_view,nstrips_va1) !flag matrix to mark 
                                ! strips with unusually high or low signal and
                                ! exclude them from common noise computation

      common/cn/cn,cnn,mask_vk_ev,clstr,strange

c------------------------------------------------------------------------
c     
c     common noise inclusion cut
c     
c------------------------------------------------------------------------
      parameter (cnincut=2.)    !cut to include strips in cluster definition
                                ! during common noise computation
c------------------------------------------------------------------------
c
c     some common for reductionflight
c
c------------------------------------------------------------------------

c     parameter (nclstrmax=1000) !maximum number of clusters per event

      integer ind
      real value(nstrips_view)  !per trovare i cluster
      real clseedcut(nstrips_view)
      real clinclcut(nstrips_view)
      common/searchcluster/value,clseedcut,clinclcut,ind

c     added by Elena (08/2006)
      integer nclstr_view            !number of clusters per view
      integer ladder_view(nclstrmax) !ladder the strip carrying the largest signal 
                                     ! value belongs to
      integer maxs_view(nclstrmax)   !cluster strip carrying the largest signal value
      integer mult_view(nclstrmax)   !cluster multiplicity
      integer rmax_view(nclstrmax)
      integer lmax_view(nclstrmax)
      common/clustersperview/nclstr_view,ladder_view,maxs_view
     $     ,mult_view,rmax_view,lmax_view

      integer nshowers
      logical flag_shower
      common/shower/nshowers,flag_shower
