/**
 * \file TrkProcess.h
 * \author Elena Vannuccini
 */
#ifndef trkprocess_h
#define trkprocess_h

#include <TrkStruct.h>
#include <TrkLevel0.h> 

#include <TString.h>
#include <TSystem.h>
#include <iostream>

// extern "C" {
//     extern struct cTrkCalib  pedsigbad_;
//     extern struct cTrkLevel0 level0event_;
//     extern struct cTrkLevel1 level1event_;
//     extern struct cTrkLevel2 level2event_;
//     extern struct cPath      path_;
//     extern struct cBPath     bpath_;
//     extern struct cDbg       dbg_;
// //    int fillpedsigfromdefault_();
//     int readmipparam_(); 
//     int readchargeparam_(); 
//     int readvkmask_(); 
//     int readalignparam_(); 
//     int readetaparam_(); 
//     void reductionflight_(int*);
//     int analysisflight_();
// }

/**
 * \brief Class to handle input parameters for tracker data processing 
 *
 */
// ==================================================================

class TrkProcess{

private:
	
public:

    ULong64_t idrun;
    Bool_t    get1;
    Bool_t    get2;
    TString   frame1;
    TString   frame2;	
    Bool_t    ifroot1;
    Bool_t    ifroot2;
    Bool_t    standalone;
//    Bool_t    DEBUG;
//    Bool_t    VERBOSE;
    TString   file1;
    TString   file2;
    TString   outdir; 
    TString   pfolder; 
    cDbg      dbg_mode;
//    int       F77err;
    Int_t     ostatus; ///< output status
    
    TrkProcess();
    
    TrkProcess(ULong64_t run, TFile *f2);
    
    void SetDebugMode()  {dbg_mode.SetDebug();   dbg_=dbg_mode;};
    void SetVerboseMode(){dbg_mode.SetVerbose(); dbg_=dbg_mode;};
    void SetWarningMode(){dbg_mode.SetWarning(); dbg_=dbg_mode;};
    
    bool DebugMode(){return dbg_mode.debug;};
    bool WarningMode(){return dbg_mode.warning;};
    bool VerboseMode(){return dbg_mode.verbose;};
    
    void HandleCustomPar(int ncustom, char* vcustom[]);
    
    void ProcessEvent(TrkLevel0*);
    
    void Dump();
    
    
};


#endif


