/**
 * \file TrkProcess.h
 * \author Elena Vannuccini
 */
#ifndef trkprocess_h
#define trkprocess_h

#include <TString.h>
#include <TSystem.h>
#include <iostream>

/**
 * \brief Class to handle input parameters for tracker data processing 
 *
 */
// ==================================================================

class TrkProcess{

private:
	
public:
	
    ULong64_t idrun;
    Bool_t get1;
    Bool_t get2;
    TString frame1;
    TString frame2;	
    Bool_t ifroot1;
    Bool_t ifroot2;
    Bool_t standalone;
    Bool_t DEBUG;
    TString file1;
    TString file2;
    TString outdir; 
    TString pfolder; 
    
    TrkProcess();
    TrkProcess(ULong64_t run, TFile *f2);
    int HandleCustomPar(int ncustom, char* vcustom[]);
    void Dump();
    
};


#endif


