/**
 * \file TrkStruct.h
 * \author Elena Vannuccini
 * \date
 */
#ifndef trkstruct_h
#define trkstruct_h

#define NTRKMAX 10
#define NSINGMAX 100

#include <TString.h>
#include <TFile.h>

/**
 * \brief Struct to pass calibration data to F77 routines
 */
struct cTrkCalib { 
    float pedestal[128][24][12];
    float pedestal_t[128][24][12];
    float sigma[128][24][12];
    float sigma_t[128][24][12];
    int bad[128][24][12];
	
	void FillFrom(TFile* , Int_t , Int_t );
};
// ==================================================================
/**
 * \brief Struct to pass tracker LEVEL0 data to F77 routines
 */
struct cTrkLevel0 {
    int DAQmode[12];
    int DSPnumber[12];
    int DATAlength[12];
    int eventn[12];
    int nclust[12];
    int cutc[12];
    int cutcl[12];
    int addrcluster[3][12];
    int signcluster[3][12];
    int fc[12];
    int compressiontime[12];
    int fl5[12]; 
    int fl4[12];
    int fl3[12];
    int fl2[12];
    int fl1[12];
    int fl6[12];
    int checksum[12];
    int TOTDATAlength;
    int datatracker[49152];
    int pnum[12];    
    int cmdnum[12];
    int bid[12];
    int alarm[12];
    int aswr[12]; 
    int good0;
    int crc[12]; 
};
// ==================================================================
/**
 * \brief Struct to pass tracker LEVEL1 data to F77 routines
 */
struct cTrkLevel1 {
    int good1;
    int nclstr1;
    int view[500];
    int ladder[500];
    int maxs[500];
    int mult[500];
    float dedx[500];
    int indstart[500];
    int indmax[500];
    int totCLlength;
    float clsignal[8500];
    float cnev[24][12];  
};
// ==================================================================
/**
 * \brief Struct to pass tracker LEVEL2 data to F77 routines
 */
struct cTrkLevel2 {
    int good2;
    int crc[12];
//  ----------------------------
    int nclsx;
    int planex[NSINGMAX];
    float xs[NSINGMAX][2];
    float signlxs[NSINGMAX];
//  ----------------------------
    int nclsy;
    int planey[NSINGMAX];
    float ys[NSINGMAX][2];
    float signlys[NSINGMAX];
//  ----------------------------
    int ntrk;
    int image[NTRKMAX];
    float xm_nt[NTRKMAX][6];
    float ym_nt[NTRKMAX][6];
    float zm_nt[NTRKMAX][6];
    float resx_nt[NTRKMAX][6];
    float resy_nt[NTRKMAX][6];
    float al_nt[NTRKMAX][5];
    float coval[NTRKMAX][5][5];
    float chi2_nt[NTRKMAX];
    int xgood_nt[NTRKMAX][6];
    int ygood_nt[NTRKMAX][6];
    float xv_nt[NTRKMAX][6];
    float yv_nt[NTRKMAX][6];
    float zv_nt[NTRKMAX][6];
    float axv_nt[NTRKMAX][6];
    float ayv_nt[NTRKMAX][6];
    float dedx_x[NTRKMAX][6];
    float dedx_y[NTRKMAX][6];
    float bdl[NTRKMAX];
};
// ==================================================================
/**
 * \brief Struct to pass calibration/parameter file paths to F77 routines
 */
struct cPath {
    char path[80];
    int  pathlen;
	int  error;
	int  debug;
/**
 * Fill the struct variables from a TString object
 */
    void FillWith(TString s){
		pathlen = s.Length();
		const char *pc = s.Data();
		for(Int_t i=0; i<=pathlen; i++) path[i] = *pc++;
    };
	
	void SetDebug(){ debug=1;};
	
};

// ==================================================================
/**
 * \brief Struct to pass magnetic-field file paths to F77 routines
 */
struct cBPath {
    char b_path[80];
    int  b_pathlen;
    int  b_error;
    int  b_debug;
    int  b_loaded;
/**
 * Fill the struct variables from a TString object and set 
 * the load flag to FALSE.
 */
    void FillWith(TString s){
	b_loaded  = 0;
	b_pathlen = s.Length();
	const char *pc = s.Data();
	for(Int_t i=0; i<=b_pathlen; i++) b_path[i] = *pc++;
    };
/**
 * Fill the struct variables from a TString object
 */
    int BIsLoaded(){ return b_loaded; };
	void SetDebug(){ b_debug=1; };
	
};


#endif

