/**
 * \file TrkProcess.h
 * \author Elena Vannuccini
 */
#ifndef trkprocess_h
#define trkprocess_h

#include <TrkStruct.h>
#include <TrkParams.h>
#include <TrkLevel0.h> 

#include <TString.h>
#include <TSystem.h>
#include <iostream>

#define NPARMAX 20

/**
 * \brief Class to handle input parameters for tracker data processing 
 *
 */
// ==================================================================

class TrkProcess{

private:
	
public:

    ULong64_t idrun;
    Bool_t    get1;
    Bool_t    full1;
    Bool_t    get2;
    Bool_t    geth;
    TString   frame1;
    TString   frame2;	
    TString   frameh;	
    Bool_t    ifroot1;
    Bool_t    ifroot2;
    Bool_t    ifrooth;
    Bool_t    standalone;
//    Bool_t    DEBUG;
//    Bool_t    VERBOSE;
    TString   file1;
    TString   file2;
    TString   outdir; 
    TString   pfolder; 
//    cDbg      dbg_mode;
//    int       F77err;
    Int_t     ostatus; ///< output status

    UInt_t    nskip; ///< n.event to be skipped

    Int_t   npar;
    Int_t   partype[NPARMAX];
    TString parpath[NPARMAX];
    
    TrkProcess();
    
    TrkProcess(ULong64_t run, TFile *f2);
    
/*     void SetDebugMode()  {TrkParams::SetDebugMode(); dbg_mode.SetDebug();   dbg_=dbg_mode;}; */
/*     void SetVerboseMode(){TrkParams::SetVerboseMode(); dbg_mode.SetVerbose(); dbg_=dbg_mode;}; */
/*     void SetWarningMode(){TrkParams::SetWarningMode();dbg_mode.SetWarning(); dbg_=dbg_mode;}; */
    
/*     bool DebugMode(){return dbg_mode.debug;}; */
/*     bool WarningMode(){return dbg_mode.warning;}; */
/*     bool VerboseMode(){return dbg_mode.verbose;}; */
    
    int  HandleCustomPar(int ncustom, char* vcustom[]);
    
    void ProcessEvent(TrkLevel0*);
    
    void Dump();
    void PrintHelp();
    
};


#endif


