/**
 * \file TrkProcess.cpp
 * \author Elena Vannuccini
 */
#include <TrkProcess.h>
#include <iostream>
using namespace std;
/**
 * Create TrkProcess object, initializing the tracker processing variables at default values
 */
TrkProcess::TrkProcess(){
    
    idrun = 0;
    dbg_mode.SetNone();
    get1  = 0;
    full1 = 0;
    geth  = 0;
    get2  = 1;
    standalone = false;
    frame2 = "root";
    frame1 = "root";
    frameh = "root";
    outdir =  gSystem->WorkingDirectory(); 
    pfolder = "/TrackerFolder"; 
    if      (!frame2.CompareTo("root", TString::kIgnoreCase))  ifroot2 = true;		
    else if (!frame2.CompareTo("hbook", TString::kIgnoreCase)) ifroot2 = false;
    
    if      (!frame1.CompareTo("root", TString::kIgnoreCase))  ifroot1 = true;		
    else if (!frame1.CompareTo("hbook", TString::kIgnoreCase)) ifroot1 = false;

    if      (!frameh.CompareTo("root", TString::kIgnoreCase))  ifrooth = true;		
    else if (!frameh.CompareTo("hbook", TString::kIgnoreCase)) ifrooth = false;

    file1 = "";
    file2 = "";
    
    ostatus = 0;

    TrkParams::SetTrackingMode();
    TrkParams::SetPrecisionFactor(); 
    TrkParams::SetStepMin();   
    TrkParams::SetPFA();
};
	
/**
 * Create TrkProcess object, initializing the tracker processing variables according to input parameters.
 * @param run Run ID
 * @param f2 Pointer to output level2 file
 */
TrkProcess::TrkProcess(ULong64_t run, TFile *f2){
	
    idrun = run;
//    DEBUG = false;
//    VERBOSE = false;
    dbg_mode.SetWarning();
    get1  = 0;
    full1 = 0;
    get2 = 1;
    geth = 0;
    standalone = false;
    frame2 = "root";
    frame1 = "root";
    frameh = "root";
    pfolder = "/TrackerFolder"; 
    file1 = "";
    if(f2->IsOpen()){
	file2  = f2->GetPath();
	outdir = gSystem->DirName(gSystem->DirName(file2));
	// check if the indicated output directory exists
	FileStat_t t;
	if( gSystem->GetPathInfo(outdir.Data(),t) )throw -12;
    }else{ 
	file2 = "";    
	outdir =  gSystem->WorkingDirectory();
    }; 

    if      (!frame2.CompareTo("root", TString::kIgnoreCase))  ifroot2 = true;		
    else if (!frame2.CompareTo("hbook", TString::kIgnoreCase)) ifroot2 =false;
    
    if      (!frame1.CompareTo("root", TString::kIgnoreCase))  ifroot1 = true;		
    else if (!frame1.CompareTo("hbook", TString::kIgnoreCase)) ifroot1 =false;

    if      (!frameh.CompareTo("root", TString::kIgnoreCase))  ifrooth = true;		
    else if (!frameh.CompareTo("hbook", TString::kIgnoreCase)) ifrooth =false;

    ostatus = 0;
	
    TrkParams::SetTrackingMode();
    TrkParams::SetPrecisionFactor(); 
    TrkParams::SetStepMin();   
    TrkParams::SetPFA();

};
/**
 * Set processing variables according to input custom parameters
 */	
void TrkProcess::HandleCustomPar(int ncustom, char *vcustom[]){

    for (int i=0; i< ncustom; i++){

	// -----------------------------------------------------//
	if (!strcmp(vcustom[i], "-processFolder")){
	    if (++i >= ncustom) throw -3;
	    pfolder = vcustom[i];
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--get1") || !strcmp(vcustom[i], "--get-level1") ){
	    get1  = 1;	
	    full1 = 0;
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--get1-full") || !strcmp(vcustom[i], "--get-level1-full") ){
	    get1  = 1;	    
	    full1 = 1;
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--geth") || !strcmp(vcustom[i], "--get-hough") ){
	    geth = 1;
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--dontget2") ||!strcmp(vcustom[i], "--dontget-level2") ){
	    get2 = 0;
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--standalone") || !strcmp(vcustom[i], "-s")){
	    standalone = true;
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "-processFile1")){
	    if (++i >= ncustom) throw -3;
	    get1 = 1;
	    file1 = vcustom[i];
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "-frame1")){
	    if (++i >= ncustom)throw -3;
	    get1 = 1;
	    frame1 = vcustom[i];						
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "-frame2")){
	    if (++i >= ncustom)throw -3;
	    get2 = 1;
	    frame2 = vcustom[i];
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--verbose") || !strcmp(vcustom[i], "-v")){
//	    VERBOSE = true;
	    this->SetVerboseMode();
	    continue;
	}
	// -----------------------------------------------------//    
	else if (!strcmp(vcustom[i], "--debug") || !strcmp(vcustom[i], "-d")){
//	    DEBUG = true;
	    this->SetDebugMode();
	    continue;
	};
    }	
        	
    if      (!frame2.CompareTo("root", TString::kIgnoreCase))  ifroot2 = true;		
    else if (!frame2.CompareTo("hbook", TString::kIgnoreCase)) ifroot2 =false;
    else    throw -201;
    
    if      (!frame1.CompareTo("root", TString::kIgnoreCase))  ifroot1 = true;		
    else if (!frame1.CompareTo("hbook", TString::kIgnoreCase)) ifroot1 =false;
    else    throw -201;
   	
    if      (!frameh.CompareTo("root", TString::kIgnoreCase))  ifrooth = true;		
    else if (!frameh.CompareTo("hbook", TString::kIgnoreCase)) ifrooth =false;
    else    throw -201;

    if(get1 && !get2)full1=true;

    ostatus = 0;

};
/**
 * \brief Process Level0 event
 * @param l0_event Pointer to an object of the tracker level0 class
 * Starting from a Level0 object, this routine fills the level0 common, then calls 
 * the fortran routines, which process the event and fill level1 and level2 commons.
 */
void TrkProcess::ProcessEvent(TrkLevel0 *l0_event){

    // fill Level0 common from Level0 object
//    l0_event->GetCommonVar(&level0event_);
    l0_event->GetLevel0Struct();
    // process the event Level0->Level1->Level2
    int F77err = 0;
    //
    reductionflight_(&F77err);
    if(F77err < 0)throw F77err;
    //
//    int pfa=0; //<<< ETA
//    int pfa=14;//<<< COG4
//    if(get2) analysisflight_(&pfa); 
    if(get2) analysisflight_();
    //
    ostatus = F77err;
    
};
		
void TrkProcess::Dump(){

    cout <<endl<< "Tracker process parameters: "<< endl;
    cout << " idRun           " << idrun << endl;
    cout << " get level1      " << get1 << endl;
    cout << " full level1     " << full1 << endl;
    cout << " get level2      " << get2 << endl;
    cout << " get hough       " << geth << endl;
    cout << " frame1          " << frame1 << endl;
    cout << " frame2          " << frame2 << endl;
    cout << " frameh          " << frame2 << endl;
    cout << " file1           " << file1 << endl;
    cout << " file2           " << file2 << endl;
    cout << " outdir          " << outdir << endl;
    cout << " process folder  " << pfolder << endl;
    cout << " standalone mode " << standalone << endl;
    cout << " debug mode      warning " << dbg_mode.warning << endl;
    cout << " debug mode      verbose " << dbg_mode.verbose << endl;
    cout << " debug mode      debug   " << dbg_mode.debug << endl << endl;
    
}
