/**
 * \file TrkLevel0.cpp
 * \author Elena Vannuccini
 */
#include <TrkLevel0.h>

using namespace pamela::tracker;

/**
 * Pass values from the TrkLevel0 object to a struct cTrkLevel0 (to put data in F77 common).
 */
//void TrkLevel0::GetCommonVar(cTrkLevel0 *l0) {
void TrkLevel0::GetLevel0Struct(cTrkLevel0 *l0) {
     
    Int_t countrk=0;

    l0->good0         = yodaobj->good0;
    l0->TOTDATAlength = yodaobj->TOTDATAlength;
    for(Int_t ii=0;ii<12;ii++){
	l0->DAQmode[ii]         = yodaobj->DAQmode[ii];
	l0->DSPnumber[ii]       = yodaobj->DSPnumber[ii];
	l0->DATAlength[ii]      = yodaobj->DATAlength[ii];
	l0->eventn[ii]          = yodaobj->eventn[ii];
	l0->nclust[ii]          = yodaobj->nclust[ii];
	l0->cutc[ii]            = yodaobj->cutc[ii];
	l0->cutcl[ii]           = yodaobj->cutcl[ii];
	for(Int_t iii=0;iii<3;iii++){
	    l0->addrcluster[iii][ii] = yodaobj->addrcluster[ii][iii];
	    l0->signcluster[iii][ii] = yodaobj->signcluster[ii][iii];
	};
	l0->fc[ii]              = yodaobj->fc[ii];
	l0->compressiontime[ii] = yodaobj->compressiontime[ii];
	l0->fl5[ii]             = yodaobj->fl5[ii];
	l0->fl4[ii]             = yodaobj->fl4[ii];
	l0->fl3[ii]             = yodaobj->fl3[ii];
	l0->fl2[ii]             = yodaobj->fl2[ii];
	l0->fl1[ii]             = yodaobj->fl1[ii];
	l0->fl6[ii]             = yodaobj->fl6[ii];
	l0->checksum[ii]        = yodaobj->checksum[ii];
	for(Int_t j=0;j<yodaobj->DATAlength[ii];j++){
	    l0->datatracker[countrk] = yodaobj->TrackerData.At(countrk);
	    ++countrk;
	};
	l0->pnum[ii]            = yodaobj->pnum[ii];
	l0->cmdnum[ii]          = yodaobj->cmdnum[ii];
	l0->bid[ii]             = yodaobj->bid[ii];
	l0->alarm[ii]           = yodaobj->alarm[ii];
	l0->aswr[ii]            = yodaobj->aswr[ii];
    };

    
}
/**
 * Pass values from the TrkLevel0 object to a struct cTrkLevel0 (to put data in F77 common).
 */
void TrkLevel0::SetFromLevel0Struct(cTrkLevel0 *){ 
    
    cout<<"void TrkLevel0::SetFromLevel0Struct(cTrkLevel0 *) -- not implemented"<<endl;
    
};
/**
 * Method to call the F77 routine that performs level0->level1 processing.
 * The level1 output is stored in a common block, which can be retrieved 
 * by mean of the method TrkLevel1::SetFromLevel1Struct().
 */
int TrkLevel0::ProcessEvent(){

//    cout << "int TrkLevel0::ProcessEvent()" << endl;
    TrkParams::Load(6);
    if( !TrkParams::IsLoaded(6) ){
	cout << "int TrkLevel0::ProcessEvent() -- ERROR -- VK-mask not loaded"<<endl;
	return 0;
    };
    TrkParams::LoadCalib( );
    if( !TrkParams::CalibIsLoaded() ){
	cout << "int TrkLevel0::ProcessEvent() -- ERROR -- Calibration not loaded"<<endl;
	return 0;
    };

    GetLevel0Struct();
    int F77err = 0;
    reductionflight_(&F77err);
    if(F77err < 0){
	cout << "int TrkLevel0::ProcessEvent() -- ERROR -- from F77 routine"<<endl;
	return 0;
    }
//    cout << "...done"<<endl;
    
    return 1;

}

ClassImp(TrkLevel0);
