*************************************************************************
*     
*     Common common_B_inner.f
*     
*     to be included in:
*     - ../magnet/read_B_inner.f
*     - ../magnet/inter_B.f
*     - ../magnet/inter_B_inner.f
*     
*************************************************************************

c      implicit double precision (a-h,o-z)


      parameter (nx=29, ny=23, nz=101) !number of measures along X, Y and Z axes

c     coordinates in m of the edges of the volume in which the field
c     is interpolated according to the inner maps
      parameter (edgexmin=-0.085,edgexmax=0.085
     $     ,edgeymin=-0.07,edgeymax=0.07
     $     ,edgezmin=-0.26,edgezmax=0.26)

************
c     first map
      real*8 px1(nx,3),py1(ny,3),pz1(nz,3) !coordinates of measure points:
c     e.g. py1(ny,1) = Y coordinates of Bx (=1) component of magnetic field

      real*8 b1(nx,ny,nz,3)     !magnetic field values:
c     e.g. b1(nx,ny,nz,2) = By (=2) component of magnetic field measured in (nx, ny, nz)

      real*8 px1max(3),px1min(3),py1max(3),py1min(3),pz1max(3),pz1min(3) !grid edges

      common/interpolation1/px1,py1,pz1,b1
     $     ,px1max,px1min,py1max,py1min,pz1max,pz1min

************
c     second map
      real*8 px2(nx,3),py2(ny,3),pz2(nz,3)
      real*8 b2(nx,ny,nz,3)
      real*8 px2max(3),px2min(3),py2max(3),py2min(3),pz2max(3),pz2min(3) !grid edges

      common/interpolation2/px2,py2,pz2,b2
     $     ,px2max,px2min,py2max,py2min,pz2max,pz2min

*************************************************************************
*     
*     Common common_B_outer.f
*     
*     to be included in:
*     - ../magnet/read_B_outer.f
*     - ../magnet/inter_B.f
*     - ../magnet/inter_B_outer.f
*     
*************************************************************************

c      implicit double precision (a-h,o-z)


c     number of measures along X, Y and Z axes
      parameter (nox=13, noy=13, noz=4) 

c     coordinates in m of the edges of the volume in which the field
c     is interpolated according to the inner maps
c     UPPER VOLUME
      parameter (edgeuxmin=-0.18)
      parameter (edgeuxmax=0.18)
      parameter (edgeuymin=-0.18)
      parameter (edgeuymax=0.18)
      parameter (edgeuzmin=0.28)
      parameter (edgeuzmax=0.37)
c     LOWER VOLUME
      parameter (edgelxmin=edgeuxmin)
      parameter (edgelxmax=edgeuxmax)
      parameter (edgelymin=edgeuymin)
      parameter (edgelymax=edgeuymax)
      parameter (edgelzmin=-0.37)
      parameter (edgelzmax=-0.28)

************


c     MAGNETIC-FIELD MAP
      real*8 pox(nox,3),poy(noy,3),poz(noz,3) !coordinates of measure points:
c     e.g. py1(ny,1) = Y coordinates of Bx (=1) component of magnetic field

      real*8 bo(nox,noy,noz,3)     !magnetic field values:
c     e.g. b1(nx,ny,nz,2) = By (=2) component of magnetic field measured in (nx, ny, nz)

      real*8 poxmax(3),poxmin(3),poymax(3),poymin(3),pozmax(3),pozmin(3) 
c     grid edges

      common/interpolationo/pox,poy,poz,bo
     $     ,poxmax,poxmin,poymax,poymin,pozmax,pozmin


      SAVE/interpolation1/
      SAVE/interpolation2/
      SAVE/interpolationo/




