*************************************************************************
*     
*     Common level1.f
*     
*     contains LEVEL1 ntuple variables definitions
*     
*     to be included in:
*     - ../reduction/reduction.f
*     - ../analysis/analysis.f
*     - !???
*     
*     parameters:
*     - nclstrmax
*     - nclstrp
*    
*     11/9/2005 modified by david fedele to include general variables
*     **/8/2006 modified to store info about CN computation and "showers"
*************************************************************************

      parameter (nclstrmax_view = 200) ! maximum number of clusters per view
      parameter (nclstrmax      = nclstrmax_view * nviews)
      parameter (nclstrp        = 19)  ! maximum number of stored strips per cluster
      parameter (maxlength      = nclstrmax * nclstrp) 

      integer good1             !flag to mark good or noise events

c     CLUSTER block:
      integer nclstr1           !cluster number
      integer view(nclstrmax)   !view the cluster belongs to
      integer ladder(nclstrmax) !ladder the strip carrying the largest signal 
                                ! value belongs to
      integer maxs(nclstrmax)   !cluster strip carrying the largest signal value
      integer mult(nclstrmax)   !cluster multiplicity
      real dedx(nclstrmax)      !cluster multiplicity
      integer indstart(nclstrmax) !cluster starting point index in clsignal array
      integer indmax(nclstrmax) !cluster maximum point index in clsignal array
      integer totCLlength       !sum of all clusters length (to assign
                                ! dimension to clsignal array)
      real clsignal(maxlength)  !signal values of all strips belonging to clusters

      real clsigma(maxlength)
      integer cladc(maxlength)
      integer clbad(maxlength)
c      real clped(maxlength)

      real    cnev(nviews,nva1_view)     !CN of the event for a certain view and VA1
      integer cnnev(nviews,nva1_view)    !n.strips used for CN computation 
      integer fshower(nviews)            !flag to tag views with too many clusters
c                                        !(in this case clusters are not saved)
      integer whichtrack(nclstrmax)      !flag to relate the cluster to the track it belongs to
      common/level1event/good1,nclstr1,view,ladder,maxs
     $     ,mult,dedx,indstart
     $     ,indmax,totCLlength,clsignal,clsigma,cladc,clbad!,clped
     $     ,cnev,cnnev,fshower,whichtrack
      
      SAVE/level1event/
