************************************************************************
*     
*     Common commontracker.f
*     
*     contains tracker general variables definitions
*     
*     to be included in:
*     - ../readraw/readraw.F
*     - ../reduction/reduction.f
*     - ../reduction/fillpedsig.f
*     - ../reduction/filladc.f
*     - ../reduction/cncomp.f
*     - ../reduction/cnoise.f
*     - ../reduction/cutcn.f
*     - ../analysis/preanalysis.f
*     - ../analysis/analysis.f
*     - ../align/align.f
*     - ../magnet/read_B.f
*     - !???
*     
*     parameters:
*     - !???
*     
*************************************************************************
c------------------------------------------------------------------------
c     
c     spectrometer parameters
c     
c------------------------------------------------------------------------
      parameter (nviews=12)     !number of views
      parameter (nplanes=nviews/2) !number of planes
      parameter (nladders_view=3) !number of ladders per view
      parameter (nva1_ladder=8) !number of VA1s per ladder (per side)
      parameter (nstrips_va1=128) !number of strips per VA1

      parameter (nstrips_ladder=nstrips_va1*nva1_ladder) !number of strips per ladder
      parameter (nva1_view=nva1_ladder*nladders_view) !number of VA1s per view
      parameter (nstrips_view=nstrips_va1*nva1_view) !number of strips per view
      parameter (nva1=nva1_view*nviews) !number of VA1s
      parameter (nstrips=nstrips_va1*nva1) !number of strips

      double precision pitchX
      parameter (pitchX=51.)    !strip pitch in um
      double precision pitchY
      parameter (pitchY=66.5)

      double precision SiDimX
      parameter (SiDimX=53330.)  !Si sensor dimensions in um
      double precision SiDimY
      parameter (SiDimY=70000.)
      double precision SiDimZ
      parameter (SiDimZ=300.)

*     edges of the sensitive areas, in X and Y
      double precision edgeX_l
      parameter (edgeX_l=731.5) ! X side
      double precision edgeX_r
      parameter (edgeX_r=731.5) !
      double precision edgeX_u
      parameter (edgeX_u=900.)  !
      double precision edgeX_d
      parameter (edgeX_d=1117.) !
      double precision edgeY_l
      parameter (edgeY_l=985.)  ! Y side
      double precision edgeY_r
      parameter (edgeY_r=985.5) !
      double precision edgeY_u
      parameter (edgeY_u=1221.) !
      double precision edgeY_d
      parameter (edgeY_d=894.)  !


      double precision edgeX
      parameter (edgeX=edgeX_l) !distance of the first strip from the Si sensor
      double precision edgeY
      parameter (edgeY=edgeY_l) ! edge in um. NB while X strips a simmetrically
                                ! arranged respect to the Si sensor centre 
                                ! (731.5 um on both sides), Y strips are not
                                ! centered: 985.5 um is the distance of the first
                                ! strip on the hybrid side, 985 um is the one on
                                ! the other side
      double precision glue
      parameter (glue=30.)      !distance between the two sensors in a ladder in um

      double precision RESYAV
      parameter (RESYAV=14.5e-4)
      double precision RESXAV
      parameter (RESXAV=4.e-4)

      parameter (ADCsatx=80)    !saturation limit x-side 
      parameter (ADCsaty=2980)  !saturation limit y-side
c      parameter (ADCsatx=2000)    !saturation limit x-side 
c      parameter (ADCsaty=2000)  !saturation limit y-side
      
      
      double precision pmuH_h
      parameter (pmuH_h=297.61)  ! Hall mobility - holes     - cm**2 V-1 s-1
      double precision pmuH_e
      parameter (pmuH_e=1258.18) ! Hall mobility - electrons - cm**2 V-1 s-1

c--------------------------------------------------------------------------
c     common to control messages on standard output
c--------------------------------------------------------------------------
c      INTEGER DBUG
c      INTEGER VRBS
c$$$      LOGICAL DEBUG
c$$$      LOGICAL VERBOSE
c$$$      LOGICAL WARNING
      INTEGER debug
      INTEGER verbose
      INTEGER warning
      COMMON/dbg/debug,verbose,warning
      SAVE/dbg/
