************************************************************************
*     
*     Common commontracker.f
*     
*     contains tracker general variables definitions
*     
*     to be included in:
*     - ../readraw/readraw.F
*     - ../reduction/reduction.f
*     - ../reduction/fillpedsig.f
*     - ../reduction/filladc.f
*     - ../reduction/cncomp.f
*     - ../reduction/cnoise.f
*     - ../reduction/cutcn.f
*     - ../analysis/preanalysis.f
*     - ../analysis/analysis.f
*     - ../align/align.f
*     - ../magnet/read_B.f
*     - !???
*     
*     parameters:
*     - !???
*     
*************************************************************************


c------------------------------------------------------------------------
c     
c     HBOOK initialization variable
c     
c------------------------------------------------------------------------

c      parameter (NWPAWC=6500000)
cele      INTEGER HMEM
cele      parameter (NWPAWC=8500000)
cele      common/PAWC/HMEM(NWPAWC)


c------------------------------------------------------------------------
c     
c     ntuples id numbers and parameters
c     
c------------------------------------------------------------------------
c$$$
c$$$      parameter (ntp_level0=20) !LEVEL0
      parameter (ntp_level1=21) !LEVEL1
      parameter (ntp_level2=22) !LEVEL2


c     parameter (nclstrmax=1000) !maximum number of clusters per event
      parameter (nclstrmax=500)
      parameter (nclstrp=17)    !maximum number of strips to be checked for 
                                ! inclusion in the cluster
      parameter (maxlength=nclstrmax*nclstrp) !maximum number of strip belonging
                                ! to clusters for the whole event


c------------------------------------------------------------------------
c     
c     spectrometer parameters
c     
c------------------------------------------------------------------------

      parameter (nviews=12)     !number of views
      parameter (nplanes=nviews/2) !number of planes
      parameter (nladders_view=3) !number of ladders per view
      parameter (nva1_ladder=8) !number of VA1s per ladder (per side)
      parameter (nstrips_va1=128) !number of strips per VA1

      parameter (nstrips_ladder=nstrips_va1*nva1_ladder) !number of strips per ladder
      parameter (nva1_view=nva1_ladder*nladders_view) !number of VA1s per view
      parameter (nstrips_view=nstrips_va1*nva1_view) !number of strips per view
      parameter (nva1=nva1_view*nviews) !number of VA1s
      parameter (nstrips=nstrips_va1*nva1) !number of strips

      parameter (pitchX=51.)    !strip pitch in um
      parameter (pitchY=66.5)

      parameter (SiDimX=53330.)  !Si sensor dimensions in um
      parameter (SiDimY=70000.)

*     edges of the sensitive areas, in X and Y
      parameter (edgeX_l=731.5) ! X side
      parameter (edgeX_r=731.5) !
      parameter (edgeX_u=900.)  !
      parameter (edgeX_d=1117.) !
      parameter (edgeY_l=985.)  ! Y side
      parameter (edgeY_r=985.5) !
      parameter (edgeY_u=1221.) !
      parameter (edgeY_d=894.)  !


      parameter (edgeX=edgeX_l) !distance of the first strip from the Si sensor
      parameter (edgeY=edgeY_l) ! edge in um. NB while X strips a simmetrically
                                ! arranged respect to the Si sensor centre 
                                ! (731.5 um on both sides), Y strips are not
                                ! centered: 985.5 um is the distance of the first
                                ! strip on the hybrid side, 985 um is the one on
                                ! the other side
      parameter (glue=30.)      !distance between the two sensors in a ladder in um



