#include <TObject.h>
#include <ToFLevel2.h>
#include <iostream>
using namespace std;
ClassImp(ToFTrkVar);
ClassImp(ToFLevel2);

ToFTrkVar::ToFTrkVar() {

  trkseqno = 0;

  for (Int_t kk=0; kk<13;kk++){
    beta_a[kk] = 0;
  } 

  for (Int_t kk=0; kk<4;kk++){
    for (Int_t hh=0; hh<12;hh++){
      adc_c[hh][kk] = 0;
    }
  }
}

ToFTrkVar::ToFTrkVar(const ToFTrkVar &t){

  trkseqno = t.trkseqno;  

  memcpy(adc_c,t.adc_c,sizeof(adc_c));
  memcpy(beta_a,t.beta_a,sizeof(beta_a));
}

ToFLevel2::ToFLevel2() {    
  //
  ToFTrk = new TClonesArray("ToFTrkVar",1);
  //
  for (Int_t kk=0; kk<3;kk++){
    xtofpos[kk] = 0.;
    ytofpos[kk] = 0.;
  }

  for (Int_t kk=0; kk<6;kk++){
    tof_i_flag[kk] = 0;
    tof_j_flag[kk] = 0;
  }
  
  for (Int_t kk=0; kk<13;kk++){
    betatof_a[kk] = 0;
  }

  for (Int_t kk=0; kk<4;kk++){
    for (Int_t hh=0; hh<12;hh++){
      adctof_c[hh][kk] = 0;
    }
  }  

  for (Int_t kk=0; kk<4;kk++){
    for (Int_t hh=0; hh<12;hh++){
      tdc_c[hh][kk] = 0;
    }
  }  


};

ToFTrkVar *ToFLevel2::GetToFTrkVar(Int_t itrk){
  //    
  if(itrk >= ntrk()){
    printf(" ToFLevel2 ERROR: track related variables set %i does not exists! \n",itrk);
    printf("                      stored track related variables = %i \n",ntrk());
    return(NULL);
  }  
  //
  TClonesArray &t = *(ToFTrk);
  ToFTrkVar *toftrack = (ToFTrkVar*)t[itrk];
  return toftrack;
}
//--------------------------------------
//
// 
//--------------------------------------
/**
 * Method to get the paddle ID (11 12 21 22 31 32) from the paddle index (0 1 2 3 4 5)
 */
  Int_t  ToFLevel2::GetToFPlaneID(Int_t ip){ 
      if(ip>=0 && ip<6)return 10*((int)(ip/2+1.1))+(ip%2)+1;
      else return -1;
  };
/**
 * Method to get the paddle index (0 1 2 3 4 5) from the paddle ID (11 12 21 22 31 32)
 */
  Int_t  ToFLevel2::GetToFPlaneIndex(Int_t plane_id){ 
      if(
	 plane_id == 11 ||
	 plane_id == 12 ||
	 plane_id == 21 ||
	 plane_id == 22 ||
	 plane_id == 31 ||
	 plane_id == 32 ||
	 false)return (Int_t)(plane_id/10)*2-1- plane_id%2;
      else return -1;
  };
/**
 * Method to know if a given ToF paddle was hit, that is there is a TDC signal from both PMTs
 * @param plane Plane ID (11, 12, 21, 22, 31, 32) or Plane index (0,1,2,3,4,5).
 * @param paddle_id Paddle ID.
 * @return 1 if the paddle was hit.
 */
  Bool_t ToFLevel2::HitPaddle(Int_t plane, Int_t paddle_id){  //<<< NEW
    Int_t ip = -1;
    if     (plane>=6             ) ip = GetToFPlaneIndex(plane);
    else if(plane>=0 && plane < 6) ip = plane;
    Int_t flag=0;
    if(ip != -1)flag = tof_j_flag[ip] & (int)pow(2,paddle_id);
    if(
       (ip == 0 && paddle_id < 8 && flag) ||
       (ip == 1 && paddle_id < 6 && flag) ||
       (ip == 2 && paddle_id < 2 && flag) ||
       (ip == 3 && paddle_id < 2 && flag) ||
       (ip == 4 && paddle_id < 3 && flag) ||
       (ip == 5 && paddle_id < 3 && flag) ||
       false) return true;
    else return false;
};
/**
 * Method to get the number of hit paddles on a ToF plane.
 * @param plane Plane ID (11, 12, 21, 22, 31, 32) or Plane index (0,1,2,3,4,5).
 */
Int_t ToFLevel2::GetNHitPaddles(Int_t plane){
    Int_t npad=0;
    for(Int_t i=0; i<8; i++)npad = npad + (int)HitPaddle(plane,i);
    return npad;
};
