#ifndef l2tofcore_h
#define l2tofcore_h
#include <TSystem.h>
#include <TSQLServer.h>


/**
 * \brief  Variables needed for ToF calculations: Raw data, calibration constants, etc...
 */

struct ToFInput {
 //! The alpha vector from the track fit
  Double_t al_pp[5];  
//! The 24 k1 and k2 constants for S11-S31
  Float_t k_s11s31[24][2]; 
//! The 24 k1 and k2 constants for S11-S32
  Float_t k_s11s32[24][2];
//! The 18 k1 and k2 constants for S12-S31
  Float_t k_s12s31[18][2];
//! The 18 k1 and k2 constants for S12-S32
  Float_t k_s12s32[18][2];
//! The 6 k1 and k2 constants for S21-S31
  Float_t k_S21S31[6][2];
//! The 6 k1 and k2 constants for S21-S32
  Float_t k_S21S32[6][2];
//! The 6 k1 and k2 constants for S22-S31
  Float_t k_S22S31[6][2];
//! The 6 k1 and k2 constants for S22-S32
  Float_t k_S22S32[6][2];
//! The 16 k1 and k2 constants for S11-S21
  Float_t k_s11s21[16][2];
//! The 16 k1 and k2 constants for S11-S22
  Float_t k_s11s22[16][2];
//! The 12 k1 and k2 constants for S12-S21
  Float_t k_s12s21[12][2];
//! The 12 k1 and k2 constants for S12-S22
  Float_t k_s12s22[12][2];
//! parameters for the attenuation fit for S11
  Float_t adcx11[4][8][2];
//! parameters for the attenuation fit for S12
  Float_t adcx12[4][6][2];
//! parameters for the attenuation fit for S21
  Float_t adcx21[4][2][2];
//! parameters for the attenuation fit for S22
  Float_t adcx22[4][2][2];
//! parameters for the attenuation fit for S31
  Float_t adcx31[4][3][2];
//! parameters for the attenuation fit for S32
  Float_t adcx32[4][3][2];
//! constants for the time-walk for S11
  Float_t tw11[8][2];
//! constants for the time-walk for S12
  Float_t tw12[6][2];
//! constants for the time-walk for S21
  Float_t tw21[2][2];
//! constants for the time-walk for S22
  Float_t tw22[2][2];
//! constants for the time-walk for S31
  Float_t tw31[3][2];
//! constants for the time-walk for S32
  Float_t tw32[3][2];
//! constants to get the position from the timing for S11
  Float_t y_coor_lin11[2][8];
//! constants to get the position from the timing for S12
  Float_t y_coor_lin12[2][6];
//! constants to get the position from the timing for S21
  Float_t y_coor_lin21[2][2];
//! constants to get the position from the timing for S22
  Float_t y_coor_lin22[2][2];
//! constants to get the position from the timing for S31
  Float_t y_coor_lin31[2][3];
//! constants to get the position from the timing for S32
  Float_t y_coor_lin32[2][3];
//! raw ADC matrix 4x12 : 12 half-boards @ 4 channels
  Int_t adc[12][4];
//! raw TDC matrix 4x12 : 12 half-boards @ 4 channels
  Int_t tdc[12][4];
//! patterntrig contains trigger information 
  Int_t patterntrig[6];
  Int_t ntrk;
};

/**
 * \brief  Internal output variables from ToF calculations: beta, etc... 
 *
 * Look at ToFLevel2 class for the real Level2 ToF output 
 */

struct ToFOutput {
//! beta track dependend, 12 measurements for the 12 combinations, beta[13] is weighted mean
  Float_t beta_a[13];
//! internal variable: beta ToF standalone, 12 measurements for the 12 combinations, beta[13] is weighted mean
  Float_t betatof_a[13];
//! x-measurement using the TDC values and the calibration
  Float_t xtofpos[3];
//! y-measurement using the TDC values and the calibration
  Float_t ytofpos[3];
//! x-measurement at the ToF layers from tracker
  Float_t xtr_tof[6];
//! y-measurement at the ToF layers from tracker
  Float_t ytr_tof[6];
//! matrix 4x12 which contains the dEdx value for each PMT
  Float_t adc_c[12][4];
//! internal variable: ToF standalone: matrix 4x12 which contains the dEdx value for each PMT
  Float_t adctof_c[12][4];
//! matrix 4x12 which contains the time-walk corrected TDC value for each PMT
  Float_t tdc_c[12][4];
//! internal variable: matrix is filled if beta is calculated
  Int_t tofmask[12][4]; 
//! internal variable: number of the hitted paddle for each ToF layer from ToF standalone
  Int_t tof_i_flag[6];
//! number of hitted paddle(s) from ToF standalone for each ToF layer: flag = flag + 2**(paddlenumber-1)
  Int_t tof_j_flag[6];
//! internal variable: array flagging the artificial ToF standalone ADCs, "0" if normal ADC value 
  Int_t adcflagtof[12][4];
//! internal variable: array is always "0" since there are no artificial TDC values with ToF standalone
  Int_t tdcflagtof[12][4];
//! array flagging the artificial track dependend ADCs, "0" if normal ADC value 
  Int_t adcflag[12][4];
//! array flagging the artificial track dependend TDCs, "0" if normal TDC value 
  Int_t tdcflag[12][4];
};

extern int ToFCore(UInt_t run, TFile *file, TSQLServer *dbc, Int_t ToFargc, char *ToFargv[]);

#endif
