#ifndef ToFLevel2_h
#define ToFLevel2_h
//
#include <TObject.h>
#include <TArrayI.h>
#include <TArrayF.h>
#include <TClonesArray.h>

#include <ToFStruct.h>
//
// class which contains track related variables
//
#define ZTOF11 53.74
#define ZTOF12 53.04
#define ZTOF21 23.94
#define ZTOF22 23.44
#define ZTOF31 -23.49
#define ZTOF32 -24.34


class ToFPMT : public TObject {
  
 private:

 public:
    Int_t pmt_id;
    Float_t adc;
    Float_t tdc_tw;
    //
    ToFPMT();
    ToFPMT(const ToFPMT&);
    //
    ToFPMT* GetToFPMT(){return this;};
    void Clear();

    ClassDef(ToFPMT,1);
};


class ToFTrkVar : public TObject {
  
 private:

 public:
    //
  Int_t trkseqno; // tracker entry coming from tracker, 100 if image track is used, -100 if the track is not consistent with MyDetector2 one
  //
  Int_t npmttdc;
  TArrayI pmttdc;
  Float_t beta[13];
  //
  Int_t npmtadc;
  TArrayI pmtadc;
  TArrayF dedx;  
  //
  Float_t xtofpos[3];
  Float_t ytofpos[3];
  //
  ToFTrkVar();
  ToFTrkVar(const ToFTrkVar&);
  
  ToFTrkVar* GetToFTrkVar(){return this;};
  void Clear();

  ClassDef(ToFTrkVar,1);
  //
};

class ToFLevel2 : public TObject {
 private:
  
 public:
  //
  TClonesArray *PMT; // class needed to store PMT hit informations
  TClonesArray *ToFTrk; // track related variable class
  Int_t tof_j_flag[6];
  //
  Float_t GetdEdx(Int_t notrack, Int_t plane);
  //
  // methods to make life simplier during the analysis, returns a pointer to the ToFTrkVar class containing track related variables
  //
  Int_t ntrk(){return ToFTrk->GetEntries();};
  Int_t npmt(){return PMT->GetEntries();};
    
  //
  void GetLevel2Struct(cToFLevel2 *) const;
  //
  ToFTrkVar *GetToFTrkVar(Int_t notrack);  
  ToFPMT *GetToFPMT(Int_t nohit);  
  Int_t GetPMTid(Int_t gg, Int_t hh);
  TString GetPMTName(Int_t ind);
  Int_t GetPlaneIndex(Int_t pmt_id);
  void GetMatrix(Int_t notrack, Float_t adc[4][12], Float_t tdc[4][12]);
  void GetPMTIndex(Int_t pmt_id, Int_t &gg, Int_t &hh);
  //
  // constructor
  //
  ToFLevel2();
  //
  //
  ToFLevel2*   GetToFLevel2(){return this;};
  Float_t      GetZTOF(Int_t plane_id){
      switch(plane_id){
      case 11: return ZTOF11;
      case 12: return ZTOF12;
      case 21: return ZTOF21;
      case 22: return ZTOF22;
      case 31: return ZTOF31;
      case 32: return ZTOF32;
      default: return 0.;
      };
  };
  
    //
    // Paddles position
    //
    /*
      S11 8 paddles  33.0 x 5.1 cm
      S12 6 paddles  40.8 x 5.5 cm
      S21 2 paddles  18.0 x 7.5 cm
      S22 2 paddles  15.0 x 9.0 cm
      S31 3 paddles  15.0 x 6.0 cm
      S32 3 paddles  18.0 x 5.0 cm
    */
    
    Int_t  GetToFPlaneID(Int_t ip);
    Int_t  GetToFPlaneIndex(Int_t plane_id);
    Bool_t HitPaddle(Int_t ,Int_t);
    Int_t  GetNHitPaddles(Int_t plane);
    void Clear();
    //
    ClassDef(ToFLevel2,1);
};

#endif
