/**
 * \file src/S4Level2.cpp
 *
**/
#include <S4Level2.h>

/**
 * S4Level2 constructor
**/
S4Level2::S4Level2(){
  this->Clear();
}
/**
 * Clear variables
**/
void S4Level2::Clear(){
  S4calibrated = 0.;
  S4adc = 0.;
  unpackError = 0;
}
/**
 * Fills a struct cS4Level2 with values from a S4Level2 object (to put data into a F77 common).
 * */
void S4Level2::GetLevel2Struct(cS4Level2 *l2) const{
  l2->S4calibrated = S4calibrated;
  l2->S4adc        = S4adc;

}

/**
 * Fills a S4Level2 object with values from a struct cS4Level2.
 */
void S4Level2::SetFromLevel2Struct(cS4Level2 *l2){
  S4calibrated = l2->S4calibrated;
  S4adc        = l2->S4adc;
}


ClassImp(S4Level2)
  
