/**
 * \file inc/S4Level2.h
 */
#ifndef S4Level2_h
#define S4Level2_h
//
#include <TObject.h>
#include <S4Struct.h>
//

/**
 * \brief S4 level2 class
 *
 * This class contains level2 S4 variables
 *
**/
class S4Level2 : public TObject {
 private:

 public:
  //
  // S4 variables
  //
  Float_t S4calibrated; ///< total energy detected in the scintillator (MIP)
  Float_t S4adc; ///< raw value of the total energy detected in the scintillator (Ch)
  //
  // general variables
  //
  Int_t unpackError; ///< 0 no errors, 1 errors
  //
  // constructor
  //
  S4Level2(); ///< Constructor.
  //
  S4Level2*   GetS4Level2(){return this;};  // ELENA	
  //
  // METHODS
  //
  void SetFromLevel2Struct(cS4Level2 *l2);
  //
  void GetLevel2Struct(cS4Level2 *l2) const;
  //
  void Clear();
  //
  ClassDef(S4Level2, 2)
};

#endif
