//
// C/C++ headers
//
#include <iostream>
#include <sstream>
//
// ROOT headers
//
#include <TString.h>
#include <TSQLServer.h>
#include <TFile.h>
#include <TSystem.h>
//
#include <RunInfo.h>
using namespace std;
//
int RunInfoCore(UInt_t run, TFile *processFile, TSQLServer *dbc, TString DVV, Int_t runargc, char *runargv[]){
  Int_t i = 0;
  Int_t sgnl = 0;
  //
  TString processFolder = "runinfoFolder";
  if ( runargc > 0 ){
    i = 0;
    while ( i < runargc ){
      if ( !strcmp(runargv[i],"-processFolder") ) {
	if ( runargc < i+1 ){
	  throw -3;
	};
	processFolder = (TString)runargv[i+1];	
	i++;
      };
      i++;
    };    
  };
  ItoRunInfo *runinfo = 0;
  stringstream temprname;
  const char* routdir = gSystem->DirName(gSystem->DirName(processFile->GetPath()));
  temprname.str("");
  temprname << routdir;
  temprname << "/" << processFolder.Data();  
  //
  if ( !dbc->IsConnected() ) throw -807;
  runinfo = new ItoRunInfo(dbc,processFile,processFolder);
  sgnl = runinfo->Update(run,"NONE","");
  gSystem->Unlink(temprname.str().c_str());
  //
  runinfo->Close();
  processFile->cd();
  if ( processFile ) processFile->Write("Run");
  runinfo->Clear();
  //
  if ( sgnl < 0 ) throw sgnl;
  //
  delete runinfo;
  //
  runinfo = new ItoRunInfo(processFile);
  sgnl = runinfo->Update(run,"DV",DVV);
  gSystem->Unlink(temprname.str().c_str());
  runinfo->Close();
  processFile->cd();
  if ( processFile ) processFile->Write("Run");
  //
  if ( sgnl < 0 ) throw sgnl;
  //
  runinfo->Clear();
  delete runinfo;
  //
  return(sgnl);
}
