#ifndef RunInfo_h
#define RunInfo_h
//
#include <TObject.h>
#include <TTree.h>
#include <TFile.h>
#include <TArrayL.h>
#include <TSQLServer.h>
//
#include <GLTables.h>
//
#include <RunInfoStruct.h>


class SoftInfo : public TObject {

 private:
    
 public:
    TString TRIG_ver;
    TString TOF_ver;
    TString AC_ver;
    TString TRK_ver;
    TString CAL_ver;
    TString S4_ver;
    TString ND_ver;
    TString ORB_ver;
    //
    // Default constructor
    //
    SoftInfo();

    void GetLevel2Struct(cSoftInfo *l2) const;
    //
    ClassDef(SoftInfo,1);
    //
};

class ItoRunInfo : public GL_RUN {

 private:
    ULong64_t file_entries;
    Long64_t totnorun;
    Int_t first_file_entry;
    Int_t last_file_entry;
    UInt_t norun;
    Bool_t reprocessing;
    Bool_t updating;
    Bool_t isreadonly;
    TFile *file;
    TTree *newtree;
    TArrayL *runlist;
    ULong64_t idRun;
    TSQLServer *dbc;
    TString processFolder;
    TString Detector;
    
 public:
    //
    SoftInfo *version;
    //
    // Default constructor
    //
    ItoRunInfo();
    //
    // Other constructors...
    //
    // ... for updating GL_RUN informations by RunInfo exec
    //
    ItoRunInfo(TSQLServer *db, TFile *processFl, TString processFld);
    //
    // ... for updating versioning informations by programs and to read only data
    //
    ItoRunInfo(TFile *processFile);
    //
    //
    //
    Int_t Update(ULong64_t run, TString Detector, TString Version);
    Int_t Read(ULong64_t run);
    Int_t GetRunInfo(ULong64_t run);
    UInt_t GetRunForEntry(UInt_t entry);
    void Close();
    void Clear();
    //
    Long64_t GetRunEntries(){return(totnorun);};
    UInt_t GetNoRun(){return(norun);};
    TArrayL *GetRunList(){return(runlist);};
    Bool_t IsReprocessing(){return(reprocessing);};
    UInt_t GetFirstEntry(){return(first_file_entry);};
    UInt_t GetLastEntry(){return(last_file_entry-1);};
    ULong64_t GetFileEntries(){return(file_entries);};    
    //
    ClassDef(ItoRunInfo,1);
    //
};

#endif

