#ifndef RunInfo_h
#define RunInfo_h
//
#include <TObject.h>
#include <TTree.h>
#include <TChain.h>
#include <TFile.h>
#include <TArrayI.h>
#include <TSQLServer.h>
//
#include <GLTables.h>
//
#include <RunInfoStruct.h>

class ProcInfo : public TObject {

 private:
    
 public:
    UInt_t runID; ///< ID of the processed run (input from DV)
    TString date; ///< processing date and time
    TString commandLine; ///< input command line
    TString outputFilename; ///< output filename
    TString localDir; ///< workiing directory
    TString uname; ///< local machine and arch (output of "uname -a")
    TString DB; ///< database used for this processing
    //
    // Default constructor
    //
    ProcInfo();

    void Clear(Option_t *t="");
    ProcInfo* GetProcInfo(){return this;};  
    //
    ClassDef(ProcInfo,1);
    //
};

class SoftInfo : public TObject {

 private:
    
 public:
    TString DV_ver;
    TString ORB_ver;
    TString TRIG_ver;
    TString TOF_ver;
    TString AC_ver;
    TString TRK_ver;
    TString CAL_ver;
    TString S4_ver;
    TString ND_ver;
    //
    // Default constructor
    //
    SoftInfo();

    void Clear(Option_t *t="");
    void GetLevel2Struct(cSoftInfo *l2) const;
    SoftInfo*   GetSoftInfo(){return this;};  
    UInt_t GetSWinfo(TString DEC);
      
    //
    ClassDef(SoftInfo,2);
    //
};

class ItoRunInfo : public GL_RUN {

 private:
    UInt_t file_entries;
    UInt_t totnorun;
    Int_t first_file_entry;
    Int_t last_file_entry;
    UInt_t norun;
    Bool_t reprocessing;
    Bool_t updating;
    Bool_t isreadonly;
    TFile *file;
    TTree *newtree;
    TArrayI *runlist;
    UInt_t idRun;
    TSQLServer *dbc;
    TString processFolder;
    TString Detector;
    void CopyFromTo(GL_RUN *, GL_RUN *, SoftInfo *, SoftInfo *);
    
 public:
    //
    SoftInfo *version;
    //
    //    GL_RUN *glrun;
    //
    // Default constructor
    //
    ItoRunInfo();
    ~ItoRunInfo();
    //
    // Other constructors...
    //
    // ... for updating GL_RUN informations by RunInfo exec
    //
    ItoRunInfo(TSQLServer *db, TFile *processFl, TString processFld);
    //
    // ... for updating versioning informations by programs and to read only data
    //
    ItoRunInfo(TFile *processFile);
    //
    //
    //
    Int_t Update(UInt_t run, TString Detector, TString Version);
    Int_t Read(UInt_t run);
    void Write();
    Int_t GetRunInfo(UInt_t run);
    UInt_t GetRunForEntry(UInt_t entry);
    void Close();
    void Clear(Option_t *t="");
    //
    void *GetPointerToSI(){return &version;};
    void *GetPointerToRI(){return this;};
    //void *GetPointerToRI(){return &glrun;};
    TChain *GetRunTree(TList *fl);
    //
    UInt_t GetRunEntries(){return(totnorun);};
    UInt_t GetNoRun(){return(norun);};
    TArrayI *GetRunList(){return(runlist);};
    Bool_t IsReprocessing(){return(reprocessing);};
    UInt_t GetFirstEntry(){return(first_file_entry);};
    UInt_t GetLastEntry(){return(last_file_entry-1);};
    UInt_t GetEntries(){Long64_t en = last_file_entry-1-first_file_entry; if ( en < 0LL ) en = 0LL; return((UInt_t)en);};
    UInt_t GetFileEntries(){return(file_entries);};    
    //
    ClassDef(ItoRunInfo,3);
    //
};

#endif

