// C/C++ headers
//
#include <fstream>
#include <string.h>
#include <iostream>
#include <cstring>
#include <stdio.h>
//
// ROOT headers
//
//#include <TCanvas.h>
//#include <TH2F.h> //for test only. Vitaly.
//#include <TF1.h>

#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TArrayI.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
//
// RunInfo header
//
#include <RunInfo.h>
#include <GLTables.h>
//
// YODA headers
//
#include <PamelaRun.h>
#include <PscuHeader.h>
#include <PscuEvent.h>
#include <EventHeader.h>
#include <mcmd/McmdEvent.h>
#include <mcmd/McmdRecord.h>
//
// This program headers
//
#include <OrbitalInfo.h>
#include <OrbitalInfoVerl2.h>
#include <OrbitalInfoCore.h>
#include <InclinationInfo.h>


using namespace std;

//
// CORE ROUTINE
//
//
int OrbitalInfoCore(UInt_t run, TFile *file, GL_TABLES *glt, Int_t OrbitalInfoargc, char *OrbitalInfoargv[]){
  //
  Int_t i = 0;
  TString host = glt->CGetHost();
  TString user = glt->CGetUser();
  TString psw = glt->CGetPsw();
  TSQLServer *dbc = TSQLServer::Connect(host.Data(),user.Data(),psw.Data());
  //
  stringstream myquery;
  myquery.str("");
  myquery << "SET time_zone='+0:00'";
  dbc->Query(myquery.str().c_str());
  //
  TString processFolder = Form("OrbitalInfoFolder_%u",run);
  //
  // Set these to true to have a very verbose output.
  //
  Bool_t debug = false;
  //
  Bool_t verbose = false;
  //
  Bool_t standalone = false;
  //
  if ( OrbitalInfoargc > 0 ){
    i = 0;
    while ( i < OrbitalInfoargc ){
      if ( !strcmp(OrbitalInfoargv[i],"-processFolder") ) {
	if ( OrbitalInfoargc < i+1 ){
	  throw -3;
	};
	processFolder = (TString)OrbitalInfoargv[i+1];
	i++;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--debug")) || (!strcmp(OrbitalInfoargv[i],"-g")) ) {
	verbose = true;
	debug = true;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--verbose")) || (!strcmp(OrbitalInfoargv[i],"-v")) ) {
	verbose = true;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--standalone")) ) {
	standalone = true;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--calculate-pitch")) ) {
	standalone = false;
      };
      i++;
    };
  };
  //
  const char* outDir = gSystem->DirName(gSystem->DirName(file->GetPath()));
  //
  TTree *OrbitalInfotr = 0;
  UInt_t nevents = 0;
  UInt_t neventsm = 0;
  //
  // variables needed to reprocess data
  //
  Long64_t maxsize = 10000000000LL;  
  TTree::SetMaxTreeSize(maxsize);
  //
  TString OrbitalInfoversion;
  ItoRunInfo *runinfo = 0;
  TArrayI *runlist = 0;
  TTree *OrbitalInfotrclone = 0;
  Bool_t reproc = false;
  Bool_t reprocall = false;
  UInt_t nobefrun = 0;
  UInt_t noaftrun = 0;
  UInt_t numbofrun = 0;
  stringstream ftmpname;
  TString fname;
  UInt_t totfileentries = 0;
  UInt_t idRun = 0;
  //
  // My variables. Vitaly.
  //
//  UInt_t oi = 0;
  Int_t tmpSize = 0; 
  //
  // variables needed to handle error signals
  //
  Int_t code = 0;
  Int_t sgnl;
  //
  // OrbitalInfo  classes
  //
  OrbitalInfo *orbitalinfo = new OrbitalInfo();
  OrbitalInfo *orbitalinfoclone = new OrbitalInfo();

  //
  // define variables for opening and reading level0 file
  //
  TFile *l0File = 0;
  TTree *l0tr = 0;
  //  TTree *l0trm = 0;
  TChain *ch = 0;
  // EM: open also header branch
  TBranch *l0head = 0;
  pamela::EventHeader *eh = 0;
  pamela::PscuHeader *ph = 0;
  pamela::McmdEvent *mcmdev = 0;
  pamela::McmdRecord *mcmdrc = 0;
  // end EM
  
  //  pamela::RunHeaderEvent *reh = new pamela::RunHeaderEvent;
  //  pamela::EventHeader    *eH  = new pamela::EventHeader;
  
  //
  // Define other basic variables
  // 
  UInt_t procev = 0;
  stringstream file2;
  stringstream file3;
  stringstream qy;
  Int_t totevent = 0;
  UInt_t atime = 0;
  UInt_t re = 0;
  UInt_t ik = 0;

  // Position
  Float_t lon, lat, alt;

  //
  // IGRF stuff
  //
  Float_t dimo = 0.0; // dipole moment (computed from dat files)
  Float_t bnorth, beast, bdown, babs;
  Float_t xl; // L value
  Float_t icode; // code value for L accuracy (see fortran code)
  Float_t bab1; // What's  the difference with babs?
  Float_t stps = 0.005; // step size for field line tracing
  Float_t bdel = 0.01; // required accuracy
  Float_t bequ;  // equatorial b value (also called b_0)
  Bool_t value = 0; // false if bequ is not the minimum b value
  Float_t rr0; // equatorial radius normalized to earth radius

  //
  // Working filename
  //
  TString outputfile;
  stringstream name;
  name.str("");
  name << outDir << "/";
  //
  // temporary file and folder
  //
  TFile *tempfile = 0;
  TTree *tempOrbitalInfo = 0;
  stringstream tempname;
  stringstream OrbitalInfofolder;
  Bool_t myfold = false;
  tempname.str("");
  tempname << outDir;
  tempname << "/" << processFolder.Data();
  OrbitalInfofolder.str("");
  OrbitalInfofolder << tempname.str().c_str();
  tempname << "/OrbitalInfotree_run";
  tempname << run << ".root";  
  UInt_t totnorun = 0;
  //
  // DB classes
  //
  GL_ROOT *glroot = new GL_ROOT();
  GL_TIMESYNC *dbtime = 0;
  GL_TLE *gltle = new GL_TLE();
  //
  //Quaternions classes
  //
  Quaternions *L_QQ_Q_l_lower = new Quaternions();
  InclinationInfo *RYPang_lower = new InclinationInfo();
  Quaternions *L_QQ_Q_l_upper = new Quaternions();
  InclinationInfo *RYPang_upper = new InclinationInfo();
  
  cEci eCi;
  
  // Initialize fortran routines!!!
  Int_t ltp2 = 0;
  Int_t ltp3 = 0;
  Int_t uno = 1;
  const char *niente = " ";
  GL_PARAM *glparam = new GL_PARAM();
  GL_PARAM *glparam2 = new GL_PARAM();

  //
  // Orientation variables. Vitaly
  //
  UInt_t evfrom = 0;
  UInt_t jumped = 0;
  Int_t itr = -1;    
  Double_t A1; 
  Double_t A2; 
  Double_t A3;
  Double_t Px = 0;
  Double_t Py = 0;	
  Double_t Pz = 0;  
  TTree *ttof = 0;
  ToFLevel2 *tof = new ToFLevel2();
  OrientationInfo *PO = new OrientationInfo();
  Int_t nz = 6; 
  Float_t zin[6];
  Int_t nevtofl2 = 0;
  if ( verbose ) cout<<"Reading quaternions external file"<<endl;
  cout.setf(ios::fixed,ios::floatfield);  
  /******Reading recovered quaternions...*********/
  vector<Double_t> recqtime;
  vector<Float_t> recq0;
  vector<Float_t> recq1;
  vector<Float_t> recq2;
  vector<Float_t> recq3;
  Float_t Norm = 1;
  Int_t parerror=glparam->Query_GL_PARAM(1,303,dbc); // parameters stored in DB in GL_PRAM table  
  ifstream in((glparam->PATH+glparam->NAME).Data(),ios::in);
  if ( parerror<0 ) {
    code = parerror;
    goto closeandexit;
  };
  while(!in.eof()){
    recqtime.resize(recqtime.size()+1);
    Int_t sizee = recqtime.size();
    recq0.resize(sizee);
    recq1.resize(sizee);
    recq2.resize(sizee);
    recq3.resize(sizee);
    in>>recqtime[sizee-1];
    in>>recq0[sizee-1];
    in>>recq1[sizee-1];
    in>>recq2[sizee-1];
    in>>recq3[sizee-1];
    in>>Norm;
  }
  if ( verbose ) cout<<"We have read recovered data"<<endl;


  parerror=glparam->Query_GL_PARAM(1,301,dbc); // parameters stored in DB in GL_PRAM table  
  if ( parerror<0 ) {
    code = parerror;
    goto closeandexit;
  };
  ltp2 = (Int_t)(glparam->PATH+glparam->NAME).Length();
  if ( verbose ) printf(" Reading Earth's Magnetic Field parameter file: %s \n",(glparam->PATH+glparam->NAME).Data());
  //
  parerror=glparam2->Query_GL_PARAM(1,302,dbc); // parameters stored in DB in GL_PRAM table
  if ( parerror<0 ) {
    code = parerror;
    goto closeandexit;
  };
  ltp3 = (Int_t)(glparam2->PATH+glparam2->NAME).Length();
  if ( verbose ) printf(" Reading Earth's Magnetic Field parameter file: %s \n",(glparam2->PATH+glparam2->NAME).Data());
  //
  initize_((char *)niente,&uno,(char *)(glparam->PATH+glparam->NAME).Data(),&ltp2,(char *)(glparam2->PATH+glparam2->NAME).Data(),&ltp3); 
  //
  // End IGRF stuff//
  //
  for (Int_t ip=0;ip<nz;ip++){
    zin[ip] = tof->GetZTOF(tof->GetToFPlaneID(ip));
  };
  //
  if ( !standalone ){
    //
    // Does it contain the Tracker tree?
    //
    ttof = (TTree*)file->Get("ToF");
    if ( !ttof ) {
      if ( verbose ) printf(" OrbitalInfo - ERROR: no tof tree\n");
      code = -900;
      goto closeandexit;
    };
    ttof->SetBranchAddress("ToFLevel2",&tof);  
    nevtofl2 = ttof->GetEntries();
  };
  //
  // Let's start!
  //
  // As a first thing we must check what we have to do: if run = 0 we must process all events in the file has been passed
  // if run != 0 we must process only that run but first we have to check if the tree MyDetector2 already exist in the file
  // if it exists we are reprocessing data and we must delete that entries, if not we must create it.
  // 
  if ( run == 0 )  reproc = true;
  //
  //
  // Output file is "outputfile"
  //
  if ( !file->IsOpen() ){
    //printf(" OrbitalInfo - ERROR: cannot open file for writing\n");
    throw -901;    
  };
  //
  // Retrieve GL_RUN variables from the level2 file
  //  
  OrbitalInfoversion = OrbitalInfoInfo(false); // we should decide how to handle versioning system
  //
  // create an interface to RunInfo called "runinfo"
  //
  runinfo = new ItoRunInfo(file);
  //
  // open "Run" tree in level2 file, if not existing return an error (sngl != 0)
  //
  sgnl = 0;
  sgnl = runinfo->Update(run, "ORB", OrbitalInfoversion);
  //sgnl = runinfo->Read(run);

  if ( sgnl ){
    //printf("OrbitalInfo - ERROR: RunInfo exited with non-zero status\n");
    code = sgnl;
    goto closeandexit;
  } else {
    sgnl = 0;
  };
  //
  // number of events in the file BEFORE the first event of our run
  //
  nobefrun = runinfo->GetFirstEntry();
  //
  // total number of events in the file 
  //
  totfileentries = runinfo->GetFileEntries();
  //
  // first file entry AFTER the last event of our run
  //
  noaftrun = runinfo->GetLastEntry() + 1;
  //
  // number of run to be processed
  //
  numbofrun = runinfo->GetNoRun();
  totnorun = runinfo->GetRunEntries();
  //
  // Try to access the OrbitalInfo tree in the file, if it exists we are reprocessing data if not we are processing a new run
  //
  OrbitalInfotrclone = (TTree*)file->Get("OrbitalInfo");
  //
  if ( !OrbitalInfotrclone ){
    //
    // tree does not exist, we are not reprocessing
    //
    reproc = false;
    if ( run == 0 ){
      if (verbose) printf(" OrbitalInfo - WARNING: you are reprocessing data but OrbitalInfo tree does not exist!\n");
    }
    if ( runinfo->IsReprocessing() && run != 0 ) {
      if (verbose) printf(" OrbitalInfo - WARNING: it seems you are not reprocessing data but OrbitalInfo\n versioning information already exists in RunInfo.\n");
    }
  } else {
    //
    // tree exists, we are reprocessing data. Are we reprocessing a single run or all the file?
    //
    OrbitalInfotrclone->SetAutoSave(900000000000000LL);
    reproc = true;
    //
    //
    if (verbose) printf("\n Preparing the pre-processing...\n");
    //
    if ( run == 0 || totnorun == 1 ){
      //
      // we are reprocessing all the file
      // if we are reprocessing everything we don't need to copy any old event and we can just work with the new tree and delete the old one immediately
      //
      reprocall = true;
      //
      if (verbose) printf("\n OrbitalInfo - WARNING: Reprocessing all runs\n");
      //
    } else {
      //
      // we are reprocessing a single run, we must copy to the new tree the events in the file which preceed the first event of the run
      //
      reprocall = false;
      //
      if (verbose) printf("\n OrbitalInfo - WARNING: Reprocessing run number %u \n",run);
      //
      // copying old tree to a new file
      //
      gSystem->MakeDirectory(OrbitalInfofolder.str().c_str());
      myfold = true;
      tempfile = new TFile(tempname.str().c_str(),"RECREATE");
      tempOrbitalInfo = OrbitalInfotrclone->CloneTree(-1,"fast");
      tempOrbitalInfo->SetName("OrbitalInfo-old");
      tempfile->Write();
      tempfile->Close();  
    }
    //
    // Delete the old tree from old file and memory
    //
    OrbitalInfotrclone->Delete("all");
    //
    if (verbose) printf(" ...done!\n");
    //
  };
  //
  // create mydetector tree mydect
  // 
  file->cd();
  OrbitalInfotr = new TTree("OrbitalInfo-new","PAMELA OrbitalInfo data");
  OrbitalInfotr->SetAutoSave(900000000000000LL);
  orbitalinfo->Set();//ELENA **TEMPORANEO?**
  OrbitalInfotr->Branch("OrbitalInfo","OrbitalInfo",&orbitalinfo);
  //
  if ( reproc && !reprocall ){
    //
    //  open new file and retrieve also tree informations
    //
    tempfile = new TFile(tempname.str().c_str(),"READ");
    OrbitalInfotrclone = (TTree*)tempfile->Get("OrbitalInfo-old");
    OrbitalInfotrclone->SetAutoSave(900000000000000LL);
    OrbitalInfotrclone->SetBranchAddress("OrbitalInfo",&orbitalinfoclone);
    //      
    if ( nobefrun > 0 ){
      if (verbose){
	printf("\n Pre-processing: copying events from the old tree before the processed run\n");   
	printf(" Copying %u events in the file which are before the beginning of the run %u \n",nobefrun,run);
	printf(" Start copying at event number 0, end copying at event number %u \n",nobefrun);
      }
      for (UInt_t j = 0; j < nobefrun; j++){
	//
	if ( OrbitalInfotrclone->GetEntry(j) <= 0 ) throw -36;	  
	//
	// copy orbitalinfoclone to mydec
	//
	orbitalinfo->Clear();
	//
	memcpy(&orbitalinfo,&orbitalinfoclone,sizeof(orbitalinfoclone));
	//
	// Fill entry in the new tree
	//
	OrbitalInfotr->Fill();
	//
      };
      if (verbose) printf(" Finished successful copying!\n");
    };          
  };
  //
  //
  // Get the list of run to be processed, if only one run has to be processed the list will contain one entry only.
  //
  runlist = runinfo->GetRunList();
  //
  // Loop over the run to be processed
  //
  for (UInt_t irun=0; irun < numbofrun; irun++){
    //
    // retrieve the first run ID to be processed using the RunInfo list
    //
    
    idRun = runlist->At(irun);
    if (verbose){
      printf("\n\n\n ####################################################################### \n");
      printf("                    PROCESSING RUN NUMBER %i \n",(int)idRun);
      printf(" ####################################################################### \n\n\n");
    }
    //
    runinfo->ID_ROOT_L0 = 0;
    //
    // store in the runinfo class the GL_RUN variables for our run
    //
    sgnl = 0;
    sgnl = runinfo->GetRunInfo(idRun);
    if ( sgnl ){
      if ( debug ) printf("\n OrbitalInfo - ERROR: RunInfo exited with non-zero status\n");
      code = sgnl;
      goto closeandexit;
    } else {
      sgnl = 0;
    };
    //
    // now you can access that variables using the RunInfo class this way runinfo->ID_REG_RUN
    //
    if ( runinfo->ID_ROOT_L0 == 0 ){
      if ( debug ) printf("\n OrbitalInfo - ERROR: no run with ID_RUN = %u \n\n Exiting... \n\n",idRun);
      code = -5;
      goto closeandexit;    
    };
    //
    // prepare the timesync for the db
    //
    dbtime = new GL_TIMESYNC(runinfo->ID_ROOT_L0,"ID",dbc);
   
    //
    // Search in the DB the path and name of the LEVEL0 file to be processed.
    //
    glroot->Query_GL_ROOT(runinfo->ID_ROOT_L0,dbc);
    //
    ftmpname.str("");
    ftmpname << glroot->PATH.Data() << "/";
    ftmpname << glroot->NAME.Data();
    fname = ftmpname.str().c_str();
    ftmpname.str("");
    //
    // print nout informations
    //
    totevent = runinfo->NEVENTS;
    evfrom = runinfo->EV_FROM;
    //cout<<"totevents = "<<totevent<<"\n";
    if (verbose){
      printf("\n LEVEL0 data file: %s \n",fname.Data());
      printf(" RUN HEADER absolute time is:  %u \n",runinfo->RUNHEADER_TIME);
      printf(" RUN TRAILER absolute time is: %u \n",runinfo->RUNTRAILER_TIME);
      printf(" %i events to be processed for run %u: from %i to %i \n\n",totevent,idRun,runinfo->EV_FROM+1,runinfo->EV_FROM+totevent);
    }//
    //
    //    if ( !totevent ) goto closeandexit;
    // Open Level0 file
    l0File = new TFile(fname.Data());
    if ( !l0File ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: problems opening Level0 file\n");
      code = -6;
      goto closeandexit;
    };
    l0tr = (TTree*)l0File->Get("Physics");
    if ( !l0tr ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: no Physics tree in Level0 file\n");
      l0File->Close();
      code = -7;
      goto closeandexit;
    };
    // EM: open header branch as well
    l0head = l0tr->GetBranch("Header");
    if ( !l0head ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: no Header branch in Level0 tree\n");
      l0File->Close();
      code = -8;
      goto closeandexit;    
    };
    l0tr->SetBranchAddress("Header", &eh);
    // end EM
    nevents = l0head->GetEntries();
    //
    if ( nevents < 1 && totevent ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: Level0 file is empty\n\n");
      l0File->Close();
      code = -11;
      goto closeandexit;
    };
    // 
    if ( runinfo->EV_TO > nevents-1 && totevent ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: too few entries in the registry tree\n");
      l0File->Close();
      code = -12;
      goto closeandexit;
    };
    //
    //     TTree *tp = (TTree*)l0File->Get("RunHeader");
    //     tp->SetBranchAddress("Header", &eH);
    //     tp->SetBranchAddress("RunHeader", &reh);
    //     tp->GetEntry(0);
    //     ph = eH->GetPscuHeader();
    //     ULong_t TimeSync = reh->LAST_TIME_SYNC_INFO;
    //     ULong_t ObtSync = reh->OBT_TIME_SYNC;    
    //     if ( debug ) printf(" 1 TimeSync %lu ObtSync %lu DeltaOBT %lu\n",TimeSync,ObtSync,TimeSync-ObtSync);
    //
    ULong_t TimeSync = (ULong_t)dbtime->GetTimesync();
    ULong_t ObtSync = (ULong_t)(dbtime->GetObt0()/1000);
    ULong_t DeltaOBT = TimeSync - ObtSync;

    if ( debug ) printf(" 2 TimeSync %lu ObtSync %lu DeltaOBT %lu\n",(ULong_t)(dbtime->GetTimesync()/1000),(ULong_t)dbtime->GetObt0(),TimeSync-ObtSync);
    //
    // Read MCMDs from up to 11 files, 5 before and 5 after the present one in order to have some kind of inclination information
    //
    ch = new TChain("Mcmd","Mcmd");
    //
    // look in the DB to find the closest files to this run
    //
    TSQLResult *pResult = 0;
    TSQLRow *Row = 0;
    stringstream myquery;
    UInt_t l0fid[10];
    Int_t i = 0;
    memset(l0fid,0,10*sizeof(Int_t));
    //
    myquery.str("");
    myquery << "select ID_ROOT_L0 from GL_RUN where RUNHEADER_TIME<=" << runinfo->RUNHEADER_TIME << " group by ID_ROOT_L0 order by RUNHEADER_TIME desc limit 5;";
    //
    pResult = dbc->Query(myquery.str().c_str());
    //
    i = 9;
    if( pResult ){ 
      //
      Row = pResult->Next();
      //
      while ( Row ){
	//
	// store infos and exit
	//
	l0fid[i] = (UInt_t)atoll(Row->GetField(0));
	i--;
	Row = pResult->Next();	
	//
      };
      pResult->Delete();
    };
    //
    myquery.str("");
    myquery << "select ID_ROOT_L0 from GL_RUN where RUNHEADER_TIME>" << runinfo->RUNHEADER_TIME << " group by ID_ROOT_L0 order by RUNHEADER_TIME asc limit 5;";
    //
    pResult = dbc->Query(myquery.str().c_str());
    //
    i = 0;
    if( pResult ){ 
      //
      Row = pResult->Next();
      //
      while ( Row ){
	//
	// store infos and exit
	//
	l0fid[i] = (UInt_t)atoll(Row->GetField(0));
	i++;
	Row = pResult->Next();	
	//
      };
      pResult->Delete();
    };
    //
    i = 0;
    UInt_t previd = 0;
    while ( i < 10 ){
      if ( l0fid[i] && previd != l0fid[i] ){
	previd = l0fid[i];
	myquery.str("");
	myquery << "select PATH,NAME from GL_ROOT where ID=" << l0fid[i] << " ;";
	//
	pResult = dbc->Query(myquery.str().c_str());
	//
	if( pResult ){ 
	  //
	  Row = pResult->Next();
	  //
	  if ( debug ) printf(" Using inclination informations from file: %s \n",(((TString)gSystem->ExpandPathName(Row->GetField(0)))+"/"+(TString)Row->GetField(1)).Data());
	  ch->Add(((TString)gSystem->ExpandPathName(Row->GetField(0)))+"/"+(TString)Row->GetField(1));
	  //
	  pResult->Delete();
	};
      };
      i++;
    };
    //
    //    l0trm = (TTree*)l0File->Get("Mcmd");
    //    ch->ls();
    ch->SetBranchAddress("Mcmd",&mcmdev);
    //    printf(" entries %llu \n", ch->GetEntries());
    //    l0trm = ch->GetTree();
    //    neventsm = l0trm->GetEntries();
    neventsm = ch->GetEntries();
    if ( debug ) printf(" entries %u \n", neventsm);
    //    neventsm = 0;
    //
    if (neventsm == 0){
      if ( debug ) printf("InclinationInfo - WARNING: No quaternions in this File");
      //      l0File->Close();
      code = 900;
      //      goto closeandexit;
    }
    //
    
    //    l0trm->SetBranchAddress("Mcmd", &mcmdev);
    //    l0trm->SetBranchAddress("Header", &eh);
    //
    //
    //

//    UInt_t mctren = 0;    
//    UInt_t mcreen = 0;	
    UInt_t numrec = 0;
    //
    Double_t upperqtime = 0;
    Double_t lowerqtime = 0;
    
//    Double_t incli = 0;
//    oi = 0;
//    UInt_t ooi = 0;
    //
    // init quaternions information from mcmd-packets
    //
    Bool_t isf = true;
//    Int_t fgh = 0;

    vector<Float_t> q0;
    vector<Float_t> q1;
    vector<Float_t> q2;
    vector<Float_t> q3;
    vector<Double_t> qtime;
    vector<Float_t> qPitch;
    vector<Float_t> qRoll;
    vector<Float_t> qYaw;
    vector<Int_t> qmode;

    Int_t nt = 0;
    
    //init sine-function interpolation
    
    //cout<<"Sine coeficient initialisation..."<<endl;
    vector<Sine> q0sine;
    vector<Sine> q1sine;
    vector<Sine> q2sine;
    vector<Sine> q3sine;
    vector<Sine> Yawsine;

    /*TH2F* q0testing = new TH2F();
      TH2F* q1testing = new TH2F();
      TH2F* q2testing = new TH2F();
      TH2F* q3testing = new TH2F();
      TH2F* Pitchtesting = new TH2F();
    */
    UInt_t must = 0;

    //
    // run over all the events of the run
    //
    if (verbose) printf("\n Ready to start! \n\n Processed events: \n\n");
    //
    //
    for ( re = runinfo->EV_FROM; re < (runinfo->EV_FROM+runinfo->NEVENTS); re++){
      //
      if ( procev%1000 == 0 && procev > 0 && verbose ) printf(" %iK \n",procev/1000);	
      if ( debug ) printf(" %i \n",procev);      
      //
      if ( l0head->GetEntry(re) <= 0 ) throw -36;
      //
      // absolute time of this event
      //
      ph = eh->GetPscuHeader();
      atime = dbtime->DBabsTime(ph->GetOrbitalTime());
      if ( debug ) printf(" %i absolute time \n",procev);      
      //
      // paranoid check
      //
      if ( (atime > (runinfo->RUNTRAILER_TIME+1)) || (atime < (runinfo->RUNHEADER_TIME-1))  ) {
	if (verbose) printf(" OrbitalInfo - WARNING: event at time outside the run time window, skipping it\n");
	jumped++;
	//	debug = true;
	continue;
      }

      //
      // retrieve tof informations
      //
      if ( !reprocall ){
	itr = nobefrun + (re - evfrom - jumped);
	//itr = re-(46438+200241);
      } else {
	itr = runinfo->GetFirstEntry() + (re - evfrom - jumped);
      };
      //
      if ( !standalone ){
	if ( itr > nevtofl2 ){  
	  if ( verbose ) printf(" OrbitalInfo - ERROR: no tof events with entry = %i in Level2 file\n",itr);
	  if ( debug ) printf(" nobefrun %u re %u evfrom %u jumped %u reprocall %i \n",nobefrun,re,evfrom,jumped,reprocall);
	  l0File->Close();
	  code = -901;
	  goto closeandexit; 
	};
	//
	tof->Clear();
	//
	if ( ttof->GetEntry(itr) <= 0 ) throw -36; 
	//
      };
      //
      procev++;
      //
      // start processing
      //
      if ( debug ) printf(" %i start processing \n",procev);      
      orbitalinfo->Clear();
      //
      OrbitalInfoTrkVar *t_orb = new OrbitalInfoTrkVar();
      if( !(orbitalinfo->OrbitalInfoTrk) ) orbitalinfo->OrbitalInfoTrk = new TClonesArray("OrbitalInfoTrkVar",2); 
      TClonesArray &tor = *orbitalinfo->OrbitalInfoTrk;
      //
      // Fill OBT, pkt_num and absTime
      //      
      orbitalinfo->pkt_num = ph->GetCounter();
      orbitalinfo->OBT = ph->GetOrbitalTime();
      orbitalinfo->absTime = atime;
      if ( debug ) printf(" %i pktnum obt abstime \n",procev);      
      //
      // Propagate the orbit from the tle time to atime, using SGP(D)4.
      //
      if ( debug ) printf(" %i sgp4 \n",procev);      
      cCoordGeo coo;
      Float_t jyear=0.;     
      //
      if(atime >= gltle->GetToTime()) {
	if ( !gltle->Query(atime, dbc) ){
	  //	  
	  // Compute the magnetic dipole moment.
	  //
	  if ( debug ) printf(" %i compute magnetic dipole moment \n",procev);      
	  UInt_t year, month, day, hour, min, sec;
	  //
	  TTimeStamp t = TTimeStamp(atime, kTRUE);
	  t.GetDate(kTRUE, 0, &year, &month, &day);
	  t.GetTime(kTRUE, 0, &hour, &min, &sec);
	  jyear = (float) year 
	    + (month*31.+ (float) day)/365. 
	    + (hour*3600.+min*60.+(float)sec)/(24.*3600.*365.);
	  //
	  if ( debug ) printf(" %i compute magnetic dipole moment get dipole moment for year\n",procev);      
	  feldcof_(&jyear, &dimo); // get dipole moment for year
	  if ( debug ) printf(" %i compute magnetic dipole moment end\n",procev);      
	} else {
	  code = -56;
	  goto closeandexit;
	};
      }
      coo = getCoo(atime, gltle->GetFromTime(), gltle->GetTle());
      //
      cOrbit orbits(*gltle->GetTle());
      //
      if ( debug ) printf(" I am Here \n");
      //
      // synchronize with quaternions data
      //
      if ( isf && neventsm>0 ){
	//
	// First event
	//
	isf = false;
	upperqtime = atime;
	lowerqtime = runinfo->RUNHEADER_TIME;
	for ( ik = 0; ik < neventsm; ik++){  //number of macrocommad packets
	  if ( ch->GetEntry(ik) <= 0 ) throw -36;
	  tmpSize = mcmdev->Records->GetEntries();
	  numrec = tmpSize;
	  for (Int_t j3 = 0;j3<tmpSize;j3++){  //number of subpackets
	    if ( debug ) printf(" ik %i j3 %i eh eh eh \n",ik,j3);
	    mcmdrc = (pamela::McmdRecord*)mcmdev->Records->At(j3);
	    if ( mcmdrc ){ // missing inclination bug [8RED 090116]
	      if ( debug ) printf(" pluto \n");
	      if ((int)mcmdrc->ID1 == 226 && mcmdrc->Mcmd_Block_crc_ok == 1){ //Check that it is Inclination Packet
	        L_QQ_Q_l_upper->fill(mcmdrc->McmdData);
		for (UInt_t ui = 0; ui < 6; ui++){
		  if (ui>0){
		    if (L_QQ_Q_l_upper->time[ui]>L_QQ_Q_l_upper->time[0]){
			if ( debug ) printf(" here1 %i \n",ui);
		      Double_t u_time = dbtime->DBabsTime((UInt_t)(L_QQ_Q_l_upper->time[ui]*1000-DeltaOBT*1000));
		      Int_t recSize = recqtime.size();
		      for(Int_t mu = nt;mu<recSize;mu++){
			if(recqtime[mu]>lowerqtime && recqtime[mu]<u_time){
			  nt=mu;
			  Int_t sizeqmcmd = qtime.size();
			  inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			  qtime[sizeqmcmd]=recqtime[mu];
			  q0[sizeqmcmd]=recq0[mu];
			  q1[sizeqmcmd]=recq1[mu];
			  q2[sizeqmcmd]=recq2[mu];
			  q3[sizeqmcmd]=recq3[mu];
			  qmode[sizeqmcmd]=-10;
			  orbits.getPosition((double) (qtime[sizeqmcmd] - gltle->GetFromTime())/60., &eCi);
			  RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,recq0[mu],recq1[mu],recq2[mu],recq3[mu]);
			  qRoll[sizeqmcmd]=RYPang_upper->Kren;
			  qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			  qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
			}
			if(recqtime[mu]>=u_time){
			  Int_t sizeqmcmd = qtime.size();
			  inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			  qtime[sizeqmcmd]=u_time;
			  q0[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][0];
			  q1[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][1];
			  q2[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][2];
			  q3[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][3];
			  qmode[sizeqmcmd]=holeq(lowerqtime,qtime[sizeqmcmd],L_QQ_Q_l_lower,L_QQ_Q_l_upper,ui);
			  lowerqtime = u_time;
			  orbits.getPosition((double) (u_time - gltle->GetFromTime())/60., &eCi);
			  RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,L_QQ_Q_l_upper->quat[ui][0],L_QQ_Q_l_upper->quat[ui][1],L_QQ_Q_l_upper->quat[ui][2],L_QQ_Q_l_upper->quat[ui][3]);
			  qRoll[sizeqmcmd]=RYPang_upper->Kren;
			  qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			  qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
			  break;
			}
		      }
		    }
		  }else{
			if ( debug ) printf(" here2 %i \n",ui);
		    Double_t u_time = dbtime->DBabsTime((UInt_t)(L_QQ_Q_l_upper->time[0]*1000-DeltaOBT*1000));
		    if(lowerqtime>u_time)nt=0;
		    Int_t recSize = recqtime.size();
		    for(Int_t mu = nt;mu<recSize;mu++){
		      if(recqtime[mu]>lowerqtime && recqtime[mu]<u_time){
			nt=mu;
			Int_t sizeqmcmd = qtime.size();
			inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			qtime[sizeqmcmd]=recqtime[mu];
			q0[sizeqmcmd]=recq0[mu];
			q1[sizeqmcmd]=recq1[mu];
			q2[sizeqmcmd]=recq2[mu];
			q3[sizeqmcmd]=recq3[mu];
			qmode[sizeqmcmd]=-10;
			orbits.getPosition((double) (qtime[sizeqmcmd] - gltle->GetFromTime())/60., &eCi);
			RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,recq0[mu],recq1[mu],recq2[mu],recq3[mu]);
			qRoll[sizeqmcmd]=RYPang_upper->Kren;
			qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
		      }
		      if(recqtime[mu]>=u_time){
			Int_t sizeqmcmd = qtime.size();
			inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			qtime[sizeqmcmd]=u_time;
			q0[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][0];
			q1[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][1];
			q2[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][2];
			q3[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][3];
			qmode[sizeqmcmd]=holeq(lowerqtime,qtime[sizeqmcmd],L_QQ_Q_l_lower,L_QQ_Q_l_upper,ui);
			lowerqtime = u_time;
			orbits.getPosition((double) (u_time - gltle->GetFromTime())/60., &eCi);
			RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,L_QQ_Q_l_upper->quat[0][0],L_QQ_Q_l_upper->quat[0][1],L_QQ_Q_l_upper->quat[0][2],L_QQ_Q_l_upper->quat[0][3]);
			qRoll[sizeqmcmd]=RYPang_upper->Kren;
			qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
			CopyQ(L_QQ_Q_l_lower,L_QQ_Q_l_upper);
			break;
		      }
		    }
		  }
		}
	      }
	    }
	    if ( debug ) printf(" ciccio \n");
	  }
	}
	
	if(qtime.size()==0){
	    for(UInt_t my=0;my<recqtime.size();my++){
		Int_t sizeqmcmd = qtime.size();
		inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
		qtime[sizeqmcmd]=recqtime[my];
		q0[sizeqmcmd]=recq0[my];
		q1[sizeqmcmd]=recq1[my];
		q2[sizeqmcmd]=recq2[my];
		q3[sizeqmcmd]=recq3[my];
		qmode[sizeqmcmd]=-10;
		orbits.getPosition((double) (qtime[sizeqmcmd] - gltle->GetFromTime())/60., &eCi);
		RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,recq0[my],recq1[my],recq2[my],recq3[my]);
		qRoll[sizeqmcmd]=RYPang_upper->Kren;
		qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
		qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
	    }
	}
	
	if ( debug ) printf(" fuffi \n");

	//sineparam(q0sine,qtime,q0,qRoll,qPitch,0.60);
	//sineparam(q1sine,qtime,q1,qRoll,qPitch,0.82);
	//sineparam(q2sine,qtime,q2,qRoll,qPitch,0.82);
	//sineparam(q3sine,qtime,q3,qRoll,qPitch,0.60);
	//sineparam(Yawsine,qtime,qYaw,qRoll,qPitch,4);

	if ( debug ) printf(" puffi \n");
	Double_t tmin = 9999999999.;
	Double_t tmax = 0.;
	for(UInt_t tre = 0;tre<qtime.size();tre++){
	  if(qtime[tre]>tmax)tmax = qtime[tre];
	  if(qtime[tre]<tmin)tmin = qtime[tre];
	}
	if ( debug ) printf(" gnfuffi \n");

	//q0testing->SetName("q0testing");
	//q1testing->SetName("q1testing");
	//q2testing->SetName("q2testing");
	//q3testing->SetName("q3testing");
	
//	Int_t ss=10.*(tmax-tmin);
	//q0testing->SetBins(ss,tmin,tmax,1000,-1.,1.);
	//Pitchtesting->SetBins(ss,tmin,tmax,1000,-40.,40.);

//	for(Int_t tre = 0;tre<qtime.size();tre++){
	  //cout<<"q0["<<tre<<" = "<<q0[tre]<<endl;
	  //q0testing->Fill(qtime[tre],q0[tre]);
	  //q1testing->Fill(qtime[tre],q1[tre]);
	  //Pitchtesting->Fill(qtime[tre],qPitch[tre],100);
	  //if(qmode[tre] == -10)Pitchtesting->Fill(qtime[tre],10,100);
	  //q2testing->Fill(qtime[tre],q2[tre],100);
	  //q3testing->Fill(qtime[tre],q3[tre],100);
//	}
	
	//for(Int_t tre=0;tre<q0sine.size();tre++)cout<<q1sine[tre].A<<"*sin("<<q1sine[tre].b<<"x+"<<q1sine[tre].c<<")\t time start: "<<q1sine[tre].startPoint<<"\ttime end: "<<q1sine[tre].finishPoint<<endl;
	//for(Int_t tre=0;tre<q0sine.size();tre++)cout<<q1sine[tre].A<<"*sin("<<q1sine[tre].b<<"x+"<<q1sine[tre].c<<")\t time start: "<<q0sine[tre].startPoint<<"\ttime end: "<<q0sine[tre].finishPoint<<endl;
      } // if we processed first event
      
      //Filling Inclination information
      Double_t incli = 0;
      if ( qtime.size() > 1 ){
      for(UInt_t mu = must;mu<qtime.size()-1;mu++){
	if ( debug ) printf(" ??grfuffi %i sixe %i must %i \n",mu,qtime.size()-1,must);
	if(qtime[mu+1]>qtime[mu]){
	  if ( debug ) printf(" grfuffi2 %i \n",mu);
	  if(atime<=qtime[mu+1] && atime>=qtime[mu]){
	    must = mu;
	    incli = (qPitch[mu+1]-qPitch[mu])/(qtime[mu+1]-qtime[mu]);
	    orbitalinfo->theta =  incli*atime+qPitch[mu+1]-incli*qtime[mu+1];
	    incli = (qRoll[mu+1]-qRoll[mu])/(qtime[mu+1]-qtime[mu]);
	    orbitalinfo->etha =  incli*atime+qRoll[mu+1]-incli*qtime[mu+1];
	    incli = (qYaw[mu+1]-qYaw[mu])/(qtime[mu+1]-qtime[mu]);
	    orbitalinfo->phi =  incli*atime+qYaw[mu+1]-incli*qtime[mu+1];
	    
	    incli = (q0[mu+1]-q0[mu])/(qtime[mu+1]-qtime[mu]);
	    orbitalinfo->q0 =  incli*atime+q0[mu+1]-incli*qtime[mu+1];
	    incli = (q1[mu+1]-q1[mu])/(qtime[mu+1]-qtime[mu]);
	    orbitalinfo->q1 =  incli*atime+q1[mu+1]-incli*qtime[mu+1];
	    incli = (q2[mu+1]-q2[mu])/(qtime[mu+1]-qtime[mu]);
	    orbitalinfo->q2 =  incli*atime+q2[mu+1]-incli*qtime[mu+1];
	    incli = (q3[mu+1]-q3[mu])/(qtime[mu+1]-qtime[mu]);
	    orbitalinfo->q3 =  incli*atime+q3[mu+1]-incli*qtime[mu+1];
	    
	    orbitalinfo->TimeGap = qtime[mu+1]-qtime[mu];
	    orbitalinfo->mode = qmode[mu+1];
	    //if(qmode[mu+1]==-10) orbitalinfo->R10r = true;else orbitalinfo->R10r = false;
	    //reserved for next versions Vitaly.
	    /*if(qmode[mu+1]==-10 || qmode[mu+1]==0 || qmode[mu+1]==1 || qmode[mu+1]==3 || qmode[mu+1]==4 || qmode[mu+1]==6){
	      //linear interpolation
	      incli = (q0[mu+1]-q0[mu])/(qtime[mu+1]-qtime[mu]);
	      orbitalinfo->q0 =  incli*atime+q0[mu+1]-incli*qtime[mu+1];
	      incli = (q1[mu+1]-q1[mu])/(qtime[mu+1]-qtime[mu]);
	      orbitalinfo->q1 =  incli*atime+q1[mu+1]-incli*qtime[mu+1];
	      incli = (q2[mu+1]-q2[mu])/(qtime[mu+1]-qtime[mu]);
	      orbitalinfo->q2 =  incli*atime+q2[mu+1]-incli*qtime[mu+1];
	      incli = (q3[mu+1]-q3[mu])/(qtime[mu+1]-qtime[mu]);
	      orbitalinfo->q3 =  incli*atime+q3[mu+1]-incli*qtime[mu+1];
	    }else{
	      //sine interpolation
	      for(UInt_t mt=0;mt<q0sine.size();mt++){
		if(atime<=q0sine[mt].finishPoint && atime>=q0sine[mt].startPoint){
		  if(!q0sine[mt].NeedFit)orbitalinfo->q0=q0sine[mt].A*sin(q0sine[mt].b*atime+q0sine[mt].c);else{
		    incli = (q0[mu+1]-q0[mu])/(qtime[mu+1]-qtime[mu]);
		    orbitalinfo->q0 =  incli*atime+q0[mu+1]-incli*qtime[mu+1];
		  }
		}
		if(atime<=q1sine[mt].finishPoint && atime>=q1sine[mt].startPoint){
		  if(!q1sine[mt].NeedFit)orbitalinfo->q1=q1sine[mt].A*sin(q1sine[mt].b*atime+q1sine[mt].c);else{
		    incli = (q1[mu+1]-q1[mu])/(qtime[mu+1]-qtime[mu]);
		    orbitalinfo->q1 =  incli*atime+q1[mu+1]-incli*qtime[mu+1];
		  }
		}
		if(atime<=q2sine[mt].finishPoint && atime>=q2sine[mt].startPoint){
		  if(!q2sine[mt].NeedFit)orbitalinfo->q2=q0sine[mt].A*sin(q2sine[mt].b*atime+q2sine[mt].c);else{
		    incli = (q2[mu+1]-q2[mu])/(qtime[mu+1]-qtime[mu]);
		    orbitalinfo->q2 =  incli*atime+q2[mu+1]-incli*qtime[mu+1];
		  }
		}
		if(atime<=q3sine[mt].finishPoint && atime>=q3sine[mt].startPoint){
		  if(!q3sine[mt].NeedFit)orbitalinfo->q3=q0sine[mt].A*sin(q3sine[mt].b*atime+q3sine[mt].c);else{
		    incli = (q3[mu+1]-q3[mu])/(qtime[mu+1]-qtime[mu]);
		    orbitalinfo->q3 =  incli*atime+q3[mu+1]-incli*qtime[mu+1];
		  }
		}
		if(atime<=Yawsine[mt].finishPoint && atime>=Yawsine[mt].startPoint){
		  if(!Yawsine[mt].NeedFit)orbitalinfo->phi=Yawsine[mt].A*sin(Yawsine[mt].b*atime+Yawsine[mt].c);else{
		    incli = (qYaw[mu+1]-qYaw[mu])/(qtime[mu+1]-qtime[mu]);
		    orbitalinfo->phi =  incli*atime+qYaw[mu+1]-incli*qtime[mu+1];
		  }
		}
	      }
	    }*/
	    //q0testing->Fill(atime,orbitalinfo->q0,100);
	    //q1testing->Fill(atime,orbitalinfo->q1,100);
	    //Pitchtesting->Fill(atime,orbitalinfo->etha);
	    //q2testing->Fill(atime,orbitalinfo->q2);
	    //q3testing->Fill(atime,orbitalinfo->q3);
	    break;
	  }
	}
      }
      }
      //
      // ops no inclination information
      //

      if ( orbitalinfo->q0< -999 || orbitalinfo->q1 < -999 || orbitalinfo->q2 < -999 || orbitalinfo->q3 < -999 || orbitalinfo->q0 != orbitalinfo->q0 || orbitalinfo->q1 != orbitalinfo->q1 || orbitalinfo->q2 != orbitalinfo->q2 || orbitalinfo->q3 != orbitalinfo->q3 ){
	orbitalinfo->mode = 10;
	orbitalinfo->q0 = -1000.;
	orbitalinfo->q1 = -1000.;
	orbitalinfo->q2 = -1000.;
	orbitalinfo->q3 = -1000.;
	orbitalinfo->etha = -1000.;
	orbitalinfo->phi = -1000.;
	orbitalinfo->theta = -1000.;
      };
      //
      // #########################################################################################################################   
      //
      // fill orbital positions
      //        
      // Build coordinates in the right range.  We want to convert,
      // longitude from (0, 2*pi) to (-180deg, 180deg).  Altitude is
      // in meters.
      lon = (coo.m_Lon > M_PI) ? rad2deg(coo.m_Lon - 2*M_PI) : rad2deg(coo.m_Lon);
      lat = rad2deg(coo.m_Lat);
      alt = coo.m_Alt;
      //
      if( lon<180 && lon>-180 && lat<90 && lat>-90 && alt>0 ){	
	//      
	orbitalinfo->lon = lon;
	orbitalinfo->lat = lat;
	orbitalinfo->alt = alt ;
	//
	// compute mag field components and L shell.
	//
	feldg_(&lat, &lon, &alt, &bnorth, &beast, &bdown, &babs);
	shellg_(&lat, &lon, &alt, &dimo, &xl, &icode, &bab1);
	findb0_(&stps, &bdel, &value, &bequ, &rr0);
	//
	orbitalinfo->Bnorth = bnorth;
	orbitalinfo->Beast = beast;
	orbitalinfo->Bdown = bdown;
	orbitalinfo->Babs = babs;
	orbitalinfo->BB0 = babs/bequ;
	orbitalinfo->L = xl;      
	// Set Stormer vertical cutoff using L shell.
	orbitalinfo->cutoffsvl = 14.9/(xl*xl);
	//
      };      
      //
      if ( debug ) printf(" pitch angle \n");
      //
      // pitch angles
      //
      //if ( orbitalinfo->mode != 10 && orbitalinfo->mode != 5 && orbitalinfo->mode !=7 && orbitalinfo->mode != 9 ){
      if( orbitalinfo->TimeGap>0 && orbitalinfo->TimeGap<2000000){
	//
	Float_t Bx = -orbitalinfo->Bdown;
	Float_t By = orbitalinfo->Beast;
	Float_t Bz = orbitalinfo->Bnorth;
	//
	TMatrixD Fij = PO->ECItoGreenwich(PO->QuatoECI(orbitalinfo->q0,orbitalinfo->q1,orbitalinfo->q2,orbitalinfo->q3),orbitalinfo->absTime);
	TMatrixD Gij = PO->ColPermutation(Fij);
	TMatrixD Dij = PO->GreenwichtoGEO(orbitalinfo->lat,orbitalinfo->lon,Fij);
	TMatrixD Iij = PO->ColPermutation(Dij);
	//
	orbitalinfo->Iij.ResizeTo(Iij);
	orbitalinfo->Iij = Iij;
	//
	A1 = Iij(0,2);
	A2 = Iij(1,2);
	A3 = Iij(2,2);
	//
	//	orbitalinfo->pamzenitangle = (Float_t)PO->GetPitchAngle(1,0,0,A1,A2,A3);		        // Angle between zenit and Pamela's main axiz
	//	orbitalinfo->pamBangle = (Float_t)PO->GetPitchAngle(A1,A2,A3,Bx,By,Bz);			// Angle between Pamela's main axiz and B
	//
	if ( !standalone && tof->ntrk() > 0 ){
	  //
	  Int_t nn = 0;
	  for(Int_t nt=0; nt < tof->ntrk(); nt++){  
	    //
	    ToFTrkVar *ptt = tof->GetToFTrkVar(nt); 
	    Double_t E11x = ptt->xtr_tof[0]; // tr->x[0];
	    Double_t E11y = ptt->ytr_tof[0]; //tr->y[0];
	    Double_t E11z = zin[0];
	    Double_t E22x = ptt->xtr_tof[3];//tr->x[3];
	    Double_t E22y = ptt->ytr_tof[3];//tr->y[3];
	    Double_t E22z = zin[3];
	    if ( (E11x < 100. && E11y < 100. && E22x < 100. && E22y < 100.) || ptt->trkseqno != -1  ){
	      Double_t norm = sqrt(pow(E22x-E11x,2)+pow(E22y-E11y,2)+pow(E22z-E11z,2));
	      // 	      Double_t MyAzim = TMath::RadToDeg()*atan(TMath::Abs(E22y-E11y)/TMath::Abs(E22x-E11x));
	      // 	      if(E22x-E11x>=0 && E22y-E11y <0) MyAzim =  360. - MyAzim;
	      // 	      if(E22x-E11x>=0 && E22y-E11y >=0) MyAzim = MyAzim;
	      // 	      if(E22x-E11x<0 && E22y-E11y >0) MyAzim = 180. - MyAzim;
	      // 	      if(E22x-E11x<0 && E22y-E11y <0) MyAzim = 180. + MyAzim;
	      Px = (E22x-E11x)/norm;
	      Py = (E22y-E11y)/norm;
	      Pz = (E22z-E11z)/norm;
	      //
	      t_orb->trkseqno = ptt->trkseqno; 
	      //
	      TMatrixD Eij = PO->PamelatoGEO(Iij,Px,Py,Pz);
	      t_orb->Eij.ResizeTo(Eij);	
	      t_orb->Eij = Eij;	
	      //
	      TMatrixD Sij = PO->PamelatoGEO(Dij,Px,Py,Pz);
	      t_orb->Sij.ResizeTo(Sij);
	      t_orb->Sij = Sij;
	      //	    
	      t_orb->pitch = (Float_t)PO->GetPitchAngle(Eij(0,0),Eij(1,0),Eij(2,0),Bx,By,Bz);
	      //
	      //
	      Double_t omega = PO->GetPitchAngle(Eij(0,0),Eij(1,0),Eij(2,0),cos(orbitalinfo->lon+TMath::Pi()/2)-sin(orbitalinfo->lon+TMath::Pi()/2),cos(orbitalinfo->lon+TMath::Pi()/2)+sin(orbitalinfo->lon+TMath::Pi()/2),1);
	      //
	      t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow((1+sqrt(1-pow(orbitalinfo->L,-3/2)*cos(omega))),2));
	      //
	      if ( t_orb->pitch != t_orb->pitch ) t_orb->pitch = -1000.;
	      if ( t_orb->cutoff != t_orb->cutoff ) t_orb->cutoff = -1000.;
	      //
	      if ( debug ) printf(" orbitalinfo->cutoffsvl %f vitaly %f \n",orbitalinfo->cutoffsvl,t_orb->cutoff);
 	      //
 	      new(tor[nn]) OrbitalInfoTrkVar(*t_orb);
	      nn++;
 	      //
 	      t_orb->Clear();
	      //
	    };
	    //
	  };
	} else {
	  if ( debug ) printf(" mmm... mode %u standalone %i ntrk %i \n",orbitalinfo->mode,standalone,tof->ntrk());
	};
	//
      } else {
	if ( !standalone && tof->ntrk() > 0 ){
	  //
	  Int_t nn = 0;
	  for(Int_t nt=0; nt < tof->ntrk(); nt++){  
	    //
	    ToFTrkVar *ptt = tof->GetToFTrkVar(nt); 
	    if ( ptt->trkseqno != -1  ){
	      //
	      t_orb->trkseqno = ptt->trkseqno; 
	      //
	      t_orb->Eij = 0;	
	      //
	      t_orb->Sij = 0;
	      //	    
	      t_orb->pitch = -1000.;
	      //
	      t_orb->cutoff = -1000.;
	      //
 	      new(tor[nn]) OrbitalInfoTrkVar(*t_orb);
	      nn++;
 	      //
 	      t_orb->Clear();
	      //
	    };
	    //
	  };	
	};
      };
      //
      // Fill the class
      //
      OrbitalInfotr->Fill();
      //
      delete t_orb;
      //
    }; // loop over the events in the run
    //
    // Here you may want to clear some variables before processing another run  
    //

    //gStyle->SetOptStat(000000);
    //gStyle->SetPalette(1);
    
    /*TCanvas* c1 = new TCanvas("c1","",1200,800);
    //c1->Divide(1,4);
    c1->cd(1);
    //q0testing->Draw("colz");
    //c1->cd(2);
    //q1testing->Draw("colz");
    //c1->cd(3);
    Pitchtesting->Draw("colz");
    //c1->cd(4);
    //q3testing->Draw("colz");
    c1->SaveAs("9.Rollhyst.png");
    delete c1;*/

    delete dbtime;
    if ( L_QQ_Q_l_upper ) delete L_QQ_Q_l_upper;
    if ( L_QQ_Q_l_lower ) delete L_QQ_Q_l_lower;
    if ( RYPang_upper ) delete RYPang_upper;
    if ( RYPang_lower ) delete RYPang_lower;
  }; // process all the runs
  
  if (verbose) printf("\n Finished processing data \n");
  //
 closeandexit:
  //
  // we have finished processing the run(s). If we processed a single run now we must copy all the events after our run from the old tree to the new one and delete the old tree.
  //
  if ( !reprocall && reproc && code >= 0 ){
    if ( totfileentries > noaftrun ){
      if (verbose){
	printf("\n Post-processing: copying events from the old tree after the processed run\n");   
	printf(" Copying %i events in the file which are after the end of the run %i \n",(int)(totfileentries-noaftrun),(int)run);
	printf(" Start copying at event number %i end copying at event number %i \n",(int)noaftrun,(int)totfileentries);
      }
      for (UInt_t j = noaftrun; j < totfileentries; j++ ){
	//
	// Get entry from old tree
	//
	if ( OrbitalInfotrclone->GetEntry(j) <= 0 ) throw -36;	  
	//
	// copy orbitalinfoclone to OrbitalInfo
	//
	orbitalinfo->Clear();
	//
	memcpy(&orbitalinfo,&orbitalinfoclone,sizeof(orbitalinfoclone));
	//
	// Fill entry in the new tree
	//
	OrbitalInfotr->Fill();
      };
      if (verbose) printf(" Finished successful copying!\n");
    };
  };
  //
  // Close files, delete old tree(s), write and close level2 file 
  //
  if ( l0File ) l0File->Close();
  if ( tempfile ) tempfile->Close();            
  if ( myfold ) gSystem->Unlink(tempname.str().c_str());
  //
  if ( runinfo ) runinfo->Close();    
  if ( OrbitalInfotr ) OrbitalInfotr->SetName("OrbitalInfo");    
  if ( tof ) tof->Delete();
  if ( ttof ) ttof->Delete();
  //
  if ( file ){
    file->cd();
    file->Write();
  };
  //
  if ( myfold ) gSystem->Unlink(OrbitalInfofolder.str().c_str());
  //
  // the end
  //
  if ( dbc ){
    dbc->Close();
    delete dbc;
  };
  if (verbose) printf("\n Exiting...\n");
  if(OrbitalInfotr)OrbitalInfotr->Delete();
  //
  if ( PO ) delete PO;
  if ( orbitalinfo ) delete orbitalinfo;
  if ( orbitalinfoclone ) delete orbitalinfoclone;
  if ( glroot ) delete glroot;
  if ( runinfo ) delete runinfo; 
  //
  if(code < 0)  throw code;
  return(code);
}


//
// Returns the cCoordGeo structure holding the geographical
// coordinates for the event (see sgp4.h).
//
// atime is the abstime of the event in UTC unix time.
// tletime is the time of the tle in UTC unix time.
// tle is the previous and nearest tle (compared to atime).
cCoordGeo getCoo(UInt_t atime, UInt_t tletime, cTle *tle)
{
  cEci eci;
  cOrbit orbit(*tle);
  orbit.getPosition((double) (atime - tletime)/60., &eci);
  
  return eci.toGeo();
}

// function of copyng of quatrnions classes

void CopyQ(Quaternions *Q1, Quaternions *Q2){
  for(UInt_t i = 0; i < 6; i++){
    Q1->time[i]=Q2->time[i];
    for (UInt_t j = 0; j < 4; j++)Q1->quat[i][j]=Q2->quat[i][j];
  }
  return;
}

// functions of copyng InclinationInfo classes

void CopyAng(InclinationInfo *A1, InclinationInfo *A2){
  A1->Tangazh = A2->Tangazh;
  A1->Ryskanie = A2->Ryskanie;
  A1->Kren = A2->Kren;
  return;
}

UInt_t holeq(Double_t lower,Double_t upper,Quaternions *Qlower, Quaternions *Qupper, UInt_t f){
  
  UInt_t hole = 10;
  Bool_t R10l = false;     // Sign of R10 mode in lower quaternions array
  Bool_t R10u = false;     // Sign of R10 mode in upper quaternions array
  Bool_t insm = false;     // Sign that we inside quaternions array
  Bool_t mxtml = false;    // Sign of mixt mode in lower quaternions array
  Bool_t mxtmu = false;    // Sign of mixt mode in upper quaternions array
  Bool_t npasm = false;     // Sign of normall pass between R10 and non R10 or between non R10 and R10
  UInt_t NCQl = 6;       // Number of correct quaternions in lower array
  UInt_t NCQu = 6;       // Number of correct quaternions in upper array
  if (f>0){
    insm = true;
    if(Qupper->time[f]-Qupper->time[f-1]==30) R10u = false;
    if(Qupper->time[f]-Qupper->time[f-1]<1) R10u = true;
  }else{
    insm = false;
    if((Qlower->time[5]-Qlower->time[0]<2)&&(Qlower->time[1]-Qlower->time[0]<2)) R10l = true;
    if((Qupper->time[5]-Qupper->time[0]<2)&&(Qupper->time[1]-Qupper->time[0]<2)) R10u = true;
    if((Qlower->time[5]-Qlower->time[0]==150)&&(Qlower->time[1]-Qlower->time[0]==30)) R10l = false;
    if((Qupper->time[5]-Qupper->time[0]==150)&&(Qupper->time[1]-Qupper->time[0]==30)) R10u = false;
    if((Qlower->time[5]-Qlower->time[0]<2)&&(Qlower->time[1]-Qlower->time[0]==30)){
      mxtml = true;
      for(UInt_t i = 1; i < 6; i++){
	if(Qlower->time[i]-Qlower->time[0]==30*i) NCQl=i;
      }
    }
    if((Qupper->time[5]-Qupper->time[0]<2)&&(Qupper->time[1]-Qupper->time[0]==30)){
      mxtmu = true;
      for(UInt_t i = 1; i < 6; i++){
	if(Qupper->time[i]-Qupper->time[0]==30*i) NCQu=i;
      }
    }
  }
  
  if(((upper-lower==1.5)||(upper-lower==3.)||(upper-lower==30.)||(upper-lower==31.5)||(upper-lower==33.)||(upper-lower==181.5)||(upper-lower==210.)||(upper-lower==211.5))&&!insm) npasm = true;
  
  
  if (R10u&&insm) hole=0; // best event R10
  if ((upper-lower<=5)&&(!insm)&&R10l&&R10u) hole = 1; // when first of 6 quaternions in array is correct
  if (((!R10u)&&insm)||((!insm)&&(!R10u)&&(!R10l)&&((upper-lower==210+(6-NCQl)*30)||(upper-lower==30)))) hole = 2; //non R10
  if (npasm&&(!insm)&&((R10l&&!R10u)||(R10u&&!R10l))) hole = 3; //normall pass from R10 to non R10 or from non R10 to R10
  if ((!npasm)&&(upper-lower<=300)&&(!insm)&&((R10l&&!R10u)||(R10u&&!R10l))) hole = 4; // eliminable hole between R10 and non R10 or between non R10 and R10
  if ((upper-lower>=300)&&(!insm)&&((R10l&&!R10u)||(R10u&&!R10l))) hole = 5; //uneliminable hole between R10 and non R10 or between non R10 and R10
  if ((upper-lower>5)&&(upper-lower<=300)&&R10u&&R10l) hole = 6; // eliminable hole inside R10
  if ((upper-lower>300)&&R10u&&R10l) hole = 7; //uneliminable hole inside R10
  if ((upper-lower>210)&&(upper-lower<=1200)&&(!R10u)&&(!R10l)) hole = 8; //eliminable hole inside non R10
  if ((upper-lower>1200)&&!R10u&&!R10l) hole = 9; // uneliminable hole inside non R10
  return hole;
}

void inclresize(vector<Double_t>& t,vector<Float_t>& q0,vector<Float_t>& q1,vector<Float_t>& q2,vector<Float_t>& q3,vector<Int_t>& mode,vector<Float_t>& Roll,vector<Float_t>& Pitch,vector<Float_t>& Yaw){
  Int_t sizee = t.size()+1;
  t.resize(sizee);
  q0.resize(sizee);
  q1.resize(sizee);
  q2.resize(sizee);
  q3.resize(sizee);
  mode.resize(sizee);
  Roll.resize(sizee);
  Pitch.resize(sizee);
  Yaw.resize(sizee);
}

//Find fitting sine functions for q0,q1,q2,q3 and Yaw-angle;
void sineparam(vector<Sine>& qsine, vector<Double_t>& qtime, vector<Float_t>& q, vector<Float_t>& Roll, vector<Float_t>& Pitch, Float_t limsin){
  UInt_t mulast = 0;
  UInt_t munow = 0;
  UInt_t munext = 0;
  Bool_t increase = false;
  Bool_t decrease = false;
  Bool_t Max_is_defined = false;
  Bool_t Start_point_is_defined = false;
  Bool_t Period_is_defined = false;
  Bool_t Large_gap = false;
  Bool_t normal_way = true;
  Bool_t small_gap_on_ridge = false;
  Double_t t1 = 0;
  Double_t t1A = 0;
  Int_t sinesize = 0;
  Int_t nfi = 0;
  for(UInt_t mu = 0;mu<qtime.size();mu++){
    //cout<<"Roll["<<mu<<"] = "<<Roll[mu]<<endl;
    if(TMath::Abs(Roll[mu])<1. && TMath::Abs(Pitch[mu])<1. && TMath::Abs(q[mu])<limsin){
    //cout<<"q["<<mu<<endl<<"] = "<<q[mu]<<endl;
    if(mulast!=0 && munow!=0 && munext!=0){mulast=munow;munow=munext;munext=mu;}
    if(munext==0 && munow!=0)munext=mu;
    if(munow==0 && mulast!=0)munow=mu;
    if(mulast==0)mulast=mu;
    
    //cout<<"mulast = "<<mulast<<"\tmunow = "<<munow<<"\tmunext = "<<munext<<endl;
    //Int_t ref;
    //cin>>ref;
    if(TMath::Abs(q[munow])>TMath::Abs(q[mulast]) && TMath::Abs(q[munow])>TMath::Abs(q[munext]) && q[mulast]*q[munext]>0 && qtime[munext]-qtime[mulast]>400)small_gap_on_ridge = true;
    if(munext>mulast && (qtime[munext]-qtime[mulast]>=2000 || qtime[munext]-qtime[mulast]<0)){if(Large_gap){normal_way = false;Large_gap = false;}else{Large_gap = true;normal_way = false;}}else normal_way = true;
    //if(normal_way)cout<<"Normal_Way"<<endl;
    if(Large_gap || small_gap_on_ridge){
      //cout<<"Large gap..."<<endl;
      //if(small_gap_on_ridge)cout<<"small gap..."<<endl;
      //cout<<"q["<<mulast<<"] = "<<q[mulast]<<"\tq["<<munow<<"] = "<<q[munow]<<"\tq["<<munext<<"] = "<<q[munext]<<endl;
      //cout<<"qtime["<<mulast<<"] = "<<qtime[mulast]<<"\tqtime["<<munow<<"] = "<<qtime[munow]<<"\tqtime["<<munext<<"] = "<<qtime[munext]<<endl;
      increase = false;
      decrease = false;
      if(nfi>0){
	qsine.resize(qsine.size()-1);
	sinesize = qsine.size();
	//cout<<"nfi was larger then zero"<<endl;
      }else{
        //cout<<"nfi was not larger then zero :( nfi = "<<nfi<<endl;
	//cout<<"qsine.size = "<<qsine.size()<<endl;
	if(!Period_is_defined){
	  //cout<<"Period was defined"<<endl;
	  if(qsine.size()>1){
	    qsine[sinesize-1].b = qsine[sinesize-2].b;
	    qsine[sinesize-1].c = qsine[sinesize-2].c;
	  }else{
	    qsine[sinesize-1].b = TMath::Pi()/1591.54;
	    qsine[sinesize-1].c = qsine[sinesize-1].startPoint;
	  }
	}
	if(!Max_is_defined){
	  //cout<<"Max was already defined"<<endl;
	  if(qsine.size()>1)qsine[sinesize-1].A = qsine[sinesize-2].A;else qsine[sinesize-1].A = limsin;
	}
	qsine[sinesize-1].NeedFit = true;
      }
      qsine[sinesize-1].finishPoint = qtime[munow];
      //cout<<"finish point before large gap = "<<qtime[munow]<<endl;
      nfi = 0;
      Max_is_defined = false;
      Start_point_is_defined = false;
      Period_is_defined = false;
      small_gap_on_ridge = false;
    }
    //cout<<"Slope "<<increase<<"\t"<<decrease<<endl;
    //cout<<"mulast = "<<mulast<<"\tmunow = "<<munow<<"\tmunext = "<<munext<<endl;
    if((munext>munow) && (munow>mulast) && normal_way){
      if(!increase && !decrease){
        //cout<<"Normal way have started"<<endl;
	qsine.resize(qsine.size()+1);
	sinesize = qsine.size();
	qsine[sinesize-1].startPoint=qtime[mulast];
	if(q[munext]>q[munow] && q[munow]>q[mulast]) increase = true;
	if(q[munext]<q[munow] && q[munow]<q[mulast]) decrease = true;
      }
      //if(TMath::Abs(q[munow])>TMath::Abs(q[mulast]) && TMath::Abs(q[munow])>TMath::Abs(q[munext]) && TMath::Abs(q[munow])>limsin && qtime[munow]-qtime[mulast]>=400 || qtime[munext]-qtime[munow]>=400){small_gap_on_ridge = true;mu--;continue;}
      if(TMath::Abs(q[munow])>TMath::Abs(q[mulast]) && TMath::Abs(q[munow])>TMath::Abs(q[munext]) && TMath::Abs(q[munow])>0.9*limsin && qtime[munow]-qtime[mulast]<400 && qtime[munext]-qtime[munow]<400){
	//cout<<"Max point is qtime = "<<qtime[munow]<<"\tq = "<<q[munow]<<endl;
	if(q[munow]>q[mulast]){
	  increase = false;
	  decrease = true;
	}
	if(q[munow]<q[mulast]){
	  increase = true;
	  decrease = false;
	}
	if(Max_is_defined && !Start_point_is_defined){
	  Double_t qPer = qtime[munow]-t1A;
	  if(qPer>1000){
	    //cout<<"qsine["<<sinesize-1<<"] = "<<qPer<<" = "<<qtime[munow]<<" - "<<t1A<<"\tlim = "<<limsin<<endl;
	    qsine[sinesize-1].b=TMath::Pi()/qPer;
	    if(decrease)qsine[sinesize-1].c=-qsine[sinesize-1].b*t1A;
	    if(increase)qsine[sinesize-1].c=-qsine[sinesize-1].b*(t1A-qPer);
	    Period_is_defined = true;
	  }
	}
	Max_is_defined = true;
	qsine[sinesize-1].A = TMath::Abs(q[munow]);
	if(Start_point_is_defined && Period_is_defined){
	  qsine[sinesize-1].finishPoint = qtime[munow];
	  nfi++;
	  qsine[sinesize-1].NeedFit = false;
	  Max_is_defined = false;
	  Start_point_is_defined = false;
	  Period_is_defined = false;
	  qsine.resize(qsine.size()+1);
	  sinesize = qsine.size();
	  qsine[sinesize-1].startPoint = qtime[munow];
	}
	if(!Start_point_is_defined) t1A=qtime[munow];
      }
      //if((q[munow]>=0 && q[mulast]<=0) || (q[munow]<=0 && q[mulast]>=0))cout<<"cross zero point diference = "<<qtime[munext] - qtime[mulast]<<"\tqlast = "<<qtime[mulast]<<"\tqnow = "<<qtime[munow]<<"\tqnext = "<<qtime[munext]<<endl;
      if(((q[munow]>=0 && q[mulast]<=0) || (q[munow]<=0 && q[mulast]>=0)) && qtime[munow]-qtime[mulast]<2000 && qtime[munext]-qtime[munow]<2000){
	Double_t tcrosszero = 0;
	//cout<<"cross zero point...qtime = "<<qtime[munow]<<endl;
	if(q[munow]==0.) tcrosszero = qtime[munow];else
	  if(q[mulast]==0.)tcrosszero = qtime[mulast];else{
	    Double_t k_ = (q[munow]-q[mulast])/(qtime[munow]-qtime[mulast]);
	    Double_t b_ = q[munow]-k_*qtime[munow];
	    tcrosszero = -b_/k_;
	  }
	if(Start_point_is_defined){
	  //cout<<"Start Point allready defined"<<endl;
	  Double_t qPer = tcrosszero - t1;
	  qsine[sinesize-1].b = TMath::Pi()/qPer;
	  //cout<<"qsine["<<sinesize-1<<"].b = "<<TMath::Pi()/qPer<<endl;
	  Period_is_defined = true;
	  Float_t x0 = 0;
	  if(decrease)x0 = t1;
	  if(increase)x0 = tcrosszero;
	  qsine[sinesize-1].c = -qsine[sinesize-1].b*x0;
	  if(Max_is_defined){
	    //cout<<"Max was previous defined"<<endl;
	    qsine[sinesize-1].finishPoint = qtime[munow];
	    nfi++;
	    qsine[sinesize-1].NeedFit = false;
	    Max_is_defined = false;
	    t1 = tcrosszero;
	    Start_point_is_defined = true;
	    Period_is_defined = false;
	    qsine.resize(qsine.size()+1);
	    sinesize = qsine.size();
	    qsine[sinesize-1].startPoint = qtime[munow];
	  }
	}else{
	  t1 = tcrosszero;
	  Start_point_is_defined = true;
	}
      }
    }
    }
  }

  //cout<<"FINISH SINE INTERPOLATION FUNCTION..."<<endl<<endl;
}
