#include <OrbitalInfo.h>

OrbitalInfo::OrbitalInfo(){
  absTime = 0;
  OBT = 0;
  pkt_num = 0;

  lon = 0.;
  lat = 0.;
  alt = 0.;

  Bnorth = 0.;
  Beast = 0.;
  Bdown = 0.;
  Babs = 0.;
  BB0 = 0.;
  L = 0.;

  londip = -1000.;
  latdip = -1000.;
  altdip = -1000.;

  loncgm = -1000.;
  latcgm = -1000.;
  altcgm = -1000.;

  loncbm = -1000.;
  latcbm = -1000.;
  altcbm = -1000.;

  std::fill_n(cutoff, 20, 0.);

  // Quaternions
  q0 = -1000.;
  q1 = -1000.;
  q2 = -1000.;
  q3 = -1000.;

  // Euler angles (nadir reference frame)
  theta = -1000.;
  phi = -1000.;
  etha = -1000.;

//   // Euler angles (local field reference frame)
//   thetamag = -1000.;
//   phimag = -1000.;
//   ethamag = -1000.;
  mode = 0;
//  std::fill_n(goodAttitude, 5, 0);
}


void OrbitalInfo::Clear(){
  absTime = 0;
  OBT = 0;
  pkt_num = 0;

  lon = -1000.;
  lat = -1000.;
  alt = -1000.;

  Bnorth = -1000.;
  Beast = -1000.;
  Bdown = -1000.;
  Babs = -1000.;
  BB0 = -1000.;
  L = -1000.;

  londip = -1000.;
  latdip = -1000.;
  altdip = -1000.;

  loncgm = -1000.;
  latcgm = -1000.;
  altcgm = -1000.;

  loncbm = -1000.;
  latcbm = -1000.;
  altcbm = -1000.;

  std::fill_n(cutoff, 20, 0.);

  // Quaternions
  q0 = -1000.;
  q1 = -1000.;
  q2 = -1000.;
  q3 = -1000.;

  // Euler angles (nadir reference frame)
  theta = -1000.;
  phi = -1000.;
  etha = -1000.;

  // Euler angles (local field reference frame)
  //  thetamag = -1000.;
  //  phimag = -1000.;
  //  ethamag = -1000.;

  mode = 0;
  //  std::fill_n(goodAttitude, 5, 0);
}

/**
 * Fills a struct cOrbitalInfo with values from a OrbitalInfo object (to put data into a F77 common).
 */
void OrbitalInfo::GetLevel2Struct(cOrbitalInfo *l2) const{
  l2->abstime  = absTime;
  l2->obt      = OBT;
  l2->pkt_num  = pkt_num;

  l2->lon = lon;
  l2->lat = lat;
  l2->alt = alt;

  l2->Bnorth = Bnorth;
  l2->Beast = Beast;
  l2->Bdown = Bdown;
  l2->Babs = Babs;
  l2->BB0 = BB0;
  l2->L = L;

  l2->londip = londip;
  l2->latdip = latdip;
  l2->altdip = altdip;

  l2->loncgm = loncgm;
  l2->latcgm = latcgm;
  l2->altcgm = altcgm;

  l2->loncbm = loncbm;
  l2->latcbm = latcbm;
  l2->altcbm = altcbm;

  memcpy(l2->cutoff, cutoff, sizeof(cutoff));

  // Quaternions
  l2->q0 = q0;
  l2->q1 = q1;
  l2->q2 = q2;
  l2->q3 = q3;

  // Euler angles (nadir reference frame)
  l2->theta = theta;
  l2->phi = phi;
  l2->etha = etha;

  l2->mode = mode;
  // Euler angles (local field reference frame)
//   l2->thetamag = thetamag;
//   l2->phimag = phimag;
//   l2->ethamag = ethamag;

//   memcpy(l2->goodAttitude, goodAttitude, sizeof(goodAttitude));
}

void OrbitalInfo::SetFromLevel2Struct(cOrbitalInfo *l2){
  absTime  = l2->abstime;
  OBT      = l2->obt;
  pkt_num  = l2->pkt_num;

  lon = l2->lon;
  lat = l2->lat;
  alt = l2->alt;

  l2->Bnorth = Bnorth;
  l2->Beast = Beast;
  l2->Bdown = Bdown;
  l2->Babs = Babs;
  BB0 = l2->BB0;
  L = l2->L;

  londip = l2->londip;
  latdip = l2->latdip;
  altdip = l2->altdip;

  loncgm = l2->loncgm;
  latcgm = l2->latcgm;
  altcgm = l2->altcgm;

  loncbm = l2->loncbm;
  latcbm = l2->latcbm;
  altcbm = l2->altcbm;

  memcpy(cutoff, l2->cutoff, sizeof(l2->cutoff));

  // Quaternions
  q0 = l2->q0;
  q1 = l2->q1;
  q2 = l2->q2;
  q3 = l2->q3;

  // Euler angles (nadir reference frame)
  theta = l2->theta;
  phi = l2->phi;
  etha = l2->etha;

  mode = l2->mode;
  // Euler angles (local field reference frame)
//   thetamag = l2->thetamag;
//   phimag = l2->phimag;
//   ethamag = l2->ethamag;

//   memcpy(goodAttitude, l2->goodAttitude, sizeof(l2->goodAttitude));
}

ClassImp(OrbitalInfo)
