// C/C++ headers
//
#include <fstream>
#include <string.h>
#include <iostream>
#include <cstring>
#include <stdio.h>
//
// ROOT headers
//
//#include <TCanvas.h>
#include <TH2F.h> //for test only. Vitaly.
#include <TVector3.h>
//#include <TF1.h>

#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TArrayI.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
//
// RunInfo header
//
#include <RunInfo.h>
#include <GLTables.h>
//
// YODA headers
//
#include <PamelaRun.h>
#include <PscuHeader.h>
#include <PscuEvent.h>
#include <EventHeader.h>
#include <mcmd/McmdEvent.h>
#include <mcmd/McmdRecord.h>
//
// This program headers
//
#include <OrbitalInfo.h>
#include <OrbitalInfoVerl2.h>
#include <OrbitalInfoCore.h>
#include <InclinationInfo.h>

//
// Tracker and ToF classes headers and definitions
//
#include <ToFLevel2.h>
#include <TrkLevel2.h>
#include <ExtTrack.h> // new tracking code 

using namespace std;

//
// CORE ROUTINE
//
//
int OrbitalInfoCore(UInt_t run, TFile *file, GL_TABLES *glt, Int_t OrbitalInfoargc, char *OrbitalInfoargv[]){
  //
  Int_t i = 0;
  TString host = glt->CGetHost();
  TString user = glt->CGetUser();
  TString psw = glt->CGetPsw();
  TSQLServer *dbc = TSQLServer::Connect(host.Data(),user.Data(),psw.Data());
  //
  stringstream myquery;
  myquery.str("");
  myquery << "SET time_zone='+0:00';";
  delete dbc->Query(myquery.str().c_str());
  delete dbc->Query("SET sql_mode = 'NO_UNSIGNED_SUBTRACTION';");
  //
  TString processFolder = Form("OrbitalInfoFolder_%u",run);
  //
  // Set these to true to have a very verbose output.
  //
  Bool_t debug = false;
  //
  Bool_t verbose = false;
  //
  Bool_t standalone = false;
  //
  if ( OrbitalInfoargc > 0 ){
    i = 0;
    while ( i < OrbitalInfoargc ){
      if ( !strcmp(OrbitalInfoargv[i],"-processFolder") ) {
	if ( OrbitalInfoargc < i+1 ){
	  throw -3;
	};
	processFolder = (TString)OrbitalInfoargv[i+1];
	i++;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--debug")) || (!strcmp(OrbitalInfoargv[i],"-g")) ) {
	verbose = true;
	debug = true;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--verbose")) || (!strcmp(OrbitalInfoargv[i],"-v")) ) {
	verbose = true;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--standalone")) ) {
	standalone = true;
      };
      if ( (!strcmp(OrbitalInfoargv[i],"--calculate-pitch")) ) {
	standalone = false;
      };
      i++;
    };
  };
  //
  const char* outDir = gSystem->DirName(gSystem->DirName(file->GetPath()));
  //
  TTree *OrbitalInfotr = 0;
  UInt_t nevents = 0;
  UInt_t neventsm = 0;
  //
  // variables needed to reprocess data
  //
  Long64_t maxsize = 10000000000LL;  
  TTree::SetMaxTreeSize(maxsize);
  //
  TString OrbitalInfoversion;
  ItoRunInfo *runinfo = 0;
  TArrayI *runlist = 0;
  TTree *OrbitalInfotrclone = 0;
  Bool_t reproc = false;
  Bool_t reprocall = false;
  Bool_t igrfloaded = false;
  UInt_t nobefrun = 0;
  UInt_t noaftrun = 0;
  UInt_t numbofrun = 0;
  stringstream ftmpname;
  TString fname;
  UInt_t totfileentries = 0;
  UInt_t idRun = 0;
  UInt_t anni5 = 60 * 60 * 24 * 365 * 5 ;//1576800
  //
  // My variables. Vitaly.
  //
//  UInt_t oi = 0;
  Int_t tmpSize = 0; 
  //
  // variables needed to handle error signals
  //
  Int_t code = 0;
  Int_t sgnl;
  //
  // OrbitalInfo  classes
  //
  OrbitalInfo *orbitalinfo = new OrbitalInfo();
  OrbitalInfo *orbitalinfoclone = new OrbitalInfo();

  //
  // define variables for opening and reading level0 file
  //
  TFile *l0File = 0;
  TTree *l0tr = 0;
  //  TTree *l0trm = 0;
  TChain *ch = 0;
  // EM: open also header branch
  TBranch *l0head = 0;
  pamela::EventHeader *eh = 0;
  pamela::PscuHeader *ph = 0;
  pamela::McmdEvent *mcmdev = 0;
  pamela::McmdRecord *mcmdrc = 0;
  // end EM
  
  //  pamela::RunHeaderEvent *reh = new pamela::RunHeaderEvent;
  //  pamela::EventHeader    *eH  = new pamela::EventHeader;
  
  //
  // Define other basic variables
  // 
  UInt_t procev = 0;
  stringstream file2;
  stringstream file3;
  stringstream qy;
  Int_t totevent = 0;
  UInt_t atime = 0;
  UInt_t re = 0;
  UInt_t ik = 0;

  // Position
  Float_t lon, lat, alt;

  //
  // IGRF stuff
  //
  Double_t dimo = 0.0; // dipole moment (computed from dat files) // EM GCC 4.7
  Float_t bnorth, beast, bdown, babs;
  Float_t xl; // L value
  Float_t icode; // code value for L accuracy (see fortran code)
  Float_t bab1; // What's  the difference with babs?
  Float_t stps = 0.005; // step size for field line tracing
  Float_t bdel = 0.01; // required accuracy
  Float_t bequ;  // equatorial b value (also called b_0)
  Bool_t value = 0; // false if bequ is not the minimum b value
  Float_t rr0; // equatorial radius normalized to earth radius

  //
  // Working filename
  //
  TString outputfile;
  stringstream name;
  name.str("");
  name << outDir << "/";
  //
  // temporary file and folder
  //
  TFile *tempfile = 0;
  TTree *tempOrbitalInfo = 0;
  stringstream tempname;
  stringstream OrbitalInfofolder;
  Bool_t myfold = false;
  tempname.str("");
  tempname << outDir;
  tempname << "/" << processFolder.Data();
  OrbitalInfofolder.str("");
  OrbitalInfofolder << tempname.str().c_str();
  tempname << "/OrbitalInfotree_run";
  tempname << run << ".root";  
  UInt_t totnorun = 0;
  //
  // DB classes
  //
  GL_ROOT *glroot = new GL_ROOT();
  GL_TIMESYNC *dbtime = 0;
  GL_TLE *gltle = new GL_TLE();
  //
  //Quaternions classes
  //
  Quaternions *L_QQ_Q_l_lower = 0;
  InclinationInfo *RYPang_lower = 0;
  Quaternions *L_QQ_Q_l_upper = 0;
  InclinationInfo *RYPang_upper = 0;
  
  cEci eCi;
  
  // Initialize fortran routines!!!
  Int_t ltp1 = 0;
  Int_t ltp2 = 0;
  Int_t ltp3 = 0;
  //  Int_t uno = 1;
  //  const char *niente = " ";
  GL_PARAM *glparam0 = new GL_PARAM();
  GL_PARAM *glparam = new GL_PARAM();
  GL_PARAM *glparam2 = new GL_PARAM();
  GL_PARAM *glparam3 = new GL_PARAM();

  //
  // Orientation variables. Vitaly
  //

  UInt_t evfrom = 0;
  UInt_t jumped = 0;
  Int_t itr = -1;    
  //  Double_t A1; 
  //  Double_t A2; 
  //  Double_t A3;
  Double_t Px = 0;
  Double_t Py = 0;	
  Double_t Pz = 0;  
  TTree *ttof = 0;
  ToFLevel2 *tof = new ToFLevel2();
  TTree *ttrke = 0;
  TrkLevel2 *trke = new TrkLevel2();
  OrientationInfo *PO = new OrientationInfo();
  Int_t nz = 6; 
  Float_t zin[6];
  Int_t nevtofl2 = 0;
  Int_t nevtrkl2 = 0;
  if ( verbose ) cout<<"Reading quaternions external file"<<endl;
  cout.setf(ios::fixed,ios::floatfield);  
  /******Reading recovered quaternions...*********/
  vector<Double_t> recqtime;
  vector<Float_t> recq0;
  vector<Float_t> recq1;
  vector<Float_t> recq2;
  vector<Float_t> recq3;
  Float_t Norm = 1;

  vector<UInt_t> RTtime1;
  vector<UInt_t> RTtime2;
  vector<Double_t> RTbank1;
  vector<Double_t> RTbank2;
  vector<Double_t> RTbpluto1;
  vector<Double_t> RTbpluto2;
  vector<Int_t> RTazim;
  vector<UInt_t> RTstart;
  vector<UInt_t> RTpluto2;
  vector<UInt_t> RTpluto1;
  vector<Int_t> RTerrq;

  TClonesArray *tcNucleiTrk = NULL;
  TClonesArray *tcExtNucleiTrk = NULL;
  TClonesArray *tcExtTrk = NULL;
  TClonesArray *tcNucleiTof = NULL;
  TClonesArray *tcExtNucleiTof = NULL;
  TClonesArray *tcExtTof = NULL;
  TClonesArray *torbNucleiTrk = NULL;
  TClonesArray *torbExtNucleiTrk = NULL;
  TClonesArray *torbExtTrk = NULL;
  Bool_t hasNucleiTrk = false;
  Bool_t hasExtNucleiTrk = false;
  Bool_t hasExtTrk = false;
  Bool_t hasNucleiTof = false;
  Bool_t hasExtNucleiTof = false;
  Bool_t hasExtTof = false;

  ifstream in;
  ifstream an;
  //  ofstream mc;
  //  TString gr;
  Int_t parerror2=0;

  Int_t parerror=glparam0->Query_GL_PARAM(1,303,dbc); // parameters stored in DB in GL_PRAM table
  if ( verbose ) cout<<parerror<<"\t"<<(char*)(glparam0->PATH+glparam0->NAME).Data()<<endl;
  if ( parerror<0 ) {
    code = parerror;
    goto closeandexit;
  }
  in.open((char*)(glparam0->PATH+glparam0->NAME).Data(),ios::in);
  while(!in.eof()){
    recqtime.resize(recqtime.size()+1);
    Int_t sizee = recqtime.size();
    recq0.resize(sizee);
    recq1.resize(sizee);
    recq2.resize(sizee);
    recq3.resize(sizee);
    in>>recqtime[sizee-1];
    in>>recq0[sizee-1];
    in>>recq1[sizee-1];
    in>>recq2[sizee-1];
    in>>recq3[sizee-1];
    in>>Norm;
  }
  in.close();
  if ( verbose ) cout<<"We have read recovered data"<<endl;
  if (debug) cout << "size of recovered quaterions data set is " << recqtime.size() << endl;

  if ( verbose ) cout<<"read Rotation Table"<<endl;
  
  parerror2=glparam0->Query_GL_PARAM(1,305,dbc);

  if ( verbose ) cout<<parerror2<<"\t"<<(char*)(glparam0->PATH+glparam0->NAME).Data()<<endl;
  if ( parerror2<0 ) {
    code = parerror;
    goto closeandexit;
  }
  an.open((char*)(glparam0->PATH+glparam0->NAME).Data(),ios::in);
  while(!an.eof()){
    RTtime1.resize(RTtime1.size()+1);
    Int_t sizee = RTtime1.size();
    RTbank1.resize(sizee+1);
    RTazim.resize(sizee+1);
    RTerrq.resize(sizee+1);
    RTstart.resize(sizee+1);
    RTpluto1.resize(sizee+1);
    RTbpluto1.resize(sizee+1);
    an>>RTtime1[sizee-1];
    an>>RTbank1[sizee-1];
    an>>RTstart[sizee-1];
    an>>RTpluto1[sizee-1];
    an>>RTbpluto1[sizee-1];
    an>>RTazim[sizee-1];
    an>>RTerrq[sizee-1];
    if(sizee>1) {
      RTtime2.resize(sizee+1);
      RTbank2.resize(sizee+1);
      RTpluto2.resize(sizee+1);
      RTbpluto2.resize(sizee+1);
      RTtime2[sizee-2]=RTtime1[sizee-1];
      RTpluto2[sizee-2]=RTpluto1[sizee-1];
      RTbank2[sizee-2]=RTbank1[sizee-1];
      RTbpluto2[sizee-2]=RTbpluto1[sizee-1];
    }
  }
  an.close();
  //cout<<"put some number here"<<endl;
  //Int_t yupi;
  //cin>>yupi;
  
  if ( verbose ) cout<<"We have read Rotation Table"<<endl;
    //Geomagnetic coordinates calculations staff

  GMtype_CoordGeodetic location;
  //  GMtype_CoordDipole GMlocation;
  GMtype_Ellipsoid Ellip;
  GMtype_Data G0, G1, H1;
	
  //  {	// this braces is necessary to avoid jump to label 'closeandexit'  error   // but it is wrong since the variable "igpath" will not exist outside. To overcome the "jump to label 'closeandexit'  error" it is necessary to set the "igpath" before line 276
  //    TString igpath="/data03/Malakhov/pam9Malakhov/installed10/calib/orb-param/";
  //  }

  //  GM_ScanIGRF(glparam->PATH, &G0, &G1, &H1);
  GM_ScanIGRF(dbc, &G0, &G1, &H1);

  //cout << G0.element[0] << "\t" << G1.element[0] << "\t" << H1.element[0] << endl;
  //cout << G0.element[5] << "\t" << G1.element[5] << "\t" << H1.element[5] << endl;

  GM_SetEllipsoid(&Ellip);

  // IGRF stuff moved inside run loop!  

  for (Int_t ip=0;ip<nz;ip++){
    zin[ip] = tof->GetZTOF(tof->GetToFPlaneID(ip));
  };
  //
  if ( !standalone ){
    //
    // Does it contain the Tracker and ToF trees?
    //
    ttof = (TTree*)file->Get("ToF");
    if ( !ttof ) {
      if ( verbose ) printf(" OrbitalInfo - ERROR: no tof tree\n");
      code = -900;
      goto closeandexit;
    }
    ttof->SetBranchAddress("ToFLevel2",&tof);  
    nevtofl2 = ttof->GetEntries();

    //
    // Look for extended tracking algorithm
    //
    if ( verbose ) printf("Look for extended and nuclei tracking algorithms in ToF\n"); 
    // Nuclei tracking algorithm
    Int_t checkAlgo = 0;
    tcNucleiTof =  new TClonesArray("ToFTrkVar");
    checkAlgo = ttof->SetBranchAddress("TrackNuclei",&tcNucleiTof);    
    if ( !checkAlgo ){
      if ( verbose ) printf(" Nuclei tracking algorithm ToF branch found! :D \n");
      hasNucleiTof = true;
    } else {
      if ( verbose ) printf(" Nuclei tracking algorithm ToF branch not found :( !\n");
      printf(" ok, this is not a problem (it depends on tracker settings) \n");
      delete tcNucleiTof;
      tcNucleiTof=NULL; // 10RED reprocessing bug   
    }
    // Nuclei tracking algorithm using calorimeter points
    tcExtNucleiTof =  new TClonesArray("ToFTrkVar");
    checkAlgo = ttof->SetBranchAddress("RecoveredTrackNuclei",&tcExtNucleiTof);    
    if ( !checkAlgo ){
      if ( verbose ) printf(" Recovered nuclei tracking algorithm ToF branch found! :D \n");
      hasExtNucleiTof = true;
    } else {
      if ( verbose ) printf(" Recovered nuclei tracking algorithm ToF branch not found :( !\n");
      printf(" ok, this is not a problem (it depends on tracker settings) \n");
      delete tcExtNucleiTof;
      tcExtNucleiTof=NULL; // 10RED reprocessing bug   
    }
    // Tracking algorithm using calorimeter points
    tcExtTof =  new TClonesArray("ToFTrkVar");
    checkAlgo = ttof->SetBranchAddress("RecoveredTrack",&tcExtTof);
    if ( !checkAlgo ){
      if ( verbose ) printf(" Recovered track algorithm ToF branch found! :D \n");
      hasExtTof = true;
    } else {
      if ( verbose ) printf(" Recovered track algorithm ToF branch not found :( !\n");
      printf(" ok, this is not a problem (it depends on tracker settings) \n");
      delete tcExtTof;
      tcExtTof=NULL; // 10RED reprocessing bug   
    }

    ttrke = (TTree*)file->Get("Tracker");
    if ( !ttrke ) {
      if ( verbose ) printf(" OrbitalInfo - ERROR: no trk tree\n");
      code = -903;
      goto closeandexit;
    }
    ttrke->SetBranchAddress("TrkLevel2",&trke);  
    nevtrkl2 = ttrke->GetEntries();

    //
    // Look for extended tracking algorithm
    //
    if ( verbose ) printf("Look for extended and nuclei tracking algorithms\n"); 
    // Nuclei tracking algorithm
    checkAlgo = 0;
    tcNucleiTrk =  new TClonesArray("TrkTrack");
    checkAlgo = ttrke->SetBranchAddress("TrackNuclei",&tcNucleiTrk);    
    if ( !checkAlgo ){
      if ( verbose ) printf(" Nuclei tracking algorithm branch found! :D \n");
      hasNucleiTrk = true;
    } else {
      if ( verbose ) printf(" Nuclei tracking algorithm branch not found :( !\n");
      printf(" ok, this is not a problem (it depends on tracker settings) \n");
      delete tcNucleiTrk;
      tcNucleiTrk=NULL; // 10RED reprocessing bug   
    }
    // Nuclei tracking algorithm using calorimeter points
    tcExtNucleiTrk =  new TClonesArray("ExtTrack");
    checkAlgo = ttrke->SetBranchAddress("RecoveredTrackNuclei",&tcExtNucleiTrk);    
    if ( !checkAlgo ){
      if ( verbose ) printf(" Recovered nuclei tracking algorithm branch found! :D \n");
      hasExtNucleiTrk = true;
    } else {
      if ( verbose ) printf(" Recovered nuclei tracking algorithm branch not found :( !\n");
      printf(" ok, this is not a problem (it depends on tracker settings) \n");
      delete tcExtNucleiTrk;
      tcExtNucleiTrk=NULL; // 10RED reprocessing bug   
    }
    // Tracking algorithm using calorimeter points
    tcExtTrk =  new TClonesArray("ExtTrack");
    checkAlgo = ttrke->SetBranchAddress("RecoveredTrack",&tcExtTrk);
    if ( !checkAlgo ){
      if ( verbose ) printf(" Recovered track algorithm branch found! :D \n");
      hasExtTrk = true;
    } else {
      if ( verbose ) printf(" Recovered track algorithm branch not found :( !\n");
      printf(" ok, this is not a problem (it depends on tracker settings) \n");
      delete tcExtTrk;
      tcExtTrk=NULL; // 10RED reprocessing bug   
    }

    if ( (hasNucleiTrk && !hasNucleiTof) || (!hasNucleiTrk && hasNucleiTof) ||
         (hasExtNucleiTrk && !hasExtNucleiTof) || (!hasExtNucleiTrk && hasExtNucleiTof) ||
         (hasExtTrk && !hasExtTof) || (!hasExtTrk && hasExtTof) 
         ){
      if ( verbose ) printf(" ERROR: Mismatch between tracker and tof tree branches concerning extended tracking algorithm(s)\n");
      if ( debug ) printf("hasNucleiTrk %i hasExtNucleiTrk %i hasExtTrk %i \n",hasNucleiTrk,hasExtNucleiTrk,hasExtTrk);
      if ( debug ) printf("hasNucleiTof %i hasExtNucleiTof %i hasExtTof %i \n",hasNucleiTof,hasExtNucleiTof,hasExtTof);
      throw -901;
    }

  }
  //
  // Let's start!
  //
  // As a first thing we must check what we have to do: if run = 0 we must process all events in the file has been passed
  // if run != 0 we must process only that run but first we have to check if the tree MyDetector2 already exist in the file
  // if it exists we are reprocessing data and we must delete that entries, if not we must create it.
  // 
  if ( run == 0 )  reproc = true;
  //
  //
  // Output file is "outputfile"
  //
  if ( !file->IsOpen() ){
    //printf(" OrbitalInfo - ERROR: cannot open file for writing\n");
    throw -901;    
  };
  //
  // Retrieve GL_RUN variables from the level2 file
  //  
  OrbitalInfoversion = OrbitalInfoInfo(false); // we should decide how to handle versioning system
  //
  // create an interface to RunInfo called "runinfo"
  //
  runinfo = new ItoRunInfo(file);
  //
  // open "Run" tree in level2 file, if not existing return an error (sngl != 0)
  //
  sgnl = 0;
  sgnl = runinfo->Update(run, "ORB", OrbitalInfoversion);
  //sgnl = runinfo->Read(run);

  if ( sgnl ){
    //printf("OrbitalInfo - ERROR: RunInfo exited with non-zero status\n");
    code = sgnl;
    goto closeandexit;
  } else {
    sgnl = 0;
  };
  //
  // number of events in the file BEFORE the first event of our run
  //
  nobefrun = runinfo->GetFirstEntry();
  //
  // total number of events in the file 
  //
  totfileentries = runinfo->GetFileEntries();
  //
  // first file entry AFTER the last event of our run
  //
  noaftrun = runinfo->GetLastEntry() + 1;
  //
  // number of run to be processed
  //
  numbofrun = runinfo->GetNoRun();
  totnorun = runinfo->GetRunEntries();
  //
  // Try to access the OrbitalInfo tree in the file, if it exists we are reprocessing data if not we are processing a new run
  //
  OrbitalInfotrclone = (TTree*)file->Get("OrbitalInfo");
  //
  if ( !OrbitalInfotrclone ){
    //
    // tree does not exist, we are not reprocessing
    //
    reproc = false;
    if ( run == 0 ){
      if (verbose) printf(" OrbitalInfo - WARNING: you are reprocessing data but OrbitalInfo tree does not exist!\n");
    }
    if ( runinfo->IsReprocessing() && run != 0 ) {
      if (verbose) printf(" OrbitalInfo - WARNING: it seems you are not reprocessing data but OrbitalInfo\n versioning information already exists in RunInfo.\n");
    }
  } else {
    //
    // tree exists, we are reprocessing data. Are we reprocessing a single run or all the file?
    //
    OrbitalInfotrclone->SetAutoSave(900000000000000LL);
    reproc = true;
    //
    //
    if (verbose) printf("\n Preparing the pre-processing...\n");
    //
    if ( run == 0 || totnorun == 1 ){
      //
      // we are reprocessing all the file
      // if we are reprocessing everything we don't need to copy any old event and we can just work with the new tree and delete the old one immediately
      //
      reprocall = true;
      //
      if (verbose) printf("\n OrbitalInfo - WARNING: Reprocessing all runs\n Deleting old tree...\n");
      //
    } else {
      //
      // we are reprocessing a single run, we must copy to the new tree the events in the file which preceed the first event of the run
      //
      reprocall = false;
      //
      if (verbose) printf("\n OrbitalInfo - WARNING: Reprocessing run number %u \n",run);
      //
      // copying old tree to a new file
      //
      gSystem->MakeDirectory(OrbitalInfofolder.str().c_str());
      myfold = true;
      tempfile = new TFile(tempname.str().c_str(),"RECREATE");
      tempOrbitalInfo = OrbitalInfotrclone->CloneTree(-1,"fast");
      tempOrbitalInfo->SetName("OrbitalInfo-old");
      tempfile->Write();
      tempOrbitalInfo->Delete();
      tempfile->Close();  
    }
    //
    // Delete the old tree from old file and memory
    //
    OrbitalInfotrclone->Clear();
    OrbitalInfotrclone->Delete("all");
    //
    if (verbose) printf(" ...done!\n");
    //
  };
  //
  // create mydetector tree mydect
  // 
  file->cd();
  OrbitalInfotr = new TTree("OrbitalInfo-new","PAMELA OrbitalInfo data");
  OrbitalInfotr->SetAutoSave(900000000000000LL);
  orbitalinfo->Set();//ELENA **TEMPORANEO?**
  OrbitalInfotr->Branch("OrbitalInfo","OrbitalInfo",&orbitalinfo);
  //
  // create new branches for new tracking algorithms
  //
  if ( hasNucleiTrk ){
    torbNucleiTrk = new TClonesArray("OrbitalInfoTrkVar",1);
    OrbitalInfotr->Branch("TrackNuclei",&torbNucleiTrk);
  }
  if ( hasExtNucleiTrk ){
    torbExtNucleiTrk = new TClonesArray("OrbitalInfoTrkVar",1);
    OrbitalInfotr->Branch("RecoveredTrackNuclei",&torbExtNucleiTrk);
  }
  if ( hasExtTrk ){
    torbExtTrk = new TClonesArray("OrbitalInfoTrkVar",1);
    OrbitalInfotr->Branch("RecoveredTrack",&torbExtTrk);
  }

  //
  if ( reproc && !reprocall ){
    //
    //  open new file and retrieve also tree informations
    //
    tempfile = new TFile(tempname.str().c_str(),"READ");
    OrbitalInfotrclone = (TTree*)tempfile->Get("OrbitalInfo-old");
    OrbitalInfotrclone->SetAutoSave(900000000000000LL);
    OrbitalInfotrclone->SetBranchAddress("OrbitalInfo",&orbitalinfoclone);
    //      
    if ( nobefrun > 0 ){
      if (verbose){
	printf("\n Pre-processing: copying events from the old tree before the processed run\n");   
	printf(" Copying %u events in the file which are before the beginning of the run %u \n",nobefrun,run);
	printf(" Start copying at event number 0, end copying at event number %u \n",nobefrun);
      }
      for (UInt_t j = 0; j < nobefrun; j++){
	//
	if ( OrbitalInfotrclone->GetEntry(j) <= 0 ) throw -36;	  
	//
	// copy orbitalinfoclone to mydec
	//
        //	orbitalinfo->Clear();
	//
	memcpy(&orbitalinfo,&orbitalinfoclone,sizeof(orbitalinfoclone));
	//
	// Fill entry in the new tree
	//
	OrbitalInfotr->Fill();
	//
      };
      if (verbose) printf(" Finished successful copying!\n");
    }; 
  };
  //
  //
  // Get the list of run to be processed, if only one run has to be processed the list will contain one entry only.
  //
  runlist = runinfo->GetRunList();
  //
  // Loop over the run to be processed
  //
  for (UInt_t irun=0; irun < numbofrun; irun++){

    L_QQ_Q_l_lower = new Quaternions();
    RYPang_lower = new InclinationInfo();
    L_QQ_Q_l_upper = new Quaternions();
    RYPang_upper = new InclinationInfo();

    //
    // retrieve the first run ID to be processed using the RunInfo list
    //
    
    idRun = runlist->At(irun);
    if (verbose){
      printf("\n\n\n ####################################################################### \n");
      printf("                    PROCESSING RUN NUMBER %i \n",(int)idRun);
      printf(" ####################################################################### \n\n\n");
    }
    //
    runinfo->ID_ROOT_L0 = 0;
    //
    // store in the runinfo class the GL_RUN variables for our run
    //
    sgnl = 0;
    sgnl = runinfo->GetRunInfo(idRun);
    if ( sgnl ){
      if ( debug ) printf("\n OrbitalInfo - ERROR: RunInfo exited with non-zero status\n");
      code = sgnl;
      goto closeandexit;
    } else {
      sgnl = 0;
    };
    //
    // now you can access that variables using the RunInfo class this way runinfo->ID_REG_RUN
    //
    if ( runinfo->ID_ROOT_L0 == 0 ){
      if ( debug ) printf("\n OrbitalInfo - ERROR: no run with ID_RUN = %u \n\n Exiting... \n\n",idRun);
      code = -5;
      goto closeandexit;    
    };
    //
    // prepare the timesync for the db
    //
    dbtime = new GL_TIMESYNC(runinfo->ID_ROOT_L0,"ID",dbc);
   
    //
    // Search in the DB the path and name of the LEVEL0 file to be processed.
    //
    glroot->Query_GL_ROOT(runinfo->ID_ROOT_L0,dbc);
    //
    ftmpname.str("");
    ftmpname << glroot->PATH.Data() << "/";
    ftmpname << glroot->NAME.Data();
    fname = ftmpname.str().c_str();
    ftmpname.str("");
    //
    // print nout informations
    //
    totevent = runinfo->NEVENTS;
    evfrom = runinfo->EV_FROM;
    //cout<<"totevents = "<<totevent<<"\n";
    if (verbose){
      printf("\n LEVEL0 data file: %s \n",fname.Data());
      printf(" RUN HEADER absolute time is:  %u \n",runinfo->RUNHEADER_TIME);
      printf(" RUN TRAILER absolute time is: %u \n",runinfo->RUNTRAILER_TIME);
      printf(" %i events to be processed for run %u: from %i to %i \n\n",totevent,idRun,runinfo->EV_FROM+1,runinfo->EV_FROM+totevent);
    }//
    //
    //    if ( !totevent ) goto closeandexit;
    // Open Level0 file
    if ( l0File ) l0File->Close();
    l0File = new TFile(fname.Data());
    if ( !l0File ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: problems opening Level0 file\n");
      code = -6;
      goto closeandexit;
    };
    l0tr = (TTree*)l0File->Get("Physics");
    if ( !l0tr ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: no Physics tree in Level0 file\n");
      l0File->Close();
      code = -7;
      goto closeandexit;
    };
    // EM: open header branch as well
    l0head = l0tr->GetBranch("Header");
    if ( !l0head ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: no Header branch in Level0 tree\n");
      l0File->Close();
      code = -8;
      goto closeandexit;    
    };
    l0tr->SetBranchAddress("Header", &eh);
    // end EM
    nevents = l0head->GetEntries();
    //
    if ( nevents < 1 && totevent ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: Level0 file is empty\n\n");
      l0File->Close();
      code = -11;
      goto closeandexit;
    };
    // 
    if ( runinfo->EV_TO > nevents-1 && totevent ) {
      if ( debug ) printf(" OrbitalInfo - ERROR: too few entries in the registry tree\n");
      l0File->Close();
      code = -12;
      goto closeandexit;
    };

    //
    // open IGRF files and do it only once if we are processing a full level2 file
    //
    if ( !igrfloaded ){

      if ( l0head->GetEntry(runinfo->EV_FROM) > 0 ){
	igrfloaded = true;
        //
        // absolute time of first event of the run (it should not matter a lot)
        //
        ph = eh->GetPscuHeader();
        atime = dbtime->DBabsTime(ph->GetOrbitalTime());
        
        parerror=glparam->Query_GL_PARAM(atime-anni5,301,dbc); // parameters stored in DB in GL_PRAM table  
        if ( parerror<0 ) {
          code = parerror;
          goto closeandexit;
        }
        ltp1 = (Int_t)(glparam->PATH+glparam->NAME).Length();
        if ( verbose ) printf(" Reading Earth's Magnetic Field parameter file: %s \n",(glparam->PATH+glparam->NAME).Data());
        //
        parerror=glparam2->Query_GL_PARAM(atime,301,dbc); // parameters stored in DB in GL_PRAM table  
        if ( parerror<0 ) {
          code = parerror;
          goto closeandexit;
        }
        ltp2 = (Int_t)(glparam2->PATH+glparam2->NAME).Length();
        if ( verbose ) printf(" Reading Earth's Magnetic Field parameter file: %s \n",(glparam2->PATH+glparam2->NAME).Data());
        //
        parerror=glparam3->Query_GL_PARAM(atime,302,dbc); // parameters stored in DB in GL_PRAM table
        if ( parerror<0 ) {
          code = parerror;
          goto closeandexit;
        }
        ltp3 = (Int_t)(glparam3->PATH+glparam3->NAME).Length();
        if ( verbose ) printf(" Reading Earth's Magnetic Field parameter file: %s \n",(glparam3->PATH+glparam3->NAME).Data());
        //
        initize_((char *)(glparam->PATH+glparam->NAME).Data(),&ltp1,(char *)(glparam2->PATH+glparam2->NAME).Data(),&ltp2,(char *)(glparam3->PATH+glparam3->NAME).Data(),&ltp3); 
        //
        if (debug) cout<<"initize: "<<(char *)(glparam->PATH+glparam->NAME).Data()<<"\t"<<(char *)(glparam2->PATH+glparam2->NAME).Data()<<"\t"<<(char *)(glparam3->PATH+glparam3->NAME).Data()<<endl;
      }
    }
    //
    // End IGRF stuff//
    //

    ULong_t TimeSync = (ULong_t)dbtime->GetTimesync();
    ULong_t ObtSync = (ULong_t)(dbtime->GetObt0()/1000);
    ULong_t DeltaOBT = TimeSync - ObtSync;

    if ( debug ) printf(" 2 TimeSync %lu ObtSync %lu DeltaOBT %lu\n",(ULong_t)(dbtime->GetTimesync()/1000),(ULong_t)dbtime->GetObt0(),TimeSync-ObtSync);
    //
    // Read MCMDs from up to 11 files, 5 before and 5 after the present one in order to have some kind of inclination information
    //
    ch = new TChain("Mcmd","Mcmd");
    //
    // look in the DB to find the closest files to this run
    //
    TSQLResult *pResult = 0;
    TSQLRow *Row = 0;
    stringstream myquery;
    UInt_t l0fid[10];
    Int_t i = 0;
    memset(l0fid,0,10*sizeof(Int_t));
    //
    myquery.str("");
    myquery << "select ID_ROOT_L0 from GL_RUN where RUNHEADER_TIME<=" << runinfo->RUNHEADER_TIME << " group by ID_ROOT_L0 order by RUNHEADER_TIME desc limit 5;";
    //
    pResult = dbc->Query(myquery.str().c_str());
    //
    i = 9;
    if( pResult ){ 
      //
      Row = pResult->Next();
      //
      while ( Row ){
	//
	// store infos and exit
	//
	l0fid[i] = (UInt_t)atoll(Row->GetField(0));
	i--;
	Row = pResult->Next();	
	//
      };
      pResult->Delete();
    };
    //
    myquery.str("");
    myquery << "select ID_ROOT_L0 from GL_RUN where RUNHEADER_TIME>" << runinfo->RUNHEADER_TIME << " group by ID_ROOT_L0 order by RUNHEADER_TIME asc limit 5;";
    //
    pResult = dbc->Query(myquery.str().c_str());
    //
    i = 0;
    if( pResult ){ 
      //
      Row = pResult->Next();
      //
      while ( Row ){
	//
	// store infos and exit
	//
	l0fid[i] = (UInt_t)atoll(Row->GetField(0));
	i++;
	Row = pResult->Next();	
	//
      };
      pResult->Delete();
    };
    //
    i = 0;
    UInt_t previd = 0;
    while ( i < 10 ){
      if ( l0fid[i] && previd != l0fid[i] ){
	previd = l0fid[i];
	myquery.str("");
	myquery << "select PATH,NAME from GL_ROOT where ID=" << l0fid[i] << " ;";
	//
	pResult = dbc->Query(myquery.str().c_str());
	//
	if( pResult ){ 
	  //
	  Row = pResult->Next();
	  //
	  if ( debug ) printf(" Using inclination informations from file: %s \n",(((TString)gSystem->ExpandPathName(Row->GetField(0)))+"/"+(TString)Row->GetField(1)).Data());
	  ch->Add(((TString)gSystem->ExpandPathName(Row->GetField(0)))+"/"+(TString)Row->GetField(1));
	  //
	  pResult->Delete();
	};
      };
      i++;
    };
    //
    ch->SetBranchAddress("Mcmd",&mcmdev);
    neventsm = ch->GetEntries();
    if ( debug ) printf(" entries %u \n", neventsm);
    //
    if (neventsm == 0){
      if ( debug ) printf("InclinationInfo - WARNING: No quaternions in this File");
      code = 900;
    }
    //
    Double_t lowerqtime = 0;    
    //
    // init quaternions information from mcmd-packets
    //
    Bool_t isf = true;

    vector<Float_t> q0;
    vector<Float_t> q1;
    vector<Float_t> q2;
    vector<Float_t> q3;
    vector<Double_t> qtime;
    vector<Float_t> qPitch;
    vector<Float_t> qRoll;
    vector<Float_t> qYaw;
    vector<Int_t> qmode;

    Int_t nt = 0;
    UInt_t must = 0;

    //
    // run over all the events of the run
    //
    if (verbose) printf("\n Ready to start! \n\n Processed events: \n\n");
    //
    //
    for ( re = runinfo->EV_FROM; re < (runinfo->EV_FROM+runinfo->NEVENTS); re++){
      //
      if ( procev%1000 == 0 && procev > 0 && verbose ) printf(" %iK \n",procev/1000);	
      if ( debug ) printf(" %i \n",procev);      
      //
      if ( l0head->GetEntry(re) <= 0 ) throw -36;
      //
      // absolute time of this event
      //
      ph = eh->GetPscuHeader();
      atime = dbtime->DBabsTime(ph->GetOrbitalTime());
      if ( debug ) printf(" %i absolute time \n",procev);      
      //
      // paranoid check
      //
      if ( (atime > (runinfo->RUNTRAILER_TIME+1)) || (atime < (runinfo->RUNHEADER_TIME-1))  ) {
	if (verbose) printf(" OrbitalInfo - WARNING: event at time outside the run time window, skipping it\n");
	jumped++;
	//	debug = true;
	continue;
      }

      //
      // retrieve tof informations
      //
      if ( !reprocall ){
	itr = nobefrun + (re - evfrom - jumped);
	//itr = re-(46438+200241);
      } else {
	itr = runinfo->GetFirstEntry() + (re - evfrom - jumped);
      };
      //
      if ( !standalone ){
	if ( itr > nevtofl2 ){  
	  if ( verbose ) printf(" OrbitalInfo - ERROR: no tof events with entry = %i in Level2 file\n",itr);
	  if ( debug ) printf(" nobefrun %u re %u evfrom %u jumped %u reprocall %i \n",nobefrun,re,evfrom,jumped,reprocall);
	  l0File->Close();
	  code = -904;
	  goto closeandexit; 
	};
	//
	tof->Clear();
	//
        // Clones array must be cleared before going on
        //
        if ( hasNucleiTof ){
          tcNucleiTof->Delete();
        }
        if ( hasExtNucleiTof ){
          tcExtNucleiTof->Delete();
        }          
        if ( hasExtTof ){
          tcExtTof->Delete();
        }
	//
        if ( verbose ) printf(" get tof tree entries... entry = %i in Level2 file\n",itr);
	if ( ttof->GetEntry(itr) <= 0 ){
          if ( verbose ) printf(" problems with tof tree entries... entry = %i in Level2 file\n",itr);
          if ( verbose ) printf(" nobefrun %u re %u evfrom %u jumped %u reprocall %i \n",nobefrun,re,evfrom,jumped,reprocall);
          throw -36; 
	}
        if ( verbose ) printf(" gat0\n");
	//
      }
      //
      // retrieve tracker informations
      //
      if ( !standalone ){
	if ( itr > nevtrkl2 ){  
	  if ( verbose ) printf(" OrbitalInfo - ERROR: no trk events with entry = %i in Level2 file\n",itr);
	  if ( debug ) printf(" nobefrun %u re %u evfrom %u jumped %u reprocall %i \n",nobefrun,re,evfrom,jumped,reprocall);
	  l0File->Close();
	  code = -905;
	  goto closeandexit; 
	}
	//
        if ( verbose ) printf(" gat1\n");
	trke->Clear();
	//
        // Clones array must be cleared before going on
        //
        if ( hasNucleiTrk ){
          if ( verbose ) printf(" gat2\n");
          tcNucleiTrk->Delete();
          if ( verbose ) printf(" gat3\n");
          torbNucleiTrk->Delete();
        }
        if ( hasExtNucleiTrk ){
          if ( verbose ) printf(" gat4\n");
          tcExtNucleiTrk->Delete();
          if ( verbose ) printf(" gat5\n");
          torbExtNucleiTrk->Delete();
        }          
        if ( hasExtTrk ){
          if ( verbose ) printf(" gat6\n");
          tcExtTrk->Delete();
          if ( verbose ) printf(" gat7\n");
          torbExtTrk->Delete();
        }
	//
        if ( verbose ) printf(" get trk tree entries... entry = %i in Level2 file\n",itr);
	if ( ttrke->GetEntry(itr) <= 0 ) throw -36; 
	//
      }

      //
      procev++;
      //
      // start processing
      //
      if ( debug ) printf(" %i start processing \n",procev);      
      orbitalinfo->Clear();
      //
      OrbitalInfoTrkVar *t_orb = new OrbitalInfoTrkVar();
      if( !(orbitalinfo->OrbitalInfoTrk) ) orbitalinfo->OrbitalInfoTrk = new TClonesArray("OrbitalInfoTrkVar",2); 
      TClonesArray &tor = *orbitalinfo->OrbitalInfoTrk;

      // Geomagnetic coordinates calculation variables
      GMtype_CoordSpherical CoordSpherical, DipoleSpherical;
      GMtype_CoordCartesian CoordCartesian, DipoleCartesian;
      GMtype_Model Model;
      GMtype_Pole Pole;

      //
      // Fill OBT, pkt_num and absTime
      //      
      orbitalinfo->pkt_num = ph->GetCounter();
      orbitalinfo->OBT = ph->GetOrbitalTime();
      orbitalinfo->absTime = atime;
      if ( debug ) printf(" %i pktnum obt abstime \n",procev);      
      //
      // Propagate the orbit from the tle time to atime, using SGP(D)4.
      //
      if ( debug ) printf(" %i sgp4 \n",procev);      
      cCoordGeo coo;
      Float_t jyear=0.;     
      //
      if(atime >= gltle->GetToTime()) {
	if ( !gltle->Query(atime, dbc) ){
	  //	  
	  // Compute the magnetic dipole moment.
	  //
	  if ( debug ) printf(" %i compute magnetic dipole moment \n",procev);      
	  UInt_t year, month, day, hour, min, sec;
	  //
	  TTimeStamp t = TTimeStamp(atime, kTRUE);
	  t.GetDate(kTRUE, 0, &year, &month, &day);
	  t.GetTime(kTRUE, 0, &hour, &min, &sec);
	  jyear = (float) year 
	    + (month*31.+ (float) day)/365. 
	    + (hour*3600.+min*60.+(float)sec)/(24.*3600.*365.);
	  //
	  if ( debug ) printf(" %i compute magnetic dipole moment get dipole moment for year\n",procev);            
	  if ( debug ) printf(" %i jyear %f dimo %f \n",procev,jyear,dimo);
	  feldcof_(&jyear, &dimo); // get dipole moment for year
	  if ( debug ) printf(" %i compute magnetic dipole moment end\n",procev);

	  GM_TimeAdjustCoefs(year, jyear, G0, G1, H1, &Model);
	  GM_PoleLocation(Model, &Pole);
	  
	} else {
	  code = -56;
	  goto closeandexit;
	};
      }
      coo = getCoo(atime, gltle->GetFromTime(), gltle->GetTle());
      //
      cOrbit orbits(*gltle->GetTle());
      //
      // synchronize with quaternions data
      //
      if ( isf && neventsm>0 ){
	//
	// First event
	//
	isf = false;
        //	upperqtime = atime;
	lowerqtime = runinfo->RUNHEADER_TIME;
	for ( ik = 0; ik < neventsm; ik++){  //number of macrocommad packets
	  if ( ch->GetEntry(ik) <= 0 ) throw -36;
	  tmpSize = mcmdev->Records->GetEntries();
          //	  numrec = tmpSize;
          if ( debug ) cout << "packet number " << ik <<"\tnumber of subpackets is " << tmpSize << endl;
	  for (Int_t j3 = 0;j3<tmpSize;j3++){  //number of subpackets
	    mcmdrc = (pamela::McmdRecord*)mcmdev->Records->At(j3);
	    if ( mcmdrc ){ // missing inclination bug [8RED 090116]
	      if ( debug ) printf(" pluto \n");
	      if ((int)mcmdrc->ID1 == 226 && mcmdrc->Mcmd_Block_crc_ok == 1){ //Check that it is Inclination Packet
	       L_QQ_Q_l_upper->fill(mcmdrc->McmdData);
		for (UInt_t ui = 0; ui < 6; ui++){
		  if (ui>0){
		    if (L_QQ_Q_l_upper->time[ui]>L_QQ_Q_l_upper->time[0]){
                      if ( debug ) printf(" here1 %i \n",ui);
		      Double_t u_time = dbtime->DBabsTime((UInt_t)(L_QQ_Q_l_upper->time[ui]*1000-DeltaOBT*1000));
		      Int_t recSize = recqtime.size();
		      if(lowerqtime > recqtime[recSize-1]){
			 // to avoid interpolation between bad quaternions arrays
			 if(sqrt(pow(L_QQ_Q_l_upper->quat[ui][0],2)+pow(L_QQ_Q_l_upper->quat[ui][1],2)+pow(L_QQ_Q_l_upper->quat[ui][2],2)+pow(L_QQ_Q_l_upper->quat[ui][3],2))>0.99999){
			  Int_t sizeqmcmd = qtime.size();
			  inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			  qtime[sizeqmcmd]=u_time;
			  q0[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][0];
			  q1[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][1];
			  q2[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][2];
			  q3[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][3];
			  qmode[sizeqmcmd]=holeq(lowerqtime,qtime[sizeqmcmd],L_QQ_Q_l_lower,L_QQ_Q_l_upper,ui);
			  lowerqtime = u_time;
			  orbits.getPosition((double) (u_time - gltle->GetFromTime())/60., &eCi);
			  RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,L_QQ_Q_l_upper->quat[ui][0],L_QQ_Q_l_upper->quat[ui][1],L_QQ_Q_l_upper->quat[ui][2],L_QQ_Q_l_upper->quat[ui][3]);
			  qRoll[sizeqmcmd]=RYPang_upper->Kren;
			  qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			  qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
			 }
		      }
		      for(Int_t mu = nt;mu<recSize;mu++){
			if(recqtime[mu]>lowerqtime && recqtime[mu]<u_time){
			  if(sqrt(pow(recq0[mu],2)+pow(recq1[mu],2)+pow(recq2[mu],2)+pow(recq3[mu],2))>0.99999){
			    nt=mu;
			    Int_t sizeqmcmd = qtime.size();
			    inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			    qtime[sizeqmcmd]=recqtime[mu];
			    q0[sizeqmcmd]=recq0[mu];
			    q1[sizeqmcmd]=recq1[mu];
			    q2[sizeqmcmd]=recq2[mu];
			    q3[sizeqmcmd]=recq3[mu];
			    qmode[sizeqmcmd]=-10;
			    orbits.getPosition((double) (qtime[sizeqmcmd] - gltle->GetFromTime())/60., &eCi);
			    RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,recq0[mu],recq1[mu],recq2[mu],recq3[mu]);
			    qRoll[sizeqmcmd]=RYPang_upper->Kren;
			    qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			    qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
			  }
			}
			if(recqtime[mu]>=u_time){
			  if(sqrt(pow(L_QQ_Q_l_upper->quat[ui][0],2)+pow(L_QQ_Q_l_upper->quat[ui][1],2)+pow(L_QQ_Q_l_upper->quat[ui][2],2)+pow(L_QQ_Q_l_upper->quat[ui][3],2))>0.99999){
			    Int_t sizeqmcmd = qtime.size();
			    inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			    qtime[sizeqmcmd]=u_time;
			    q0[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][0];
			    q1[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][1];
			    q2[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][2];
			    q3[sizeqmcmd]=L_QQ_Q_l_upper->quat[ui][3];
			    qmode[sizeqmcmd]=holeq(lowerqtime,qtime[sizeqmcmd],L_QQ_Q_l_lower,L_QQ_Q_l_upper,ui);
			    lowerqtime = u_time;
			    orbits.getPosition((double) (u_time - gltle->GetFromTime())/60., &eCi);
			    RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,L_QQ_Q_l_upper->quat[ui][0],L_QQ_Q_l_upper->quat[ui][1],L_QQ_Q_l_upper->quat[ui][2],L_QQ_Q_l_upper->quat[ui][3]);
			    qRoll[sizeqmcmd]=RYPang_upper->Kren;
			    qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			    qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
			    break;
			  }
			}
		      }
		    }
		  }else{
                    if ( debug ) printf(" here2 %i \n",ui);
		    Double_t u_time = dbtime->DBabsTime((UInt_t)(L_QQ_Q_l_upper->time[0]*1000-DeltaOBT*1000));
		    if(lowerqtime>u_time)nt=0;
		    Int_t recSize = recqtime.size();
		    if(lowerqtime > recqtime[recSize-1]){
		      if(sqrt(pow(L_QQ_Q_l_upper->quat[ui][0],2)+pow(L_QQ_Q_l_upper->quat[ui][1],2)+pow(L_QQ_Q_l_upper->quat[ui][2],2)+pow(L_QQ_Q_l_upper->quat[ui][3],2))>0.99999){
			Int_t sizeqmcmd = qtime.size();
			inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			qtime[sizeqmcmd]=u_time;
			q0[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][0];
			q1[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][1];
			q2[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][2];
			q3[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][3];
			qmode[sizeqmcmd]=holeq(lowerqtime,qtime[sizeqmcmd],L_QQ_Q_l_lower,L_QQ_Q_l_upper,ui);
			lowerqtime = u_time;
			orbits.getPosition((double) (u_time - gltle->GetFromTime())/60., &eCi);
			RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,L_QQ_Q_l_upper->quat[0][0],L_QQ_Q_l_upper->quat[0][1],L_QQ_Q_l_upper->quat[0][2],L_QQ_Q_l_upper->quat[0][3]);
			qRoll[sizeqmcmd]=RYPang_upper->Kren;
			qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
		      }
		    }
		    for(Int_t mu = nt;mu<recSize;mu++){
		      if(recqtime[mu]>lowerqtime && recqtime[mu]<u_time){
			 if(sqrt(pow(recq0[mu],2)+pow(recq1[mu],2)+pow(recq2[mu],2)+pow(recq3[mu],2))>0.99999){
			   nt=mu;
			   Int_t sizeqmcmd = qtime.size();
			   inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			   qtime[sizeqmcmd]=recqtime[mu];
			   q0[sizeqmcmd]=recq0[mu];
			   q1[sizeqmcmd]=recq1[mu];
			   q2[sizeqmcmd]=recq2[mu];
			   q3[sizeqmcmd]=recq3[mu];
			   qmode[sizeqmcmd]=-10;
			   orbits.getPosition((double) (qtime[sizeqmcmd] - gltle->GetFromTime())/60., &eCi);
			   RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,recq0[mu],recq1[mu],recq2[mu],recq3[mu]);
			   qRoll[sizeqmcmd]=RYPang_upper->Kren;
			   qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			   qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
			 }
		      }
		      if(recqtime[mu]>=u_time){
			 if(sqrt(pow(L_QQ_Q_l_upper->quat[0][0],2)+pow(L_QQ_Q_l_upper->quat[0][1],2)+pow(L_QQ_Q_l_upper->quat[0][2],2)+pow(L_QQ_Q_l_upper->quat[0][3],2))>0.99999){
			   Int_t sizeqmcmd = qtime.size();
			   inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
			   qtime[sizeqmcmd]=u_time;
			   q0[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][0];
			   q1[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][1];
			   q2[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][2];
			   q3[sizeqmcmd]=L_QQ_Q_l_upper->quat[0][3];
			   qmode[sizeqmcmd]=holeq(lowerqtime,qtime[sizeqmcmd],L_QQ_Q_l_lower,L_QQ_Q_l_upper,ui);
			   lowerqtime = u_time;
			   orbits.getPosition((double) (u_time - gltle->GetFromTime())/60., &eCi);
			   RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,L_QQ_Q_l_upper->quat[0][0],L_QQ_Q_l_upper->quat[0][1],L_QQ_Q_l_upper->quat[0][2],L_QQ_Q_l_upper->quat[0][3]);
			   qRoll[sizeqmcmd]=RYPang_upper->Kren;
			   qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
			   qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
			   CopyQ(L_QQ_Q_l_lower,L_QQ_Q_l_upper);
			   break;
			 }
		      }
		    }
		  }
		}
	      }
	    }
	    //if ( debug ) cout << "subpacket " << j3 << "\t qtime = " << qtime[qtime.size()-1] << endl;
	  }
	}
	
	if(qtime.size()==0){				// in case if no orientation information in data
          if ( debug ) cout << "qtime.size() = 0" << endl;
          for(UInt_t my=0;my<recqtime.size();my++){
            if(sqrt(pow(recq0[my],2)+pow(recq1[my],2)+pow(recq2[my],2)+pow(recq3[my],2))>0.99999){
              Int_t sizeqmcmd = qtime.size();
              inclresize(qtime,q0,q1,q2,q3,qmode,qRoll,qPitch,qYaw);
              qtime[sizeqmcmd]=recqtime[my];
              q0[sizeqmcmd]=recq0[my];
              q1[sizeqmcmd]=recq1[my];
              q2[sizeqmcmd]=recq2[my];
              q3[sizeqmcmd]=recq3[my];
              qmode[sizeqmcmd]=-10;
              orbits.getPosition((double) (qtime[sizeqmcmd] - gltle->GetFromTime())/60., &eCi);
              RYPang_upper->TransAngle(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,recq0[my],recq1[my],recq2[my],recq3[my]);
              qRoll[sizeqmcmd]=RYPang_upper->Kren;
              qYaw[sizeqmcmd]=RYPang_upper->Ryskanie;
              qPitch[sizeqmcmd]=RYPang_upper->Tangazh;
            }
          }
	}
	

	if ( debug ) printf(" puffi \n");
	Double_t tmin = 9999999999.;
	Double_t tmax = 0.;
	for(UInt_t tre = 0;tre<qtime.size();tre++){
	  if(qtime[tre]>tmax)tmax = qtime[tre];
	  if(qtime[tre]<tmin)tmin = qtime[tre];
	}
	// sorting quaternions by time
       Bool_t t = true;
	while(t){
         t=false;
	  for(UInt_t i=0;i<qtime.size()-1;i++){
	    if(qtime[i]>qtime[i+1]){
	      Double_t tmpr = qtime[i];
	      qtime[i]=qtime[i+1];
	      qtime[i+1] = tmpr;
	      tmpr = q0[i];
	      q0[i]=q0[i+1];
	      q0[i+1] = tmpr;
	      tmpr = q1[i];
	      q1[i]=q1[i+1];
	      q1[i+1] = tmpr;
	      tmpr = q2[i];
	      q2[i]=q2[i+1];
	      q2[i+1] = tmpr;
	      tmpr = q3[i];
	      q3[i]=q3[i+1];
	      q3[i+1] = tmpr;
	      tmpr = qRoll[i];
	      qRoll[i]=qRoll[i+1];
	      qRoll[i+1] = tmpr;
	      tmpr = qYaw[i];
	      qYaw[i]=qYaw[i+1];
	      qYaw[i+1] = tmpr;
	      tmpr = qPitch[i];
	      qPitch[i]=qPitch[i+1];
	      qPitch[i+1] = tmpr;
		t=true;
	    }
 	  }
	}

	if ( debug ){
 	  cout << "we have loaded quaternions: size of quaternions set is "<< qtime.size() << endl;
         for(UInt_t i=0;i<qtime.size();i++) cout << qtime[i] << "\t";
	  cout << endl << endl;
	  Int_t lopu;
	  cin >> lopu;
       }

      } // if we processed first event

      
      //Filling Inclination information
      Double_t incli = 0;
      if ( qtime.size() > 1 ){
	if ( debug ) cout << "ok quaternions is exist and mu = " << must << endl;
	if ( debug ) cout << "qtimes[ " << qtime[0] << " , " << qtime[qtime.size()-1] << " ]\tatime = "<<atime<<endl;
        for(UInt_t mu = must;mu<qtime.size()-1;mu++){
          if ( debug ) printf(" ??grfuffi %i sixe %i must %i \n",mu,qtime.size()-1,must);
          if(qtime[mu+1]>qtime[mu]){
            if ( debug ) cout << "qtime[" << mu << "] = " << qtime[mu] << "\tqtime[" << mu+1 << "] = " << qtime[mu+1] << "\tatime = " << atime << endl;
            if(atime<=qtime[mu+1] && atime>=qtime[mu]){
              if ( debug ) cout << "here we have found proper quaternions for interpolation: mu = "<<mu<<endl;
              must = mu;
              incli = (qPitch[mu+1]-qPitch[mu])/(qtime[mu+1]-qtime[mu]);
              orbitalinfo->theta =  incli*atime+qPitch[mu+1]-incli*qtime[mu+1];
              incli = (qRoll[mu+1]-qRoll[mu])/(qtime[mu+1]-qtime[mu]);
              orbitalinfo->etha =  incli*atime+qRoll[mu+1]-incli*qtime[mu+1];
              incli = (qYaw[mu+1]-qYaw[mu])/(qtime[mu+1]-qtime[mu]);
              orbitalinfo->phi =  incli*atime+qYaw[mu+1]-incli*qtime[mu+1];
              
              incli = (q0[mu+1]-q0[mu])/(qtime[mu+1]-qtime[mu]);
              orbitalinfo->q0 =  incli*atime+q0[mu+1]-incli*qtime[mu+1];
              incli = (q1[mu+1]-q1[mu])/(qtime[mu+1]-qtime[mu]);
              orbitalinfo->q1 =  incli*atime+q1[mu+1]-incli*qtime[mu+1];
              incli = (q2[mu+1]-q2[mu])/(qtime[mu+1]-qtime[mu]);
              orbitalinfo->q2 =  incli*atime+q2[mu+1]-incli*qtime[mu+1];
              incli = (q3[mu+1]-q3[mu])/(qtime[mu+1]-qtime[mu]);
              orbitalinfo->q3 =  incli*atime+q3[mu+1]-incli*qtime[mu+1];
              Float_t tg = (qtime[mu+1]-qtime[mu])/1000.0;
              if(tg>=1) tg=0.00;
              orbitalinfo->TimeGap = TMath::Min(TMath::Abs(qtime[mu+1])-atime,TMath::Abs(atime-qtime[mu]))+tg;//qtime[mu+1]-qtime[mu];
              orbitalinfo->mode = qmode[mu+1];
              //if(atime==qtime[mu] || atime==qtime[mu+1]) orbitalinfo->qkind = 0; else orbitalinfo->qkind=1;
              //if(qmode[mu+1]==-10) orbitalinfo->R10r = true;else orbitalinfo->R10r = false;
              if ( debug ) printf(" grfuffi4 %i \n",mu);
              break;
            }
          }
        }
      }
      if ( debug ) printf(" grfuffi5  \n");
      //
      // ops no inclination information
      //
      
      if ( orbitalinfo->q0< -999 || orbitalinfo->q1 < -999 || orbitalinfo->q2 < -999 || orbitalinfo->q3 < -999 || orbitalinfo->q0 != orbitalinfo->q0 || orbitalinfo->q1 != orbitalinfo->q1 || orbitalinfo->q2 != orbitalinfo->q2 || orbitalinfo->q3 != orbitalinfo->q3 ){
	if ( debug ) cout << "ops no iclination information" << endl;
	orbitalinfo->mode = 10;
	orbitalinfo->q0 = -1000.;
	orbitalinfo->q1 = -1000.;
	orbitalinfo->q2 = -1000.;
	orbitalinfo->q3 = -1000.;
	orbitalinfo->etha = -1000.;
	orbitalinfo->phi = -1000.;
	orbitalinfo->theta = -1000.;
	orbitalinfo->TimeGap = -1000.;
	//orbitalinfo->qkind = -1000;
        
        //	if ( debug ){
        //	  Int_t lopu;
        //         cin >> lopu;
        //	}
        if ( debug ) printf(" grfuffi6 \n");
      }
      //
      if ( debug ) printf(" filling \n");
      // #########################################################################################################################   
      //
      // fill orbital positions
      //        
      // Build coordinates in the right range.  We want to convert,
      // longitude from (0, 2*pi) to (-180deg, 180deg).  Altitude is
      // in meters.
      lon = (coo.m_Lon > M_PI) ? rad2deg(coo.m_Lon - 2*M_PI) : rad2deg(coo.m_Lon);
      lat = rad2deg(coo.m_Lat);
      alt = coo.m_Alt;

      cOrbit orbits2(*gltle->GetTle());
      orbits2.getPosition((double) (atime - gltle->GetFromTime())/60., &eCi);
      //      Float_t x=eCi.getPos().m_x;
      //      Float_t y=eCi.getPos().m_y;
      //      Float_t z=eCi.getPos().m_z;
      
      TVector3 V(eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z);
      TVector3 Pos(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z);
      
      Float_t dlon=Pos.Phi()*TMath::RadToDeg()-lon;
      
      Pos.RotateZ(-dlon*TMath::DegToRad());
      V.RotateZ(-dlon*TMath::DegToRad());
      Float_t diro;
      if(V.Z()>0) diro=1; else diro=-1;
      
      // 10REDNEW
      Int_t errq=0;
      Int_t azim=0;
      Int_t MU=0;
      for(UInt_t mu = must;mu<RTtime2.size()-1;mu++){
        if(atime<=RTstart[mu+1] && atime>=RTstart[mu]){
          errq=RTerrq[mu];
          azim=RTazim[mu];
          MU=mu;
          break;
        }
      }
      orbitalinfo->errq = errq;
      orbitalinfo->azim = azim;
      orbitalinfo->qkind = 0;
      
      if ( debug ) printf(" coord done \n");
      if( lon<180 && lon>-180 && lat<90 && lat>-90 && alt>0 ){	
	//      
	orbitalinfo->lon = lon;
	orbitalinfo->lat = lat;
	orbitalinfo->alt = alt;
	orbitalinfo->V = V;

        //	GMtype_CoordGeodetic  location;
	location.lambda = lon;
	location.phi = lat;
	location.HeightAboveEllipsoid = alt;

	GM_GeodeticToSpherical(Ellip, location, &CoordSpherical);
	GM_SphericalToCartesian(CoordSpherical,  &CoordCartesian);
	GM_EarthCartToDipoleCartCD(Pole, CoordCartesian, &DipoleCartesian);
	GM_CartesianToSpherical(DipoleCartesian, &DipoleSpherical);
	orbitalinfo->londip = DipoleSpherical.lambda;
	orbitalinfo->latdip = DipoleSpherical.phig;

	if(debug)cout<<"geodetic:\t"<<lon<<"\t"<<lat<<"\tgeomagnetic:\t"<<orbitalinfo->londip<<"\t"<<orbitalinfo->latdip<<endl;

	//
	// compute mag field components and L shell.
	//
        if ( debug ) printf(" call igrf feldg \n");
	feldg_(&lat, &lon, &alt, &bnorth, &beast, &bdown, &babs);
        if ( debug ) printf(" call igrf shellg \n");
	shellg_(&lat, &lon, &alt, &dimo, &xl, &icode, &bab1);
        if ( debug ) printf(" call igrf findb \n");
	findb0_(&stps, &bdel, &value, &bequ, &rr0);
	//
        if ( debug ) printf(" done igrf \n");
	orbitalinfo->Bnorth = bnorth;
	orbitalinfo->Beast = beast;
	orbitalinfo->Bdown = bdown;
	orbitalinfo->Babs = babs;
	orbitalinfo->M = dimo;
	orbitalinfo->BB0 = babs/bequ;
	orbitalinfo->L = xl;      
	// Set Stormer vertical cutoff using L shell.
	orbitalinfo->cutoffsvl = 14.295 / (xl*xl); //
	if(debug)cout << "L = " << xl << "\tM = " << dimo << "\tvertical cutoff:  "<< orbitalinfo->cutoffsvl << endl;

        /*
          ---------- Forwarded message ----------
          Date: Wed, 09 May 2012 12:16:47 +0200
          From: Alessandro Bruno <alessandro.bruno@ba.infn.it>
          To: Mirko Boezio <mirko.boezio@ts.infn.it>
          Cc: Francesco S. Cafagna <Francesco.Cafagna@ba.infn.it>
          Subject: Strmer vertical cutoff

          Ciao Mirko,
          volevo segnalarti che il valore dello Strmer vertical cutoff nel Level2 
          sovrastimato di circa il 4%.
          Dopo un'approfondita analisi con l'IGRF-05 abbiamo ricavano un valore pari
          a: 14.295 / L^2 anzich 14.9 / L^2, valore obsoleto in quanto riferito agli
          anni '50.
        */
        //14.9/(xl*xl);
	orbitalinfo->igrf_icode = icode;
	//
      }      
      //
      if ( debug ) printf(" pitch angle \n");
      //
      // pitch angles
      //
      if( orbitalinfo->TimeGap>0){
	//
        if ( debug ) printf(" timegap %f \n",orbitalinfo->TimeGap);
	Float_t Bx = -orbitalinfo->Bdown;
	Float_t By = orbitalinfo->Beast;
	Float_t Bz = orbitalinfo->Bnorth;

	TMatrixD Qiji(3,3);
	TMatrixD Qij = PO->QuatoECI(orbitalinfo->q0,orbitalinfo->q1,orbitalinfo->q2,orbitalinfo->q3);
	TMatrixD Dij = PO->ECItoGEO(Qij,orbitalinfo->absTime,orbitalinfo->lat,orbitalinfo->lon);

//10REDNEW
	/* If initial orientation data have reason to be inaccurate */
	Float_t tg = 0.00;
       Float_t tmptg;
       if(MU!=0){
//	if(orbitalinfo->TimeGap>0 && errq==0 && azim==0){		// 10RED CHECK  (comparison between three metod of recovering orientation)
       if((atime>=RTstart[MU] && atime<RTstart[MU+1] && RTbank1[MU]==0 && RTbank2[MU]==0 && TMath::Abs(orbitalinfo->etha)>0.01) || ((RTbank1[MU]!=0 || RTbank2[MU]!=0) && atime>=RTstart[MU] && atime<RTstart[MU+1] && azim==0 && (errq!=0 || orbitalinfo->TimeGap>10.0 || ((modf(orbitalinfo->TimeGap,&tmptg)*1000>10 || modf(orbitalinfo->TimeGap,&tmptg)*1000==0.0) && orbitalinfo->TimeGap>2.0)))){
	/*  found in Rotation Table this data for this time interval*/
	if(atime<RTtime1[0])
	  orbitalinfo->azim = 5;	//means that RotationTable no started yet
       else{
		// search for angle betwean velosity and direction to north in tangential to Earth surfase plane in satellite position
	      Double_t bank=RTstart[MU];
	      Double_t tlat=orbitalinfo->lat;

	      tg=modf(orbitalinfo->TimeGap,&tg)*1000;

	      if(atime>=RTpluto1[MU] && atime<=RTpluto2[MU]){
	        Double_t kar=(RTbank2[MU]-RTbank1[MU])/(RTtime2[MU]-RTtime1[MU]);
	        Double_t bak=RTbank1[MU]-kar*RTtime1[MU];
	        bank=kar*atime+bak;
	      }
	      if(atime>=RTstart[MU] && atime<RTpluto1[MU]){
		 Double_t s_dBdt2=(RTbpluto1[MU]-RTbank1[MU])/(RTpluto1[MU]-RTstart[MU]);
		 Double_t s_t2=((Double_t)RTpluto1[MU]+(Double_t)RTstart[MU])/2. - RTstart[MU];
		 Double_t s_t1=RTstart[MU]-RTstart[MU];
		 Double_t s_k=s_dBdt2/(s_t2-s_t1);
		 Double_t s_b=-s_k*s_t1;
		 Double_t s_t3=RTpluto1[MU]-RTstart[MU];
		 Double_t s_b3=RTbpluto1[MU];
		 Double_t s_c=s_b3-0.5*s_k*s_t3*s_t3 -s_b*s_t3;
		 bank=0.5*s_k*(atime-RTstart[MU])*(atime-RTstart[MU]) + s_b*(atime-RTstart[MU]) + s_c;
             }
	      if(atime>RTpluto2[MU] && atime<=RTstart[MU+1]){
		 Double_t s_dBdt2=(RTbpluto2[MU] - RTbank2[MU])/(RTpluto2[MU]-RTstart[MU+1]);
		 Double_t s_t2=((Double_t)RTpluto2[MU]+(Double_t)RTstart[MU+1])/2. - RTstart[MU];
		 Double_t s_t1=RTstart[MU+1]-RTstart[MU];
		 Double_t s_k=s_dBdt2/(s_t2-s_t1);
		 Double_t s_b=-s_k*s_t1;
		 Double_t s_t3=RTpluto2[MU]-RTstart[MU];
		 Double_t s_b3=RTbpluto2[MU];
		 Double_t s_c=s_b3-0.5*s_k*s_t3*s_t3 -s_b*s_t3;
               bank=0.5*s_k*(atime-RTstart[MU])*(atime-RTstart[MU]) + s_b*(atime-RTstart[MU]) + s_c;
             }
	      orbitalinfo->etha=bank;
	      Double_t spitch = 0.00001;  // temprary not zero to avoid problem with tranzition from Euler angles to orientation matrix

		//Estimations of pitch angle of satellite
	      if(TMath::Abs(bank)>0.7){
		 Float_t spitch1=TMath::DegToRad()*0.7*diro;//RTdir1[MU];
		 Float_t spitch2=TMath::DegToRad()*0.7*diro;//RTdir2[MU];
    		 Float_t kva=(spitch2-spitch1)/(RTtime2[MU]-RTtime1[MU]);
    		 Float_t bva=spitch1-kva*RTtime1[MU];
    		 spitch=kva*atime+bva;
	      }

	      //Calculate Yaw angle accordingly with fit, see picture FitYaw.jpg
	      Double_t yaw=0.00001;  // temprary not zero to avoid problem with tranzition from Euler angles to orientation matrix
	      if(TMath::Abs(tlat)<70)
	        yaw = -3.7e-8*tlat*tlat*tlat*tlat + 1.4e-7*tlat*tlat*tlat - 0.0005*tlat*tlat - 0.00025*tlat + 3.6;
	      yaw = diro*yaw;	//because should be different sign for ascending and descending orbits!
	      orbitalinfo->phi=yaw;

	      if(TMath::Abs(bank)>0.5 && TMath::Abs(yaw-orbitalinfo->phi)<3.0) yaw=orbitalinfo->phi;

//	      Qiji = PO->EulertoEci(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,bank,yaw,spitch);		// 10RED CHECK
	      Qij = PO->EulertoEci(eCi.getPos().m_x,eCi.getPos().m_y,eCi.getPos().m_z,eCi.getVel().m_x,eCi.getVel().m_y,eCi.getVel().m_z,bank,yaw,spitch);		// STANDARD
	      orbitalinfo->qkind = 1;

	  //Qij = PO->GEOtoECI(Dij,orbitalinfo->absTime,orbitalinfo->lat,orbitalinfo->lon); // to convert from Dij to Qij

	} // end of if(atime<RTtime1[0]
	} // end of f(((orbitalinfo->TimeGap>60.0 && TMath...
       } // end of MU~=0

	TMatrixD qij = PO->ColPermutation(Qij);
	TMatrixD Fij = PO->ECItoGreenwich(Qij,orbitalinfo->absTime);
	TMatrixD Gij = PO->ColPermutation(Fij);
	Dij = PO->ECItoGEO(Qij,orbitalinfo->absTime,orbitalinfo->lat,orbitalinfo->lon);
	TMatrixD Iij = PO->ColPermutation(Dij);
	TVector3 SP = PO->GetSunPosition(orbitalinfo->absTime);
	// go to Pamela reference frame from Resurs reference frame
	Float_t tmpy = SP.Y();
	SP.SetY(SP.Z());
	SP.SetZ(-tmpy);
 	TVector3 SunZenith;
	SunZenith.SetMagThetaPhi(1,23.439281*TMath::DegToRad(),TMath::Pi()/2.);
	TVector3 SunMag = -SP;
	SunMag.Rotate(-45*TMath::DegToRad(),SunZenith);
	tmpy=SunMag.Y();
	SunMag.SetY(SunMag.Z());
	SunMag.SetZ(-tmpy);

	orbitalinfo->Iij.ResizeTo(Iij);
	orbitalinfo->Iij = Iij;
	//
        //	A1 = Iij(0,2);
        //	A2 = Iij(1,2);
        //	A3 = Iij(2,2);
	//
	//	orbitalinfo->pamzenitangle = (Float_t)PO->GetPitchAngle(1,0,0,A1,A2,A3);		        // Angle between zenit and Pamela's main axiz
	//	orbitalinfo->pamBangle = (Float_t)PO->GetPitchAngle(A1,A2,A3,Bx,By,Bz);			// Angle between Pamela's main axiz and B
	//
        if ( debug ) printf(" matrixes done  \n");
	if ( !standalone ){
          if ( debug ) printf(" !standalone \n");
	  //
          // Standard tracking algorithm
          //
	  Int_t nn = 0;
          if ( verbose ) printf(" standard tracking \n");
	  for(Int_t nt=0; nt < tof->ntrk(); nt++){  
	    //
	    ToFTrkVar *ptt = tof->GetToFTrkVar(nt); 
	    if (debug) cout<<"tof->ntrk() = "<<tof->ntrk()<<"\tptt->trkseqno = "<<ptt->trkseqno<<"\ttrke->ntrk() = "<<trke->ntrk()<<endl;
	    Double_t E11x = ptt->xtr_tof[0]; // tr->x[0];
	    Double_t E11y = ptt->ytr_tof[0]; //tr->y[0];
	    Double_t E11z = zin[0];
	    Double_t E22x = ptt->xtr_tof[3];//tr->x[3];
	    Double_t E22y = ptt->ytr_tof[3];//tr->y[3];
	    Double_t E22z = zin[3];
	    if ( (E11x < 100. && E11y < 100. && E22x < 100. && E22y < 100.) || ptt->trkseqno != -1  ){
	      TrkTrack *mytrack = trke->GetStoredTrack(ptt->trkseqno);
	      Float_t rig=1/mytrack->GetDeflection();
	      Double_t norm = sqrt(pow(E22x-E11x,2)+pow(E22y-E11y,2)+pow(E22z-E11z,2));
              //
	      Px = (E22x-E11x)/norm;
	      Py = (E22y-E11y)/norm;
	      Pz = (E22z-E11z)/norm;
	      //
	      t_orb->trkseqno = ptt->trkseqno; 
	      //
	      TMatrixD Eij = PO->PamelatoGEO(Iij,Px,Py,Pz);
	      t_orb->Eij.ResizeTo(Eij);	
	      t_orb->Eij = Eij;	
	      //
	      TMatrixD Sij = PO->PamelatoGEO(Gij,Px,Py,Pz);
	      t_orb->Sij.ResizeTo(Sij);
	      t_orb->Sij = Sij;
	      //	    
	      t_orb->pitch = (Float_t)PO->GetPitchAngle(Eij(0,0),Eij(1,0),Eij(2,0),Bx,By,Bz);
	      //
              // SunPosition in instrumental reference frame
	      TMatrixD Kij = PO->PamelatoGEO(qij,Px,Py,Pz);
	      TMatrixD Lij = PO->PamelatoGEO(qij,0,0,1);
	      t_orb->sunangle=(Float_t)PO->GetPitchAngle(Kij(0,0),Kij(1,0),Kij(2,0),-SP.X(),-SP.Y(),-SP.Z());
	      t_orb->sunmagangle=(Float_t)PO->GetPitchAngle(Kij(0,0),Kij(1,0),Kij(2,0),SunMag.X(),SunMag.Y(),SunMag.Z());
	      //
	      //
	      Double_t omega = PO->GetPitchAngle(-Eij(0,0),-Eij(1,0),-Eij(2,0),1,0,0) * TMath::DegToRad();
	      TVector3 Bxy(0,By,Bz);
	      TVector3 Exy(0,-Eij(1,0),-Eij(2,0));
	      Double_t dzeta=Bxy.Angle(Exy);
	      if (-Eij(1,0) < 0) dzeta=2.0*TMath::Pi() - dzeta;
              
              if(debug) cout << "omega = "<<omega*TMath::RadToDeg()<<"\tdzeta = "<<dzeta*TMath::RadToDeg()<<endl;

              // Formula from D.F. Smart *, M.A. Shea [2005]; A review of geomagnetic cutoff rigidities for earth-orbiting spacecraft
	      if(rig>=0) t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow(1+sqrt(1-sin(omega)*sin(dzeta)*pow(cos(orbitalinfo->lat*TMath::DegToRad()),3)),2));
	      else       t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow(1+sqrt(1-sin(omega)*sin(TMath::Pi()+dzeta)*pow(cos(orbitalinfo->lat*TMath::DegToRad()),3)),2));
	      if (debug) cout << "R = " << rig << "\tcutoff = " << t_orb->cutoff << endl;

	      //
	      if ( t_orb->pitch != t_orb->pitch ) t_orb->pitch = -1000.;
	      if ( t_orb->cutoff != t_orb->cutoff ) t_orb->cutoff = -1000.;
	      if ( t_orb->sunangle != t_orb->sunangle ) t_orb->sunangle = -1000.;
	      if ( t_orb->sunmagangle != t_orb->sunmagangle ) t_orb->sunmagangle = -1000.;
	      //
	      if ( debug ) printf(" orbitalinfo->cutoffsvl %f vitaly %f \n",orbitalinfo->cutoffsvl,t_orb->cutoff);
 	      //
 	      new(tor[nn]) OrbitalInfoTrkVar(*t_orb);
	      nn++;
 	      //
 	      t_orb->Clear();
	      //
	    } 
	    //
	  } // end standard tracking algorithm

          //
          // Code for extended tracking algorithm: 
          //
          if ( hasNucleiTrk ){
            Int_t ttentry = 0;
            if ( verbose ) printf(" hasNucleiTrk \n");
            for(Int_t nt=0; nt < tcNucleiTof->GetEntries() ; nt++){  
              //
              if ( verbose ) printf(" got1\n");
              ToFTrkVar *ptt = (ToFTrkVar*)(tcNucleiTof->At(nt));
              if (verbose) cout<<" tcNucleiTof->GetEntries() = "<<tcNucleiTof->GetEntries()<<"\tptt->trkseqno = "<<ptt->trkseqno<<endl;
              Double_t E11x = ptt->xtr_tof[0]; // tr->x[0];
              Double_t E11y = ptt->ytr_tof[0]; //tr->y[0];
              Double_t E11z = zin[0];
              Double_t E22x = ptt->xtr_tof[3];//tr->x[3];
              Double_t E22y = ptt->ytr_tof[3];//tr->y[3];
              Double_t E22z = zin[3];
              if ( (E11x < 100. && E11y < 100. && E22x < 100. && E22y < 100.) || ptt->trkseqno != -1  ){
                TrkTrack *mytrack = (TrkTrack*)(tcNucleiTrk->At(ptt->trkseqno)); 
                if ( verbose ) printf(" got tcNucleiTrk \n");
                Float_t rig=1/mytrack->GetDeflection();
                Double_t norm = sqrt(pow(E22x-E11x,2)+pow(E22y-E11y,2)+pow(E22z-E11z,2));
                //
                Px = (E22x-E11x)/norm;
                Py = (E22y-E11y)/norm;
                Pz = (E22z-E11z)/norm;
                //
                t_orb->trkseqno = ptt->trkseqno; 
                //
                TMatrixD Eij = PO->PamelatoGEO(Iij,Px,Py,Pz);
                t_orb->Eij.ResizeTo(Eij);	
                t_orb->Eij = Eij;	
                //
                TMatrixD Sij = PO->PamelatoGEO(Gij,Px,Py,Pz);
                t_orb->Sij.ResizeTo(Sij);
                t_orb->Sij = Sij;
                //	    
                t_orb->pitch = (Float_t)PO->GetPitchAngle(Eij(0,0),Eij(1,0),Eij(2,0),Bx,By,Bz);
                //
                // SunPosition in instrumental reference frame
                TMatrixD Kij = PO->PamelatoGEO(qij,Px,Py,Pz);
                TMatrixD Lij = PO->PamelatoGEO(qij,0,0,1);
                t_orb->sunangle=(Float_t)PO->GetPitchAngle(Kij(0,0),Kij(1,0),Kij(2,0),-SP.X(),-SP.Y(),-SP.Z());
                t_orb->sunmagangle=(Float_t)PO->GetPitchAngle(Kij(0,0),Kij(1,0),Kij(2,0),SunMag.X(),SunMag.Y(),SunMag.Z());
                //
                //
                Double_t omega = PO->GetPitchAngle(-Eij(0,0),-Eij(1,0),-Eij(2,0),1,0,0) * TMath::DegToRad();
                TVector3 Bxy(0,By,Bz);
                TVector3 Exy(0,-Eij(1,0),-Eij(2,0));
                Double_t dzeta=Bxy.Angle(Exy);
                if (-Eij(1,0) < 0) dzeta=2.0*TMath::Pi() - dzeta;
                
                if(debug) cout << "omega = "<<omega*TMath::RadToDeg()<<"\tdzeta = "<<dzeta*TMath::RadToDeg()<<endl;
                
                // Formula from D.F. Smart *, M.A. Shea [2005]; A review of geomagnetic cutoff rigidities for earth-orbiting spacecraft
                if(rig>=0) t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow(1+sqrt(1-sin(omega)*sin(dzeta)*pow(cos(orbitalinfo->lat*TMath::DegToRad()),3)),2));
                else       t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow(1+sqrt(1-sin(omega)*sin(TMath::Pi()+dzeta)*pow(cos(orbitalinfo->lat*TMath::DegToRad()),3)),2));
                if (debug) cout << "R = " << rig << "\tcutoff = " << t_orb->cutoff << endl;
                
                //
                if ( t_orb->pitch != t_orb->pitch ) t_orb->pitch = -1000.;
                if ( t_orb->cutoff != t_orb->cutoff ) t_orb->cutoff = -1000.;
                if ( t_orb->sunangle != t_orb->sunangle ) t_orb->sunangle = -1000.;
                if ( t_orb->sunmagangle != t_orb->sunmagangle ) t_orb->sunmagangle = -1000.;
                //
                if ( debug ) printf(" orbitalinfo->cutoffsvl %f vitaly %f \n",orbitalinfo->cutoffsvl,t_orb->cutoff);
                //
                TClonesArray &tt1 = *torbNucleiTrk;
                new(tt1[ttentry]) OrbitalInfoTrkVar(*t_orb);
                ttentry++;
                //
                t_orb->Clear();
                //
              } 
              //
            }
          } // end standard tracking algorithm: nuclei
          if ( hasExtNucleiTrk ){
            Int_t ttentry = 0;
            if ( verbose ) printf(" hasExtNucleiTrk \n");
            for(Int_t nt=0; nt < tcExtNucleiTof->GetEntries() ; nt++){  
              //
              if ( verbose ) printf(" got2\n");
              ToFTrkVar *ptt = (ToFTrkVar*)(tcExtNucleiTof->At(nt));
              if (verbose) cout<<" tcExtNucleiTof->GetEntries() = "<<tcExtNucleiTof->GetEntries()<<"\tptt->trkseqno = "<<ptt->trkseqno<<endl;
              Double_t E11x = ptt->xtr_tof[0]; // tr->x[0];
              Double_t E11y = ptt->ytr_tof[0]; //tr->y[0];
              Double_t E11z = zin[0];
              Double_t E22x = ptt->xtr_tof[3];//tr->x[3];
              Double_t E22y = ptt->ytr_tof[3];//tr->y[3];
              Double_t E22z = zin[3];
              if ( (E11x < 100. && E11y < 100. && E22x < 100. && E22y < 100.) || ptt->trkseqno != -1  ){
                ExtTrack *mytrack = (ExtTrack*)(tcExtNucleiTrk->At(ptt->trkseqno)); 
                if ( verbose ) printf(" got tcExtNucleiTrk \n");
                Float_t rig=1/mytrack->GetDeflection();
                Double_t norm = sqrt(pow(E22x-E11x,2)+pow(E22y-E11y,2)+pow(E22z-E11z,2));
                //
                Px = (E22x-E11x)/norm;
                Py = (E22y-E11y)/norm;
                Pz = (E22z-E11z)/norm;
                //
                t_orb->trkseqno = ptt->trkseqno; 
                //
                TMatrixD Eij = PO->PamelatoGEO(Iij,Px,Py,Pz);
                t_orb->Eij.ResizeTo(Eij);	
                t_orb->Eij = Eij;	
                //
                TMatrixD Sij = PO->PamelatoGEO(Gij,Px,Py,Pz);
                t_orb->Sij.ResizeTo(Sij);
                t_orb->Sij = Sij;
                //	    
                t_orb->pitch = (Float_t)PO->GetPitchAngle(Eij(0,0),Eij(1,0),Eij(2,0),Bx,By,Bz);
                //
                // SunPosition in instrumental reference frame
                TMatrixD Kij = PO->PamelatoGEO(qij,Px,Py,Pz);
                TMatrixD Lij = PO->PamelatoGEO(qij,0,0,1);
                t_orb->sunangle=(Float_t)PO->GetPitchAngle(Kij(0,0),Kij(1,0),Kij(2,0),-SP.X(),-SP.Y(),-SP.Z());
                t_orb->sunmagangle=(Float_t)PO->GetPitchAngle(Kij(0,0),Kij(1,0),Kij(2,0),SunMag.X(),SunMag.Y(),SunMag.Z());
                //
                //
                Double_t omega = PO->GetPitchAngle(-Eij(0,0),-Eij(1,0),-Eij(2,0),1,0,0) * TMath::DegToRad();
                TVector3 Bxy(0,By,Bz);
                TVector3 Exy(0,-Eij(1,0),-Eij(2,0));
                Double_t dzeta=Bxy.Angle(Exy);
                if (-Eij(1,0) < 0) dzeta=2.0*TMath::Pi() - dzeta;
                
                if(debug) cout << "omega = "<<omega*TMath::RadToDeg()<<"\tdzeta = "<<dzeta*TMath::RadToDeg()<<endl;
                
                // Formula from D.F. Smart *, M.A. Shea [2005]; A review of geomagnetic cutoff rigidities for earth-orbiting spacecraft
                if(rig>=0) t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow(1+sqrt(1-sin(omega)*sin(dzeta)*pow(cos(orbitalinfo->lat*TMath::DegToRad()),3)),2));
                else       t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow(1+sqrt(1-sin(omega)*sin(TMath::Pi()+dzeta)*pow(cos(orbitalinfo->lat*TMath::DegToRad()),3)),2));
                if (debug) cout << "R = " << rig << "\tcutoff = " << t_orb->cutoff << endl;
                
                //
                if ( t_orb->pitch != t_orb->pitch ) t_orb->pitch = -1000.;
                if ( t_orb->cutoff != t_orb->cutoff ) t_orb->cutoff = -1000.;
                if ( t_orb->sunangle != t_orb->sunangle ) t_orb->sunangle = -1000.;
                if ( t_orb->sunmagangle != t_orb->sunmagangle ) t_orb->sunmagangle = -1000.;
                //
                if ( debug ) printf(" orbitalinfo->cutoffsvl %f vitaly %f \n",orbitalinfo->cutoffsvl,t_orb->cutoff);
                //
                TClonesArray &tt2 = *torbExtNucleiTrk;
                new(tt2[ttentry]) OrbitalInfoTrkVar(*t_orb);
                ttentry++;
                //
                t_orb->Clear();
                //
              } 
              //
            }
          } // end standard tracking algorithm: nuclei extended
         if ( hasExtTrk ){
            Int_t ttentry = 0;
            if ( verbose ) printf(" hasExtTrk \n");
            for(Int_t nt=0; nt < tcExtTof->GetEntries() ; nt++){  
              //
              if ( verbose ) printf(" got3\n");
              ToFTrkVar *ptt = (ToFTrkVar*)(tcExtTof->At(nt));
              if (verbose) cout<<" tcExtTof->GetEntries() = "<<tcExtTof->GetEntries()<<"\tptt->trkseqno = "<<ptt->trkseqno<<endl;
              Double_t E11x = ptt->xtr_tof[0]; // tr->x[0];
              Double_t E11y = ptt->ytr_tof[0]; //tr->y[0];
              Double_t E11z = zin[0];
              Double_t E22x = ptt->xtr_tof[3];//tr->x[3];
              Double_t E22y = ptt->ytr_tof[3];//tr->y[3];
              Double_t E22z = zin[3];
              if ( (E11x < 100. && E11y < 100. && E22x < 100. && E22y < 100.) || ptt->trkseqno != -1  ){
                ExtTrack *mytrack = (ExtTrack*)(tcExtTrk->At(ptt->trkseqno)); 
                if ( verbose ) printf(" got tcExtTrk \n");
                Float_t rig=1/mytrack->GetDeflection();
                Double_t norm = sqrt(pow(E22x-E11x,2)+pow(E22y-E11y,2)+pow(E22z-E11z,2));
                //
                Px = (E22x-E11x)/norm;
                Py = (E22y-E11y)/norm;
                Pz = (E22z-E11z)/norm;
                //
                t_orb->trkseqno = ptt->trkseqno; 
                //
                TMatrixD Eij = PO->PamelatoGEO(Iij,Px,Py,Pz);
                t_orb->Eij.ResizeTo(Eij);	
                t_orb->Eij = Eij;	
                //
                TMatrixD Sij = PO->PamelatoGEO(Gij,Px,Py,Pz);
                t_orb->Sij.ResizeTo(Sij);
                t_orb->Sij = Sij;
                //	    
                t_orb->pitch = (Float_t)PO->GetPitchAngle(Eij(0,0),Eij(1,0),Eij(2,0),Bx,By,Bz);
                //
                // SunPosition in instrumental reference frame
                TMatrixD Kij = PO->PamelatoGEO(qij,Px,Py,Pz);
                TMatrixD Lij = PO->PamelatoGEO(qij,0,0,1);
                t_orb->sunangle=(Float_t)PO->GetPitchAngle(Kij(0,0),Kij(1,0),Kij(2,0),-SP.X(),-SP.Y(),-SP.Z());
                t_orb->sunmagangle=(Float_t)PO->GetPitchAngle(Kij(0,0),Kij(1,0),Kij(2,0),SunMag.X(),SunMag.Y(),SunMag.Z());
                //
                //
                Double_t omega = PO->GetPitchAngle(-Eij(0,0),-Eij(1,0),-Eij(2,0),1,0,0) * TMath::DegToRad();
                TVector3 Bxy(0,By,Bz);
                TVector3 Exy(0,-Eij(1,0),-Eij(2,0));
                Double_t dzeta=Bxy.Angle(Exy);
                if (-Eij(1,0) < 0) dzeta=2.0*TMath::Pi() - dzeta;
                
                if(debug) cout << "omega = "<<omega*TMath::RadToDeg()<<"\tdzeta = "<<dzeta*TMath::RadToDeg()<<endl;
                
                // Formula from D.F. Smart *, M.A. Shea [2005]; A review of geomagnetic cutoff rigidities for earth-orbiting spacecraft
                if(rig>=0) t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow(1+sqrt(1-sin(omega)*sin(dzeta)*pow(cos(orbitalinfo->lat*TMath::DegToRad()),3)),2));
                else       t_orb->cutoff = 59.3/(pow(orbitalinfo->L,2)*pow(1+sqrt(1-sin(omega)*sin(TMath::Pi()+dzeta)*pow(cos(orbitalinfo->lat*TMath::DegToRad()),3)),2));
                if (debug) cout << "R = " << rig << "\tcutoff = " << t_orb->cutoff << endl;
                
                //
                if ( t_orb->pitch != t_orb->pitch ) t_orb->pitch = -1000.;
                if ( t_orb->cutoff != t_orb->cutoff ) t_orb->cutoff = -1000.;
                if ( t_orb->sunangle != t_orb->sunangle ) t_orb->sunangle = -1000.;
                if ( t_orb->sunmagangle != t_orb->sunmagangle ) t_orb->sunmagangle = -1000.;
                //
                if ( debug ) printf(" orbitalinfo->cutoffsvl %f vitaly %f \n",orbitalinfo->cutoffsvl,t_orb->cutoff);
                //
                TClonesArray &tt3 = *torbExtTrk;
                new(tt3[ttentry]) OrbitalInfoTrkVar(*t_orb);
                ttentry++;
                //
                t_orb->Clear();
                //
              } 
              //
            }
          } // end standard tracking algorithm: extended

	} else {
	  if ( debug ) printf(" mmm... mode %u standalone  \n",orbitalinfo->mode);
	}
	//
      } else { // HERE IT MISS ALL CODE FOR EXTENDED TRACKING!
	if ( !standalone ){
	  //
          if ( verbose ) printf(" no orb info for tracks \n");
	  Int_t nn = 0;
	  for(Int_t nt=0; nt < tof->ntrk(); nt++){  
	    //
	    ToFTrkVar *ptt = tof->GetToFTrkVar(nt); 
	    if ( ptt->trkseqno != -1  ){
	      //
	      t_orb->trkseqno = ptt->trkseqno; 
	      //
	      t_orb->Eij = 0;	
	      //
	      t_orb->Sij = 0;
	      //	    
	      t_orb->pitch = -1000.;
	      //
	      t_orb->sunangle = -1000.;
	      //
	      t_orb->sunmagangle = -1000;
	      //
	      t_orb->cutoff = -1000.;
	      //
 	      new(tor[nn]) OrbitalInfoTrkVar(*t_orb);
	      nn++;
 	      //
 	      t_orb->Clear();
	      //
	    }
	    //
	  }
          //
          // Code for extended tracking algorithm: 
          //
          if ( hasNucleiTrk ){
            Int_t ttentry = 0;
            if ( verbose ) printf(" hasNucleiTrk \n");
            for(Int_t nt=0; nt < tcNucleiTof->GetEntries() ; nt++){  
              //  
              ToFTrkVar *ptt = (ToFTrkVar*)(tcNucleiTof->At(nt));
              if ( ptt->trkseqno != -1  ){
                //
                t_orb->trkseqno = ptt->trkseqno; 
                //
                t_orb->Eij = 0;	
                //
                t_orb->Sij = 0;
                //	    
                t_orb->pitch = -1000.;
                //
                t_orb->sunangle = -1000.;
                //
                t_orb->sunmagangle = -1000;
                //
                t_orb->cutoff = -1000.;
                //
                TClonesArray &tz1 = *torbNucleiTrk;
                new(tz1[ttentry]) OrbitalInfoTrkVar(*t_orb);
                ttentry++;
                //
                t_orb->Clear();
                //
              }
              //
            }
          }
          if ( hasExtNucleiTrk ){
            Int_t ttentry = 0;
            if ( verbose ) printf(" hasExtNucleiTrk \n");
            for(Int_t nt=0; nt < tcExtNucleiTof->GetEntries() ; nt++){  
              //
              if ( verbose ) printf(" got2\n");
              ToFTrkVar *ptt = (ToFTrkVar*)(tcExtNucleiTof->At(nt));
              if ( ptt->trkseqno != -1  ){
                //
                t_orb->trkseqno = ptt->trkseqno; 
                //
                t_orb->Eij = 0;	
                //
                t_orb->Sij = 0;
                //	    
                t_orb->pitch = -1000.;
                //
                t_orb->sunangle = -1000.;
                //
                t_orb->sunmagangle = -1000;
                //
                t_orb->cutoff = -1000.;
                //
                TClonesArray &tz2 = *torbExtNucleiTrk;
                new(tz2[ttentry]) OrbitalInfoTrkVar(*t_orb);
                ttentry++;
                //
                t_orb->Clear();
                //
              }
              //
            }
          }
          if ( hasExtTrk ){
            Int_t ttentry = 0;
            if ( verbose ) printf(" hasExtTrk \n");
            for(Int_t nt=0; nt < tcExtTof->GetEntries() ; nt++){  
              //
              if ( verbose ) printf(" got3\n");
              ToFTrkVar *ptt = (ToFTrkVar*)(tcExtTof->At(nt));
              if ( ptt->trkseqno != -1  ){
                //
                t_orb->trkseqno = ptt->trkseqno; 
                //
                t_orb->Eij = 0;	
                //
                t_orb->Sij = 0;
                //	    
                t_orb->pitch = -1000.;
                //
                t_orb->sunangle = -1000.;
                //
                t_orb->sunmagangle = -1000;
                //
                t_orb->cutoff = -1000.;
                //
                TClonesArray &tz3 = *torbExtNucleiTrk;
                new(tz3[ttentry]) OrbitalInfoTrkVar(*t_orb);
                ttentry++;
                //
                t_orb->Clear();
                //
              }
              //
            }
          }
	}
      }	// if( orbitalinfo->TimeGap>0){
      //
      // Fill the class
      //
      OrbitalInfotr->Fill();
      //
      delete t_orb;
      //
    }; // loop over the events in the run
    //
    // Here you may want to clear some variables before processing another run  
    //

    if ( verbose ) printf(" Clear before new run \n");
    delete dbtime;

    if ( mcmdrc ) mcmdrc->Clear();
    mcmdrc = 0;
    
    if ( verbose ) printf(" Clear before new run1 \n");
    if ( L_QQ_Q_l_lower ) delete L_QQ_Q_l_lower;
    if ( verbose ) printf(" Clear before new run2 \n");
    if ( L_QQ_Q_l_upper ) delete L_QQ_Q_l_upper;
    if ( verbose ) printf(" Clear before new run3 \n");
    if ( RYPang_upper ) delete RYPang_upper;
    if ( verbose ) printf(" Clear before new run4 \n");
    if ( RYPang_lower ) delete RYPang_lower;

    if ( l0tr ) l0tr->Delete();
    
    if ( verbose ) printf(" End run \n");

  }; // process all the runs
  
  if (verbose) printf("\n Finished processing data \n");
  //
 closeandexit:
  //
  // we have finished processing the run(s). If we processed a single run now we must copy all the events after our run from the old tree to the new one and delete the old tree.
  //
  if ( !reprocall && reproc && code >= 0 ){
    if ( totfileentries > noaftrun ){
      if (verbose){
	printf("\n Post-processing: copying events from the old tree after the processed run\n");   
	printf(" Copying %i events in the file which are after the end of the run %i \n",(int)(totfileentries-noaftrun),(int)run);
	printf(" Start copying at event number %i end copying at event number %i \n",(int)noaftrun,(int)totfileentries);
      }
      for (UInt_t j = noaftrun; j < totfileentries; j++ ){
	//
	// Get entry from old tree
	//
	if ( OrbitalInfotrclone->GetEntry(j) <= 0 ) throw -36;	  
	//
	// copy orbitalinfoclone to OrbitalInfo
	//
        //	orbitalinfo->Clear();
	//
	memcpy(&orbitalinfo,&orbitalinfoclone,sizeof(orbitalinfoclone));
	//
	// Fill entry in the new tree
	//
	OrbitalInfotr->Fill();
      };
      if (verbose) printf(" Finished successful copying!\n");
    };
    //if ( OrbitalInfotrclone )    OrbitalInfotrclone->Clear();         
    //if ( OrbitalInfotrclone )    OrbitalInfotrclone->Delete();         
  };
  //
  // Close files, delete old tree(s), write and close level2 file 
  //

  if ( l0File ) l0File->Close();
  if ( myfold ) gSystem->Unlink(tempname.str().c_str());
  //
  if ( OrbitalInfotr ) OrbitalInfotr->SetName("OrbitalInfo");    
  //
  if ( file ){
    file->cd();
    if ( OrbitalInfotr ) OrbitalInfotr->Write("OrbitalInfo", TObject::kOverwrite); // 10 RED bug fixed
  };
  //
  if (verbose) printf("\n Exiting...\n");

  if ( myfold ) gSystem->Unlink(OrbitalInfofolder.str().c_str());
  //
  // the end
  //
  if ( dbc ){
    dbc->Close();
    delete dbc;
  };
  //
  if (verbose) printf("\n Exiting...\n");
  if ( tempfile ) tempfile->Close();            
  
  if ( PO ) delete PO;
  if ( gltle ) delete gltle;
  if ( glparam ) delete glparam;
  if ( glparam2 ) delete glparam2;
  if ( glparam3 ) delete glparam3;
  if (verbose) printf("\n Exiting3...\n");
  if ( glroot ) delete glroot;
  if (verbose) printf("\n Exiting4...\n");
  if ( runinfo ) runinfo->Close();    
  if ( runinfo ) delete runinfo; 

  if ( tcNucleiTrk ){
    tcNucleiTrk->Delete();
    delete tcNucleiTrk;
    tcNucleiTrk = NULL;
  }
  if ( tcExtNucleiTrk ){
    tcExtNucleiTrk->Delete();
    delete tcExtNucleiTrk;
    tcExtNucleiTrk = NULL;
  }
  if ( tcExtTrk ){
    tcExtTrk->Delete();
    delete tcExtTrk;
    tcExtTrk = NULL;
  }

  if ( tcNucleiTof ){
    tcNucleiTof->Delete();
    delete tcNucleiTof;
    tcNucleiTof = NULL;
  }
  if ( tcExtNucleiTof ){
    tcExtNucleiTof->Delete();
    delete tcExtNucleiTof;
    tcExtNucleiTof = NULL;
  }
  if ( tcExtTof ){
    tcExtTof->Delete();
    delete tcExtTof;
    tcExtTrk = NULL;
  }


  if ( tof ) delete tof;
  if ( trke ) delete trke;

  if ( debug ){  
  cout << "1   0x" << OrbitalInfotr << endl;
  cout << "2   0x" << OrbitalInfotrclone << endl;
  cout << "3   0x" << l0tr << endl;
  cout << "4   0x" << tempOrbitalInfo << endl;
  cout << "5   0x" << ttof << endl;
  }
  //
  if ( debug )  file->ls();
  //
  if(code < 0)  throw code;
  return(code);
}


//
// Returns the cCoordGeo structure holding the geographical
// coordinates for the event (see sgp4.h).
//
// atime is the abstime of the event in UTC unix time.
// tletime is the time of the tle in UTC unix time.
// tle is the previous and nearest tle (compared to atime).
cCoordGeo getCoo(UInt_t atime, UInt_t tletime, cTle *tle)
{
  cEci eci;
  cOrbit orbit(*tle);
  orbit.getPosition((double) (atime - tletime)/60., &eci);
  
  return eci.toGeo();
}

// function of copyng of quatrnions classes

void CopyQ(Quaternions *Q1, Quaternions *Q2){
  for(UInt_t i = 0; i < 6; i++){
    Q1->time[i]=Q2->time[i];
    for (UInt_t j = 0; j < 4; j++)Q1->quat[i][j]=Q2->quat[i][j];
  }
  return;
}

// functions of copyng InclinationInfo classes

void CopyAng(InclinationInfo *A1, InclinationInfo *A2){
  A1->Tangazh = A2->Tangazh;
  A1->Ryskanie = A2->Ryskanie;
  A1->Kren = A2->Kren;
  return;
}

UInt_t holeq(Double_t lower,Double_t upper,Quaternions *Qlower, Quaternions *Qupper, UInt_t f){
  
  UInt_t hole = 10;
  Bool_t R10l = false;     // Sign of R10 mode in lower quaternions array
  Bool_t R10u = false;     // Sign of R10 mode in upper quaternions array
  Bool_t insm = false;     // Sign that we inside quaternions array
  //  Bool_t mxtml = false;    // Sign of mixt mode in lower quaternions array
  //  Bool_t mxtmu = false;    // Sign of mixt mode in upper quaternions array
  Bool_t npasm = false;     // Sign of normall pass between R10 and non R10 or between non R10 and R10
  UInt_t NCQl = 6;       // Number of correct quaternions in lower array
  //  UInt_t NCQu = 6;       // Number of correct quaternions in upper array
  if (f>0){
    insm = true;
    if(Qupper->time[f]-Qupper->time[f-1]==30) R10u = false;
    if(Qupper->time[f]-Qupper->time[f-1]<1) R10u = true;
  }else{
    insm = false;
    if((Qlower->time[5]-Qlower->time[0]<2)&&(Qlower->time[1]-Qlower->time[0]<2)) R10l = true;
    if((Qupper->time[5]-Qupper->time[0]<2)&&(Qupper->time[1]-Qupper->time[0]<2)) R10u = true;
    if((Qlower->time[5]-Qlower->time[0]==150)&&(Qlower->time[1]-Qlower->time[0]==30)) R10l = false;
    if((Qupper->time[5]-Qupper->time[0]==150)&&(Qupper->time[1]-Qupper->time[0]==30)) R10u = false;
    if((Qlower->time[5]-Qlower->time[0]<2)&&(Qlower->time[1]-Qlower->time[0]==30)){
      //      mxtml = true;
      for(UInt_t i = 1; i < 6; i++){
	if(Qlower->time[i]-Qlower->time[0]==30*i) NCQl=i;
      }
    }
    //    if((Qupper->time[5]-Qupper->time[0]<2)&&(Qupper->time[1]-Qupper->time[0]==30)){
      //      mxtmu = true;
      //      for(UInt_t i = 1; i < 6; i++){
      //	if(Qupper->time[i]-Qupper->time[0]==30*i) NCQu=i;
      //      }
    //    }
  }
  
  if(((upper-lower==1.5)||(upper-lower==3.)||(upper-lower==30.)||(upper-lower==31.5)||(upper-lower==33.)||(upper-lower==181.5)||(upper-lower==210.)||(upper-lower==211.5))&&!insm) npasm = true;
  
  
  if (R10u&&insm) hole=0; // best event R10
  if ((upper-lower<=5)&&(!insm)&&R10l&&R10u) hole = 1; // when first of 6 quaternions in array is correct
  if (((!R10u)&&insm)||((!insm)&&(!R10u)&&(!R10l)&&((upper-lower==210+(6-NCQl)*30)||(upper-lower==30)))) hole = 2; //non R10
  if (npasm&&(!insm)&&((R10l&&!R10u)||(R10u&&!R10l))) hole = 3; //normall pass from R10 to non R10 or from non R10 to R10
  if ((!npasm)&&(upper-lower<=300)&&(!insm)&&((R10l&&!R10u)||(R10u&&!R10l))) hole = 4; // eliminable hole between R10 and non R10 or between non R10 and R10
  if ((upper-lower>=300)&&(!insm)&&((R10l&&!R10u)||(R10u&&!R10l))) hole = 5; //uneliminable hole between R10 and non R10 or between non R10 and R10
  if ((upper-lower>5)&&(upper-lower<=300)&&R10u&&R10l) hole = 6; // eliminable hole inside R10
  if ((upper-lower>300)&&R10u&&R10l) hole = 7; //uneliminable hole inside R10
  if ((upper-lower>210)&&(upper-lower<=1200)&&(!R10u)&&(!R10l)) hole = 8; //eliminable hole inside non R10
  if ((upper-lower>1200)&&!R10u&&!R10l) hole = 9; // uneliminable hole inside non R10
  return hole;
}

void inclresize(vector<Double_t>& t,vector<Float_t>& q0,vector<Float_t>& q1,vector<Float_t>& q2,vector<Float_t>& q3,vector<Int_t>& mode,vector<Float_t>& Roll,vector<Float_t>& Pitch,vector<Float_t>& Yaw){
  Int_t sizee = t.size()+1;
  t.resize(sizee);
  q0.resize(sizee);
  q1.resize(sizee);
  q2.resize(sizee);
  q3.resize(sizee);
  mode.resize(sizee);
  Roll.resize(sizee);
  Pitch.resize(sizee);
  Yaw.resize(sizee);
}

// geomagnetic calculation staff 

//void GM_ScanIGRF(TString PATH, GMtype_Data *G0, GMtype_Data *G1, GMtype_Data *H1)
void GM_ScanIGRF(TSQLServer *dbc, GMtype_Data *G0, GMtype_Data *G1, GMtype_Data *H1)
{
  GL_PARAM *glp = new GL_PARAM();
  Int_t parerror=glp->Query_GL_PARAM(1,304,dbc); // parameters stored in DB in GL_PRAM table  
  if ( parerror<0 ) {
    throw -902;
  }
	/*This function scans inputs G0, G1, and H1 of the IGRF table into 3 data arrays*/
  //	TString SATH="/data03/Malakhov/pam9Malakhov/installed10/calib/orb-param/";
	int i;
	double temp;
	char buffer[200]; 
	FILE *IGRF;
	IGRF = fopen((glp->PATH+glp->NAME).Data(), "r");
        //	IGRF = fopen(PATH+"IGRF.tab", "r");
	G0->size = 25;
	G1->size = 25;
	H1->size = 25;
	for( i = 0; i < 4; i++)
	{
		fgets(buffer, 200, IGRF);
	}
	fscanf(IGRF, "g 1 0 %lf ", &G0->element[0]); 
	for(i = 1; i <= 22; i++)
	{
		fscanf(IGRF ,"%lf ", &G0->element[i]);
	}
	fscanf(IGRF ,"%lf\n", &temp);
	G0->element[23] = temp * 5 + G0->element[22];
	G0->element[24] = G0->element[23] + 5 * temp;
	fscanf(IGRF, "g 1 1 %lf ", &G1->element[0]);
	for(i = 1; i <= 22; i++)
	{
		fscanf( IGRF, "%lf ", &G1->element[i]);
	}
	fscanf(IGRF, "%lf\n", &temp);
	G1->element[23] = temp * 5 + G1->element[22];
	G1->element[24] = temp * 5 + G1->element[23];
	fscanf(IGRF, "h 1 1 %lf ", &H1->element[0]);
	for(i = 1; i <= 22; i++)
	{
		fscanf( IGRF, "%lf ", &H1->element[i]);
	}
	fscanf(IGRF, "%lf\n", &temp);
	H1->element[23] = temp * 5 + H1->element[22];
	H1->element[24] = temp * 5 + H1->element[23];
  if ( glp ) delete glp;
} /*GM_ScanIGRF*/

void GM_SetEllipsoid(GMtype_Ellipsoid *Ellip)
{
	/*This function sets the WGS84 reference ellipsoid to its default values*/
	Ellip->a	=			6378.137; /*semi-major axis of the ellipsoid in */
	Ellip->b	=			6356.7523142;/*semi-minor axis of the ellipsoid in */
	Ellip->fla	=			1/298.257223563;/* flattening */
	Ellip->eps	=			sqrt(1- ( Ellip->b *	Ellip->b) / (Ellip->a * Ellip->a ));  /*first eccentricity */
	Ellip->epssq	=			(Ellip->eps * Ellip->eps);   /*first eccentricity squared */
	Ellip->re	=			6371.2;/* Earth's radius */
} /*GM_SetEllipsoid*/


void GM_EarthCartToDipoleCartCD(GMtype_Pole Pole, GMtype_CoordCartesian EarthCoord, GMtype_CoordCartesian *DipoleCoords)
{
	/*This function converts from Earth centered cartesian coordinates to dipole centered cartesian coordinates*/
	double X, Y, Z, CosPhi, SinPhi, CosLambda, SinLambda;
	CosPhi = cos(TMath::DegToRad()*Pole.phi);
	SinPhi = sin(TMath::DegToRad()*Pole.phi);
	CosLambda = cos(TMath::DegToRad()*Pole.lambda);
	SinLambda = sin(TMath::DegToRad()*Pole.lambda);
	X = EarthCoord.x;
	Y = EarthCoord.y;
	Z = EarthCoord.z;
	
	/*These equations are taken from a document by Wallace H. Campbell*/
	DipoleCoords->x = X * CosPhi * CosLambda + Y * CosPhi * SinLambda - Z * SinPhi;
	DipoleCoords->y = -X * SinLambda + Y * CosLambda;
	DipoleCoords->z = X * SinPhi * CosLambda + Y * SinPhi * SinLambda + Z * CosPhi;
} /*GM_EarthCartToDipoleCartCD*/

void GM_GeodeticToSpherical(GMtype_Ellipsoid Ellip, GMtype_CoordGeodetic CoordGeodetic, GMtype_CoordSpherical *CoordSpherical)
{
	double CosLat, SinLat, rc, xp, zp; /*all local variables */
	/*
	** Convert geodetic coordinates, (defined by the WGS-84
	** reference ellipsoid), to Earth Centered Earth Fixed Cartesian
	** coordinates, and then to spherical coordinates.
	*/

	CosLat = cos(TMath::DegToRad()*CoordGeodetic.phi);
	SinLat = sin(TMath::DegToRad()*CoordGeodetic.phi);

	/* compute the local radius of curvature on the WGS-84 reference ellipsoid */

	rc = Ellip.a / sqrt(1.0 - Ellip.epssq * SinLat * SinLat);

	/* compute ECEF Cartesian coordinates of specified point (for longitude=0) */

	xp = (rc + CoordGeodetic.HeightAboveEllipsoid) * CosLat;
	zp = (rc*(1.0 - Ellip.epssq) + CoordGeodetic.HeightAboveEllipsoid) * SinLat;

	/* compute spherical radius and angle lambda and phi of specified point */

	CoordSpherical->r = sqrt(xp * xp + zp * zp);
	CoordSpherical->phig = TMath::RadToDeg()*asin(zp / CoordSpherical->r);     /* geocentric latitude */
	CoordSpherical->lambda = CoordGeodetic.lambda;                   /* longitude */
} /*GM_GeodeticToSpherical*/

void GM_PoleLocation(GMtype_Model Model, GMtype_Pole *Pole)
{
	/*This function finds the location of the north magnetic pole in spherical coordinates.  The equations are
	**from Wallace H. Campbell's Introduction to Geomagnetic Fields*/

	Pole->phi = TMath::RadToDeg()*-atan(sqrt(Model.h1 * Model.h1 + Model.g1 * Model.g1)/Model.g0);
	Pole->lambda = TMath::RadToDeg()*atan(Model.h1/Model.g1);
} /*GM_PoleLocation*/

void GM_SphericalToCartesian(GMtype_CoordSpherical CoordSpherical, GMtype_CoordCartesian *CoordCartesian)
{
	/*This function converts spherical coordinates into Cartesian coordinates*/
	double CosPhi = cos(TMath::DegToRad()*CoordSpherical.phig);
	double SinPhi = sin(TMath::DegToRad()*CoordSpherical.phig);
	double CosLambda = cos(TMath::DegToRad()*CoordSpherical.lambda);
	double SinLambda = sin(TMath::DegToRad()*CoordSpherical.lambda);
	
	CoordCartesian->x = CoordSpherical.r * CosPhi * CosLambda;
	CoordCartesian->y = CoordSpherical.r * CosPhi * SinLambda;
	CoordCartesian->z = CoordSpherical.r * SinPhi;
} /*GM_SphericalToCartesian*/

void GM_TimeAdjustCoefs(Float_t year, Float_t jyear, GMtype_Data g0d, GMtype_Data g1d, GMtype_Data h1d, GMtype_Model *Model)
{
	/*This function calls GM_LinearInterpolation for the coefficients to estimate the value of the 
	**coefficient for the given date*/
	int index;
	double x;
	index = (year - GM_STARTYEAR) / 5;
	x = (jyear - GM_STARTYEAR) / 5;
	Model->g0 = GM_LinearInterpolation(index, index+1, g0d.element[index], g0d.element[index+1], x);
	Model->g1 = GM_LinearInterpolation(index, index+1, g1d.element[index], g1d.element[index+1], x);
	Model->h1 = GM_LinearInterpolation(index, index+1, h1d.element[index], h1d.element[index+1], x);
} /*GM_TimeAdjustCoefs*/

double GM_LinearInterpolation(double x1, double x2, double y1, double y2, double x)
{
	/*This function takes a linear interpolation between two given points for x*/
	double weight, y;
	weight  = (x - x1) / (x2 - x1);
	y = y1 * (1 - weight) + y2 * weight;
	return y;
}/*GM_LinearInterpolation*/

void GM_CartesianToSpherical(GMtype_CoordCartesian CoordCartesian, GMtype_CoordSpherical *CoordSpherical)
{
	/*This function converts a point from Cartesian coordinates into spherical coordinates*/
	double X, Y, Z;
	
	X = CoordCartesian.x;
	Y = CoordCartesian.y;
	Z = CoordCartesian.z;

	CoordSpherical->r = sqrt(X * X + Y * Y + Z * Z);
	CoordSpherical->phig = TMath::RadToDeg()*asin(Z / (CoordSpherical->r));
	CoordSpherical->lambda = TMath::RadToDeg()*atan2(Y, X);
} /*GM_CartesianToSpherical*/
