#ifndef OrientationInfo_H
#define OrientationInfo_H

#include <TObject.h>
#include <TMatrixD.h>
#include <TString.h>
#include <TMath.h>
#include <TVector3.h>

class OrientationInfo : public TObject {

 private:

    Double_t a;// = 360/(2*TMath::Pi());
    Double_t Re;// = 6000000.0;

    TMatrixD DirAxisGreenwich;
    TMatrixD DirAxisGEO;
    void SetDirAxisGreenwich(TMatrixD Aij){DirAxisGreenwich = Aij;}
    void SetDirAxisGEO(TMatrixD Aij){DirAxisGEO = Aij;}

 public:

    OrientationInfo();
    ~OrientationInfo();

    Double_t PitchAngle;

    TMatrixD QuatoECI(Float_t q0, Float_t q1, Float_t q2, Float_t q3);
    TMatrixD ECItoGreenwich(TMatrixD Aij, UInt_t t);
    TMatrixD ECItoGEO(TMatrixD Aij, UInt_t t, Double_t lat, Double_t lon);
    TMatrixD GEOtoECI(TMatrixD Aij, UInt_t t, Double_t lat, Double_t lon);
    TMatrixD GreenwichtoGEO(Double_t lat, Double_t lon, TMatrixD Aij);
    TMatrixD EulertoEci(Double_t x0, Double_t y0, Double_t z0, Double_t Vx0, Double_t Vy0, Double_t Vz0, Double_t Bank, Double_t Yaw, Double_t SPitch);
    TMatrixD GEOtoGeomag(TMatrixD Aij, Double_t B1, Double_t B2, Double_t B3);
    TMatrixD PamelatoGEO(TMatrixD Aij, Double_t B1, Double_t B2, Double_t B3);
    TMatrixD ColPermutation(TMatrixD Aij);
    TVector3 GetSunPosition(UInt_t atime);
    Float_t  Larmor(Float_t Ek,Float_t Bm,Int_t iZ,Float_t xA);
    TMatrixD GetDirectiontoGirocenter(Float_t R, Float_t Px, Float_t Py);
    Double_t GetPitchAngle(Double_t x1, Double_t y1, Double_t z1, Double_t x2, Double_t y2, Double_t z2);

    Double_t GetPamMainGwX(){return DirAxisGreenwich(0,1);}
    Double_t GetPamMainGwY(){return DirAxisGreenwich(1,1);}
    Double_t GetPamMainGwZ(){return DirAxisGreenwich(2,1);}

    Double_t GetPamMainGEOX(){return DirAxisGEO(0,1);}
    Double_t GetPamMainGEOY(){return DirAxisGEO(1,1);}
    Double_t GetPamMainGEOZ(){return DirAxisGEO(2,1);}

    TMatrixD GetGw(){return DirAxisGreenwich;}
    TMatrixD GetGEO(){return DirAxisGEO;}

    ClassDef(OrientationInfo,2);
};

#endif
