#ifndef OrbitalInfoStruct_h
#define OrbitalInfoStruct_h

#include <TVector3.h>
#include<TMatrixD.h>

struct cOrbitalInfo {

  ULong64_t abstime; //< Absolute Time
  // EM: added On Board Time and CPU Packet Number
  ULong64_t obt; //< On Board Time
  ULong64_t pkt_num; //< CPU packet number

  // Position
  Float_t lon; // degree from -180 to 180
  Float_t lat; // degree from -90 to 90
  Float_t alt; // meters

  TVector3 V; // Velocity

  TMatrixD Iij;

  Float_t londip;
  Float_t latdip;

  // Magnetic field

  // components (gauss)
  Float_t Bnorth;
  Float_t Beast;
  Float_t Bdown;

  // abs value (guass)
  Float_t Babs;

  //Earth dipole moment

  Float_t M;

  // Minimum along the field line (that is at the magnetic equator)
  Float_t BB0;

  // Distance of the magnetic equator in earth radii
  Float_t L; 

  Float_t cutoffsvl;

  // Quaternions
  Float_t q0, q1, q2, q3;

  // Euler angles (nadir reference frame)
  Float_t theta, phi, etha;

  // quality of orientation information
  Int_t mode;
  Int_t qkind;
  Int_t errq;
  Int_t azim;
  Int_t rtqual;

  void InitcOrbitalInfo(){
    abstime = 0;
    obt     = 0;
    pkt_num = 0;
  }
};

#endif
