/***************************************************************************
 *   Copyright (C) 2006 by pamelaprod                                      *
 *   pamelaprod@P1.pamela                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FIRST_H
#define FIRST_H

#include <TObject.h>
#include <iostream>
#include <TArrayC.h>
#include <TROOT.h>

class InclinationInfoI : public TObject {
 public:
  //Quaternions Lx_y
     // The data are organized in 5 groups according to the format
     // time    -   L0       -     L1     -     L2     -     L3
     // time[0] - quat[0][0] - quat[0][1] - quat[0][2] - quat[0][3]
     // time[1] - quat[1][0] - quat[1][1] - quat[1][2] - quat[1][3]
     // time[2] - quat[2][0] - quat[2][1] - quat[2][2] - quat[2][3]
     // time[3] - quat[3][0] - quat[3][1] - quat[3][2] - quat[3][3]
     // time[4] - quat[4][0] - quat[4][1] - quat[4][2] - quat[4][3]
     // time[5] - quat[5][0] - quat[5][1] - quat[5][2] - quat[5][3]
  //
  double time[6]; 
  double quat[6][4]; 
  
  InclinationInfoI(){}; 
    ~InclinationInfoI() {};
  
  void fill(TArrayC* data);
  void clear(); 
  //  const char* toXML(char*);
  ClassDef(InclinationInfoI,1)
};

/**
   @author pamelaprod
*/
class Quaternions: public InclinationInfoI {
 public:
  
  Quaternions();    
  ~Quaternions();
  
  //Int_t CodeErrQua;   

  ClassDef(Quaternions,1)
};

class InclinationInfo: public TObject {
public:

    InclinationInfo();
    ~InclinationInfo();
    
    Double_t Tangazh;
    Double_t Ryskanie;
    Double_t Kren;
    
    bool mode;
//    Float_t dircutoff;
    
    void TransAngle(Double_t x,Double_t y,Double_t z,Double_t Vx0,Double_t Vy0, Double_t Vz0, Double_t q0, Double_t q1, Double_t q2, Double_t q3);
    
//    float_t procRegidity(double_t L, double_t B, double_t R);
        
    void Clear(Option_t *t="");
    ClassDef(InclinationInfo,1)
};

#endif
