#ifndef OrbitalInfo_h
#define OrbitalInfo_h

#include <TObject.h>
#include <OrbitalInfoStruct.h>

class OrbitalInfo : public TObject {
 public:
  OrbitalInfo();
  OrbitalInfo* GetOrbitalInfo(){return this;}; // Elena

  UInt_t absTime; //< Absolute Time
  // EM: added On Board Time and CPU Packet Number
  UInt_t OBT; //< On Board Time
  UInt_t pkt_num; //< CPU packet number

  // Position
  Float_t lon; // degrees from -180 to 180
  Float_t lat; // degrees from -90 to 90
  Float_t alt; // meters

  // Magnetic field

  // components (gauss)
  Float_t Bnorth;
  Float_t Beast;
  Float_t Bdown;

  // abs value (guass)
  Float_t Babs;

  // Minimum along the field line (that is at the magnetic equator)
  Float_t BB0;

  // L shell (in earth radii)
  Float_t L; 

  // Dipolar magnetic coordinates
  Float_t londip; // degrees from -180 to 180
  Float_t latdip; // degrees from -90 to 90
  Float_t altdip; // meters

  // Corrected magnetic coordinates
  Float_t loncgm; // degrees from -180 to 180
  Float_t latcgm; // degrees from -90 to 90
  Float_t altcgm; // meters

  // Corrected B min magnetic coordinates
  Float_t loncbm; // degrees from -180 to 180
  Float_t latcbm; // degrees from -90 to 90
  Float_t altcbm; // meters

  Float_t cutoff[20];

  // Quaternions
  Float_t q0, q1, q2, q3;

  // Euler angles (nadir reference frame)
  Float_t theta, phi, etha;

  // Euler angles (local field reference frame)
  Float_t thetamag, phimag, ethamag;

  // Useful?
  Int_t goodAttitude[5];

  Float_t GetB0() { return Babs/BB0; };

  // Stormer vertical cutoff using L shell: 14.9/L^2 (GeV).
  Float_t GetCutoffSVL() { return cutoff[0]; };

  void SetFromLevel2Struct(cOrbitalInfo *l2);
  void GetLevel2Struct(cOrbitalInfo *l2) const;

  void Clear(); // emiliano
  //
  ClassDef(OrbitalInfo, 2)
};
#endif
