#ifndef OrbitalInfoCore_h
#define ObitalInfoCore_h
#include <TSQLServer.h>
#include <TTimeStamp.h>
#include <InclinationInfo.h>
#include <OrientationInfo.h>
#include <ToFLevel2.h>

#include <sgp4.h>

extern "C" {
#include <dirent.h>
    extern void initize_(Char_t *,Int_t *,Char_t *,Int_t *,char *,Int_t *); 
    extern void feldcof_(Float_t *, Double_t *);
    extern void feldg_(Float_t *, Float_t *, Float_t *, Float_t *, Float_t *, Float_t *, Float_t *);
    extern void shellg_(Float_t *, Float_t *, Float_t *, Double_t *, Float_t *, Float_t *, Float_t *);
    extern void findb0_(Float_t *, Float_t *, Bool_t *, Float_t *, Float_t *);

/*     //INITIZE(YEAR,DIMO) */
/*     extern void initize_(char[], int*, char[], int*, char[], int*); */
/*     //FELDCOF(YEAR,DIMO) */
/*     extern void feldcof_(float*, float*); */
/*     //FELDG(LATI,LONGI,HEIGHT,BNORTH,BEAST,BDOWN,BABS) */
/*     extern void feldg_(float*, float*, float*, float*, float*, float*, float*); */
/*     //SHELLG(LATI,LONGI,HEIGHT,DIMO,XL,ICODE,BAB1) */
/*     extern void shellg_(float*, float*, float*, float*, float*, float*, float*); */
/*     //FINDB0(STPS,BDEL,VALUE,BEQU,RR0) */
/*     extern void findb0_(float*, float*, bool*, float*, float*); */
}

/*
struct Sine{
  Double_t A;
  Double_t b;
  Double_t c;
  Double_t startPoint;
  Double_t finishPoint;
  Bool_t NeedFit;
};
*/

  // Parameters to calculate geomagnetic coordinates

Int_t GM_STARTYEAR = 1900;

typedef struct {
			int Day;
			int Month;
			int Year;
			double DecimalYear;
			int DayNumber;
			} GMtype_Date;

typedef struct {
			double lambda;// longitude
			double phi; // geodetic latitude
			double HeightAboveEllipsoid; // height above the ellipsoid (HaE)
			} GMtype_CoordGeodetic;

typedef struct {
			double r; //radial distance
			double phig; //latitude
			double lambda; //longitude
			} GMtype_CoordSpherical;
typedef struct {
			double lambda;
			double phi;
			} GMtype_CoordDipole;

typedef struct {
			double x;
			double y;
			double z;
			} GMtype_CoordCartesian;

typedef struct {
			double a; /*semi-major axis of the ellipsoid*/
			double b; /*semi-minor axis of the ellipsoid*/
			double fla; /* flattening */
			double epssq; /*first eccentricity squared */
			double eps; /* first eccentricity */
			double re;/* mean radius of  ellipsoid*/
			} GMtype_Ellipsoid;

typedef struct {
			int degree;
			double coef[30];
			} GMtype_Polynomial;

typedef struct {
			double h1;
			double g1;
			double g0;
			} GMtype_Model;

typedef struct {
			double M; /*Magnetic Moment*/
			double phi;
			double lambda;
			} GMtype_Pole;

typedef struct{
			int size;
			double element[30];
			} GMtype_Data;


extern int OrbitalInfoCore(UInt_t run, TFile *file, GL_TABLES *glt, Int_t orbitalargc, char *orbitalargv[]);
cCoordGeo getCoo(UInt_t atime, UInt_t tletime, cTle *tle);
void CopyQ(Quaternions *Q1, Quaternions *Q2);
void CopyAng(InclinationInfo *A1, InclinationInfo *A2);
UInt_t holeq(Double_t lower,Double_t upper,Quaternions *Qlower, Quaternions *Qupper, UInt_t f);
void inclresize(vector<Double_t>&, vector<Float_t>&, vector<Float_t>&, vector<Float_t>&, vector<Float_t>&, vector<Int_t>&, vector<Float_t>&, vector<Float_t>&, vector<Float_t>&);
//void sineparam(vector<Sine>&, vector<Double_t>&, vector<Float_t>&, vector<Float_t>&, vector<Float_t>&, Float_t);
//void GM_ScanIGRF(TString PATH, GMtype_Data *G0, GMtype_Data *G1, GMtype_Data *H1);
void GM_ScanIGRF(TSQLServer *dbc, GMtype_Data *G0, GMtype_Data *G1, GMtype_Data *H1);
void GM_SetEllipsoid(GMtype_Ellipsoid *Ellip);
void GM_GeodeticToSpherical(GMtype_Ellipsoid Ellip, GMtype_CoordGeodetic CoordGeodetic, GMtype_CoordSpherical *CoordSpherical);
void GM_SphericalToCartesian(GMtype_CoordSpherical CoordSpherical, GMtype_CoordCartesian *CoordCartesian);
void GM_TimeAdjustCoefs(Float_t year, Float_t jyear, GMtype_Data g0d, GMtype_Data g1d, GMtype_Data h1d, GMtype_Model *Model);
void GM_PoleLocation(GMtype_Model Model, GMtype_Pole *Pole);
void GM_EarthCartToDipoleCartCD(GMtype_Pole Pole, GMtype_CoordCartesian EarthCoord, GMtype_CoordCartesian *DipoleCoords);
void GM_CartesianToSpherical(GMtype_CoordCartesian CoordCartesian, GMtype_CoordSpherical *CoordSpherical);
double GM_LinearInterpolation(double x1, double x2, double y1, double y2, double x);

#endif
