#ifndef OrbitalInfo_h
#define OrbitalInfo_h

#include <TObject.h>
#include <algorithm> // EMILIANO
#include <OrbitalInfoStruct.h>
#include <TClonesArray.h>
#include <TMatrixD.h>

class OrbitalInfoTrkVar : public TObject {
 private:

 public:
    //
    Int_t trkseqno; // tof sequ. number: -1=ToF standalone, 0=first Tracker track, ...
    //
    Float_t pitch; ///< Pitch angle
    //
    TMatrixD Eij; ///< vector of incoming particle respect to cartesian geographic coordinates
    TMatrixD Sij; ///< vector of incoming particle respect to flight coordinates
    //
    Float_t cutoff; ///< Calculated cutoff for the incoming particle taking into account particle direction
    //  
    OrbitalInfoTrkVar();
    OrbitalInfoTrkVar(const OrbitalInfoTrkVar&);
    OrbitalInfoTrkVar* GetOrbitalInfoTrkVar(){return this;};
    //
    void Clear(Option_t *t=""); 
    void Delete(Option_t *t=""); //ELENA
    //
    ClassDef(OrbitalInfoTrkVar, 3);
    //
};
	


/**
 * Class that stores position, time, inclination, magnetic field and
 * cutoff informations.
 */
class OrbitalInfo : public TObject {
 private:

 public:
  TClonesArray *OrbitalInfoTrk;

  UInt_t absTime; ///< Absolute Time (seconds) 
  UInt_t OBT; ///< On Board Time (ms)
  UInt_t pkt_num; ///< CPU packet number 

  Float_t lon; ///< degrees from -180 to 180
  Float_t lat; ///< degrees from -90 to 90
  Float_t alt; ///< meters asl

  // B components.
  Float_t Bnorth; ///< gauss
  Float_t Beast; ///< gauss
  Float_t Bdown; ///< gauss

  Float_t Babs; ///< abs value (guass)

  Float_t BB0; ///< B abs over the B minimum on this field line

  Float_t L; ///< McIlwain's L shell (in earth radii)

/*   // Dipolar magnetic coordinates (not used). */
/*   Float_t londip; ///< degrees from -180 to 180 */
/*   Float_t latdip; ///< degrees from -90 to 90 */
/*   Float_t altdip; ///< meters */

/*   // Corrected magnetic coordinates (not used). */
/*   Float_t loncgm; ///< degrees from -180 to 180 */
/*   Float_t latcgm; ///< degrees from -90 to 90 */
/*   Float_t altcgm; ///< meters */

/*   // Corrected B min magnetic coordinates (not used). */
/*   Float_t loncbm; ///< degrees from -180 to 180 */
/*   Float_t latcbm; ///< degrees from -90 to 90 */
/*   Float_t altcbm; ///< meters */

     //  Float_t cutoff[17];
  Float_t cutoffsvl;

  // linear Quaternions 
  Float_t q0; ///< Quaternion 0
  Float_t q1; ///< Quaternion 1
  Float_t q2; ///< Quaternion 2
  Float_t q3; ///< Quaternion 3
  
  //tested sine quaternions
  
  //Float_t q0t;
  //Float_t q1t;
  //Float_t q2t;
  //Float_t q3t;

  // Euler angles (Resurs velocity reference frame) 
  Float_t theta; ///< Euler angle theta in the velocity reference frame (pitch)
  Float_t phi; ///< Euler angle phi in the velocity reference frame (yaw)
  Float_t etha; ///< Euler angle etha in the velocity reference frame (roll)

  // Pitch angles 
      //  Float_t pamzenitangle;
      //  Float_t pamBangle;
  //
  TMatrixD Iij; ///< Angle between PAMELA Z direction and cartesian geographic coordinates

  /**
   * The variable mode means a character time distant between two quaternions, inside which stay every events  
   */
  Int_t mode;   // 0  - means that time different pair of quaternions exuals to 0.25 seconds in R10 mode
		//      (it mean that all quaternions in array is correct)
  		// 1  - means that we have R10 mode and use just first value of quaternions array
		// 2  - means that we have non R10 mode and use every quaternions from array.
		// 3  - means normal transition from R10 to non R10 or from non R10 to R10.
		// 4  - means that we have eliminable hole between R10 and non R10 or between non R10 and R10
		// 5  - means that we have uneliminable hole between R10 and non R10 or between non R10 and R10
		// 6  - means that we have eliminable hole inside R10 (in such keys eliminable depends from other factors also)
		// 7  - means that we have uneliminable hole inside R10
		// 8  - means that we have eliminable hole inside non R10
		// 9  - means that we have uneliminable hole inside non R10
  		// 10 - means other unknown problems
		// -10 - means we use recovered quaternions
  
  //Int_t R10f;	//if 1 we recognize R10 mode using flight data if 0 - no R10 mode if -1 we know nothing about R10 mode
  //Bool_t R10r;	//if true we recognize R10 mode using recovered data
  
  Float_t TimeGap; //Time gap between two points where interpolation have done.
  
  Int_t ntrk(){return OrbitalInfoTrk->GetEntries();};
  /**
     \return Returns the B minimum along the field line.
  */
  Float_t GetB0() { return Babs/BB0; };

  /**
     \return Returns the Stormer vertical cutoff using L shell:
     14.9/L^2 (GV/c).
  */
  Float_t GetCutoffSVL() { return cutoffsvl; };

  void SetFromLevel2Struct(cOrbitalInfo *l2);
  void GetLevel2Struct(cOrbitalInfo *l2) const;
  OrbitalInfoTrkVar *GetOrbitalInfoTrkVar(Int_t notrack);
  //
  OrbitalInfo();
  ~OrbitalInfo(){Delete();}; //ELENA
  //
  OrbitalInfo* GetOrbitalInfo(){return this;}; // Elena
  void Delete(Option_t *t=""); //ELENA
  void Set();//ELENA
  //
  //

  void Clear(Option_t *t=""); // emiliano
  //
  ClassDef(OrbitalInfo, 8);
};
#endif
