#ifndef OrbitalInfoCore_h
#define ObitalInfoCore_h
#include <TSQLServer.h>
#include <TTimeStamp.h>
#include <InclinationInfo.h>
#include <OrientationInfo.h>
#include <ToFLevel2.h>

#include <sgp4.h>

extern "C" {
#include <dirent.h>
  //INITIZE(YEAR,DIMO)
  extern void initize_(char[], int*, char[], int*, char[], int*);
  //FELDCOF(YEAR,DIMO)
  extern void feldcof_(float*, float*);
  //FELDG(LATI,LONGI,HEIGHT,BNORTH,BEAST,BDOWN,BABS)
  extern void feldg_(float*, float*, float*, float*, float*, float*, float*);
  //SHELLG(LATI,LONGI,HEIGHT,DIMO,XL,ICODE,BAB1)
  extern void shellg_(float*, float*, float*, float*, float*, float*, float*);
  //FINDB0(STPS,BDEL,VALUE,BEQU,RR0)
  extern void findb0_(float*, float*, bool*, float*, float*);
}


extern int OrbitalInfoCore(UInt_t run, TFile *file, GL_TABLES *glt, Int_t orbitalargc, char *orbitalargv[]);
cCoordGeo getCoo(UInt_t atime, UInt_t tletime, cTle *tle);
void CopyQ(Quaternions *Q1, Quaternions *Q2);
void CopyAng(InclinationInfo *A1, InclinationInfo *A2);
UInt_t holeq(Double_t lower,Double_t upper,Quaternions *Qlower, Quaternions *Qupper, UInt_t f);

#endif
