#include <OrbitalInfo.h>

OrbitalInfo::OrbitalInfo(){
  absTime = 0;
  OBT = 0;
  pkt_num = 0;
}


void OrbitalInfo::Clear(){
  absTime = 0;
  OBT = 0;
  pkt_num = 0;
}

/**
 * Fills a struct cOrbitalInfo with values from a OrbitalInfo object (to put data into a F77 common).
 */
void OrbitalInfo::GetLevel2Struct(cOrbitalInfo *l2) const{
  l2->abstime  = absTime;
  l2->obt      = OBT;
  l2->pkt_num  = pkt_num;
}

void OrbitalInfo::SetFromLevel2Struct(cOrbitalInfo *l2){
  absTime  = l2->abstime;
  OBT      = l2->obt;
  pkt_num  = l2->pkt_num;
}

ClassImp(OrbitalInfo)
 
