#ifndef OrbitalInfo_h
#define OrbitalInfo_h

#include <TObject.h>
#include <algorithm> // EMILIANO
#include <OrbitalInfoStruct.h>
#include <TClonesArray.h>
#include <TMatrixD.h>
#include <TVector3.h>
#include <string.h>//ELENA

class OrbitalInfoTrkVar : public TObject {
 private:

 public:
    //
    Int_t trkseqno; // tof sequ. number: -1=ToF standalone, 0=first Tracker track, ...
    //
    Float_t pitch; ///< Pitch angle
    Float_t sunangle;
    Float_t sunmagangle;
    //
    TMatrixD Eij; ///< vector of incoming particle respect to cartesian geographic coordinates
    TMatrixD Sij; ///< vector of incoming particle respect to flight coordinates
    //
    Float_t cutoff; ///< Calculated cutoff for the incoming particle taking into account particle direction
    //  
    OrbitalInfoTrkVar();
    OrbitalInfoTrkVar(const OrbitalInfoTrkVar&);
    OrbitalInfoTrkVar* GetOrbitalInfoTrkVar(){return this;};
    //
    void Clear(Option_t *t=""); 
    void Delete(Option_t *t=""); //ELENA
    //
    ClassDef(OrbitalInfoTrkVar, 4);
    //
};
	


/**
 * Class that stores position, time, inclination, magnetic field and
 * cutoff informations.
 */
class OrbitalInfo : public TObject {
 private:

 public:
  TClonesArray *OrbitalInfoTrk;

  UInt_t absTime; ///< Absolute Time (seconds) 
  UInt_t OBT; ///< On Board Time (ms)
  UInt_t pkt_num; ///< CPU packet number 

  Float_t lon; ///< degrees from -180 to 180
  Float_t lat; ///< degrees from -90 to 90
  Float_t alt; ///< meters asl

  TVector3 V;  /// velocity

  // B components.
  Float_t Bnorth; ///< gauss
  Float_t Beast; ///< gauss
  Float_t Bdown; ///< gauss

  Float_t Babs; ///< abs value (guass)

  Float_t M;   ///< M

  Float_t BB0; ///< B abs over the B minimum on this field line

  Float_t L; ///< McIlwain's L shell (in earth radii)

/*   // Dipolar magnetic coordinates. */
   Float_t londip; ///< degrees from -180 to 180 
   Float_t latdip; ///< degrees from -90 to 90 

     //  Float_t cutoff[17];
  Float_t cutoffsvl;
  Float_t igrf_icode;

  // linear Quaternions 
  Float_t q0; ///< Quaternion 0
  Float_t q1; ///< Quaternion 1
  Float_t q2; ///< Quaternion 2
  Float_t q3; ///< Quaternion 3

  // Euler angles (Resurs velocity reference frame) 
  Float_t theta; ///< Euler angle theta in the velocity reference frame (pitch)
  Float_t phi; ///< Euler angle phi in the velocity reference frame (yaw)
  Float_t etha; ///< Euler angle etha in the velocity reference frame (roll)

  // Pitch angles 

  //
  TMatrixD Iij; ///< Angle between PAMELA Z direction and cartesian geographic coordinates

  /**
   * The variable mode means a character time distant between two quaternions, inside which stay every events  
   */
  Int_t mode;   // 0  - means that time different pair of quaternions exuals to 0.25 seconds in R10 mode
		//      (it mean that all quaternions in array is correct)
  		// 1  - means that we have R10 mode and use just first value of quaternions array
		// 2  - means that we have non R10 mode and use every quaternions from array.
		// 3  - means normal transition from R10 to non R10 or from non R10 to R10.
		// 4  - means that we have eliminable hole between R10 and non R10 or between non R10 and R10
		// 5  - means that we have uneliminable hole between R10 and non R10 or between non R10 and R10
		// 6  - means that we have eliminable hole inside R10 (in such keys eliminable depends from other factors also)
		// 7  - means that we have uneliminable hole inside R10
		// 8  - means that we have eliminable hole inside non R10
		// 9  - means that we have uneliminable hole inside non R10
  		// 10 - means other unknown problems
		// -10 - means we use recovered quaternions
  
  Int_t qkind; 	// How matrix Qij was got.
		// 0 means that it was calculated from flight quaternion
		// 1 means that it was calculated from Euler angles from Rotation Table
  
  Float_t TimeGap; //Time gap between two points where interpolation have done.

  Int_t errq;	// flag, if errq == 1 then real flight quaternion (not interpolated) incorrect
  Int_t azim;	// 0 - means everything is ok
		// 1 - means azimutal rotations were performed in this moment and in case of absense of flight quaternions orientation calculated here incorrect
		// >1 - No flight quaternions, no azimuthal rotations, no adequate data from RotationTable, unaccuracy equals to Bank angle of rotetion in this moment
		// -1 - Very Strange flight data, I don't know how to understand them

  Int_t rtqual; // 0 - means orientation data for period whe this event registered is in agreement with fligh orioentation data, one can fully trust such event when it calculated using Rotation Table (qkind=1)
                // 1 - means orientation data was not compared with flight data (during of absence of them), one should check them somehow
                // 2 - means orientation data calculated with flight data has disagreement with rotation table data and thre were not enough of flight data to correct RT.
  
  Int_t ntrk(){return OrbitalInfoTrk->GetEntries();};
  /**
     \return Returns the B minimum along the field line.
  */
  Float_t GetB0() { return Babs/BB0; };

  /**
     \return Returns the Stormer vertical cutoff using L shell:
     14.9/L^2 (GV/c).
  */
  Float_t GetCutoffSVL() { return cutoffsvl; };

  void SetFromLevel2Struct(cOrbitalInfo *l2);
  void GetLevel2Struct(cOrbitalInfo *l2) const;
  OrbitalInfoTrkVar *GetOrbitalInfoTrkVar(Int_t notrack);
  OrbitalInfoTrkVar * GetOrbitalInfoStoredTrack(Int_t seqno);///< returns pointer to the track set related to the seqno number

  //
  OrbitalInfo();
  ~OrbitalInfo(){Delete();}; //ELENA
  //
  OrbitalInfo* GetOrbitalInfo(){return this;}; // Elena
  void Delete(Option_t *t=""); //ELENA
  void Set();//ELENA
  //
  //
  TClonesArray *GetTrackArray(){return OrbitalInfoTrk;} ///< returns a pointer to the track related variables array
  TClonesArray** GetPointerToTrackArray(){return &OrbitalInfoTrk;}///< returns pointer to pointer to the track array
  void SetTrackArray(TClonesArray *track);///<set pointer to the track array

  void Clear(Option_t *t=""); // emiliano
  //
  ClassDef(OrbitalInfo, 12);
};
#endif
