/**
 * \file src/NDLevel2.cpp
 *
**/
#include <NDLevel2.h>

/**
 * NDLevel2 constructor
**/
NDLevel2::NDLevel2(){
  this->Clear();
}
/**
 * Clear variables
**/
void NDLevel2::Clear(Option_t *t){
  upperBack = 0.;
  bottomBack = 0.;
  trigPhysics = 0.;
  unpackError = 0;
}
/**
 * Fills a struct cNDLevel2 with values from a NDLevel2 object (to put data into a F77 common).
 */
void NDLevel2::GetLevel2Struct(cNDLevel2 *l2) const{
  l2->upperback   = upperBack;
  l2->bottomback  = bottomBack;
  l2->trigphysics = trigPhysics;
}

/**
 * Fills a NDLevel2 object with values from a struct cNDLevel2.
 */
void NDLevel2::SetFromLevel2Struct(cNDLevel2 *l2){
  upperBack   = l2->upperback;
  bottomBack  = l2->bottomback;
  trigPhysics = l2->trigphysics;
}

ClassImp(NDLevel2)
