//
// C/C++ headers
//
#include <fstream>
#include <string.h>
#include <iostream>
#include <cstring>
#include <stdio.h>
//
// ROOT headers
//
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TArrayI.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
#include <TClonesArray.h>
#include <stdlib.h>
#include <math.h>
//
// YODA headers
//
#include <PamelaRun.h>
#include <PscuHeader.h>
#include <PscuEvent.h>
#include <EventHeader.h>
#include <physics/neutronDetector/NeutronEvent.h>
#include <physics/neutronDetector/NeutronRecord.h>
//#include <yodaUtility.h>
//
// RunInfo header
//
#include <RunInfo.h>
#include <GLTables.h>
//
// This program headers
//
#include <NDLevel2.h>
#include <NDCore.h>
#include <NDVerl2.h>

using namespace std;

//
// CORE ROUTINE
//
//
int NDCore(UInt_t run, TFile *file, TSQLServer *dbc, Int_t NDargc, char *NDargv[]){
  //  
  Int_t i = 0;
  //
  TString processFolder = "NDFolder";
  //
  // Set these to true to have a very verbose output.
  //
  Bool_t debug = false;
  //
  Bool_t verbose = false;
  //
  if ( NDargc > 0 ){
    i = 0;
    while ( i < NDargc ){
      if ( !strcmp(NDargv[i],"-processFolder") ) {
	if ( NDargc < i+1 ){
	  throw -3;
	};
	processFolder = (TString)NDargv[i+1];
	i++;
      };
      if ( (!strcmp(NDargv[i],"--verbose")) || (!strcmp(NDargv[i],"-v")) ) {
	verbose = true;
      };
      if ( (!strcmp(NDargv[i],"--debug")) || (!strcmp(NDargv[i],"-g")) ) {
        verbose= true;
      };
      i++;
    };
  };
  //
  const char* outDir = gSystem->DirName(gSystem->DirName(file->GetPath()));
  // Variables for level2 
  //
  TTree *NDtr = 0;
  UInt_t nevents = 0;
  //
  // variables needed to reprocess data
  //
  TString NDversion;
  ItoRunInfo *runinfo = 0;
  TArrayI *runlist = 0;
  TTree *NDtrclone = 0;
  Bool_t reproc = false;
  Bool_t reprocall = false;
  UInt_t nobefrun = 0;
  UInt_t noaftrun = 0;
  UInt_t numbofrun = 0;
  stringstream ftmpname;
  TString fname;
  UInt_t totfileentries = 0;
  UInt_t idRun = 0;
  Int_t tmpSize =0;
  Float_t yTrig =0;
  Float_t yUpperBackground =0;
  Float_t yBottomBackground =0;
  //
  // variables needed to handle error signals
  //
  Int_t code = 0;
  Int_t sgnl;
  //
  // ND level2 classes
  //
  NDLevel2 *nd = new NDLevel2();
  NDLevel2 *ndclone = new NDLevel2();
  //
  // define variables for opening and reading level0 file
  //
  TFile *l0File = 0;
  TTree *l0tr = 0;
  TBranch *l0head = 0;
  TBranch *l0ND =0;
  pamela::EventHeader *eh = 0;
  pamela::PscuHeader *ph = 0;
  pamela::neutron::NeutronRecord *l0nr = 0;
  pamela::neutron::NeutronEvent  *l0ne = 0;
  //
  // Define other basic variables
  // 
  UInt_t procev = 0;
  stringstream file2;
  stringstream file3;
  stringstream qy;
  Int_t totevent = 0;
  UInt_t atime = 0;
  UInt_t re = 0;
  //
  // Working filename
  //
  TString outputfile;
  stringstream name;
  name.str("");
  name << outDir << "/";
  //
  // temporary file and folder
  //
  TFile *tempfile = 0;
  TTree *tempND = 0;
  stringstream tempname;
  stringstream NDfolder;
  tempname.str("");
  tempname << outDir;
  tempname << "/" << processFolder.Data();
  NDfolder.str("");
  NDfolder << tempname.str().c_str();
  gSystem->MakeDirectory(NDfolder.str().c_str());
  tempname << "/NDtree_run";
  tempname << run << ".root";  
  //
  // DB classes
  //
  GL_ROOT *glroot = new GL_ROOT();
  GL_TIMESYNC *dbtime = 0;
  //
  // Let's start!
  //
  // As a first thing we must check what we have to do: if run = 0 we must process all events in the file has been passed
  // if run != 0 we must process only that run but first we have to check if the tree MyDetector2 already exist in the file
  // if it exists we are reprocessing data and we must delete that entries, if not we must create it.
  // 
  if ( run == 0 )  reproc = true;
  //
  //
  // Output file is "outputfile"
  //
  if ( !file->IsOpen() ){
    //printf(" ND - ERROR: cannot open file for writing\n");
    throw -601 ;    
  };
  //
  // Retrieve GL_RUN variables from the level2 file
  //  
  NDversion = NDInfo(false); // we should decide how to handle versioning system
  //
  // create an interface to RunInfo called "runinfo"
  //
  runinfo = new ItoRunInfo(file);
  //
  // open "Run" tree in level2 file, if not existing return an error (sngl != 0)
  //
  sgnl = 0;
  sgnl = runinfo->Update(run, "ND",NDversion);
  if ( sgnl ){
    if ( debug ) printf(" ND - ERROR: RunInfo exited with non-zero status\n");
    code = sgnl;
    goto closeandexit;
  } else {
    sgnl = 0;
  };
  //
  // number of events in the file BEFORE the first event of our run
  //
  nobefrun = runinfo->GetFirstEntry();
  //
  // total number of events in the file 
  //
  totfileentries = runinfo->GetFileEntries();
  //
  // first file entry AFTER the last event of our run
  //
  noaftrun = runinfo->GetLastEntry() + 1;
  //
  // number of run to be processed
  //
  numbofrun = runinfo->GetNoRun();
  //
  // Try to access the S4 tree in the file, if it exists we are reprocessing data if not we are processing a new run
  //
  NDtrclone = (TTree*)file->Get("NeutronD");
  //
  if ( !NDtrclone ){
    //
    // tree does not exist, we are not reprocessing
    //
    reproc = false;
    if ( run == 0 ) {
      if (verbose) printf(" ND - WARNING: you are reprocessing data but ND tree does not exist!\n");
    }
    if ( runinfo->IsReprocessing() && run != 0 ) {
      if (verbose) printf(" ND - WARNING: it seems you are not reprocessing data but ND\n versioning information already exists in RunInfo.\n");
    }
  } else {
    //
    // tree exists, we are reprocessing data. Are we reprocessing a single run or all the file?
    //
    reproc = true;
    //
    // update versioning information 
    //
    if (verbose) printf("\n Preparing the pre-processing...\n");
    //
    if ( run == 0 ){
      //
      // we are reprocessing all the file
      // if we are reprocessing everything we don't need to copy any old event and we can just work with the new tree and delete the old one immediately
      //
      reprocall = true;
      //
      if (verbose) printf("\n ND - WARNING: Reprocessing all runs\n");
      //
    } else {
      //
      // we are reprocessing a single run, we must copy to the new tree the events in the file which preceed the first event of the run
      //
      reprocall = false;
      //
      if (verbose) printf("\n ND - WARNING: Reprocessing run number %u \n",run);
      //
      // copying old tree to a new file
      //
      tempfile = new TFile(tempname.str().c_str(),"RECREATE");
      tempND = NDtrclone->CloneTree(-1,"fast");
      tempND->SetName("NeutronD-old"); 
      tempfile->Write();
      tempfile->Close();  
    }
    //
    // Delete the old tree from old file and memory
    //
    NDtrclone->Delete("all");
    //
    if (verbose) printf(" ...done!\n");
    //
  };
  //
  // create mydetector tree mydect
  // 
  file->cd();
  NDtr = new TTree("NeutronD-new","PAMELA Level2 NeutronD data");
  NDtr->Branch("NDLevel2","NDLevel2",&nd);
  //
  if ( reproc && !reprocall ){
    //
    //  open new file and retrieve also tree informations
    //
    tempfile = new TFile(tempname.str().c_str(),"READ");
    NDtrclone = (TTree*)tempfile->Get("NeutronD-old");
    NDtrclone->SetBranchAddress("NDLevel2",&ndclone);
    //      
    if ( nobefrun > 0 ){
      if (verbose) {
	printf("\n Pre-processing: copying events from the old tree before the processed run\n");   
	printf(" Copying %u events in the file which are before the beginning of the run %u \n",nobefrun,run);
	printf(" Start copying at event number 0, end copying at event number %u \n",nobefrun);
      }
      for (UInt_t j = 0; j < nobefrun; j++){
	//
	NDtrclone->GetEntry(j);	  
	//
	// copy ndclone to mydec
	//
	//	nd = new NDLevel2();
	nd->Clear();
	memcpy(&nd,&ndclone,sizeof(ndclone));
	//
	// Fill entry in the new tree
	//
	NDtr->Fill();
	//
      };
      if (verbose) printf(" Finished successful copying!\n");
    };          
  };
  //
  // Get the list of run to be processed, if only one run has to be processed the list will contain one entry only.
  //
  runlist = runinfo->GetRunList();
  //
  // Loop over the run to be processed
  //
  for (UInt_t irun=0; irun < numbofrun; irun++){
    //
    // retrieve the first run ID to be processed using the RunInfo list
    //
    idRun = runlist->At(irun);
    if (verbose) {
      printf("\n\n\n ####################################################################### \n");
      printf("                    PROCESSING RUN NUMBER %u \n",idRun);
      printf(" ####################################################################### \n\n\n");
    }
    //
    runinfo->ID_ROOT_L0 = 0;
    //
    // store in the runinfo class the GL_RUN variables for our run
    //
    sgnl = 0;
    sgnl = runinfo->GetRunInfo(idRun);
    if ( sgnl ){
      if ( debug ) printf(" ND - ERROR: RunInfo exited with non-zero status\n");
      code = sgnl;
      goto closeandexit;
    } else {
      sgnl = 0;
    };
    //
    // now you can access that variables using the RunInfo class this way runinfo->ID_ROOT_L0
    //
    if ( runinfo->ID_ROOT_L0 == 0 ){
      if ( debug ) printf("\n ND - ERROR: no run with ID_RUN = %u \n\n Exiting... \n\n",idRun);
      code = -5;
      goto closeandexit;    
    };
    //
    // prepare the timesync for the db
    //
    dbtime = new GL_TIMESYNC(runinfo->ID_ROOT_L0,"ID",dbc);
    //
    // Search in the DB the path and name of the LEVEL0 file to be processed.
    //
    glroot->Query_GL_ROOT(runinfo->ID_ROOT_L0,dbc);
    //
    ftmpname.str("");
    ftmpname << glroot->PATH.Data() << "/";
    ftmpname << glroot->NAME.Data();
    fname = ftmpname.str().c_str();
    //
    // print out informations
    //
    totevent = runinfo->NEVENTS;
    if (verbose) {
      printf("\n LEVEL0 data file: %s \n",fname.Data());
      printf(" RUN HEADER absolute time is:  %u \n",runinfo->RUNHEADER_TIME);
      printf(" RUN TRAILER absolute time is: %u \n",runinfo->RUNTRAILER_TIME);
      printf(" %i events to be processed for run %u: from %i to %i \n\n",totevent,idRun,runinfo->EV_FROM,runinfo->EV_FROM+totevent);
    }
    //
    // Open Level0 file
    //
    l0File = new TFile(fname.Data());
    if ( !l0File ) {
      if ( debug ) printf(" ND - ERROR: problems opening  Level0 file\n");
      code = -6;
      goto closeandexit;
    };
    l0tr = (TTree*)l0File->Get("Physics");
    if ( !l0tr ) {
      if ( debug ) printf(" ND - ERROR: no Physics tree in Level0 file\n");
      l0File->Close();
      code = -7;
      goto closeandexit;
    };
    l0head = l0tr->GetBranch("Header");
    if ( !l0head ) {
      if ( debug ) printf(" ND - ERROR: no Header branch in Level0 tree\n");
      l0File->Close();
      code = -8;
      goto closeandexit;    
    };
    l0ND = l0tr->GetBranch("Neutron");
    if ( !l0ND ) {
      if ( debug ) printf(" ND - ERROR: no ND branch in Level0 tree\n");
      l0File->Close();
      code = -603;
      goto closeandexit;
    };

    //
    l0tr->SetBranchAddress("Neutron", &l0ne);
    l0tr->SetBranchAddress("Header", &eh); 
    //
    nevents = l0ND->GetEntries();
    //
    if ( nevents < 1 ) {
      if ( debug ) printf(" ND - ERROR: Level0 file is empty\n\n");
      l0File->Close();
      code = -11;
      goto closeandexit;
    };
    //
    if ( runinfo->EV_TO > nevents-1 ) {
      if ( debug ) printf(" ND - ERROR: too few entries in the tree\n");
      l0File->Close();
      code = -12;
      goto closeandexit;
    };
    //
    // run over all the events of the run
    //
    if (verbose) printf("\n Ready to start! \n\n Processed events: \n\n");
    //
    for ( re = runinfo->EV_FROM; re < (runinfo->EV_FROM+runinfo->NEVENTS); re++){
      //
      if ( procev%1000 == 0 && procev > 0 && verbose ) printf(" %iK \n",procev/1000);	
      //
      l0head->GetEntry(re);
      //
      // absolute time of this event
      //
      ph = eh->GetPscuHeader();
      atime = dbtime->DBabsTime(ph->GetOrbitalTime());  
      //
      // paranoid check
      //
      if ( (atime > runinfo->RUNTRAILER_TIME) || (atime < runinfo->RUNHEADER_TIME)  ) {
	if (verbose) printf(" ND - WARNING: event at time outside the run time window, skipping it\n");
	goto jumpev;
      };
      //
      procev++;
      //
      // start processing
      //
      nd->Clear();
      //
      l0ND->GetEntry(re);
      tmpSize = l0ne->Records->GetEntries();
      if ( tmpSize && l0ne->unpackError == 0 ){
	for (Int_t j = 0; j < tmpSize; j++){
	  l0nr = (pamela::neutron::NeutronRecord*)l0ne->Records->At(j);
	  yTrig            = yTrig             + (float)l0nr->trigPhysics;
	  yUpperBackground  = yUpperBackground  + (float)l0nr->upperBack;
	  yBottomBackground = yBottomBackground + (float)l0nr->bottomBack;
	}
	nd->upperBack = yUpperBackground;
	nd->bottomBack = yBottomBackground;
	nd->trigPhysics = yTrig;	     
      };
      //
      //
      NDtr->Fill();        // Fill tree NDLevel2 in the root file
      //
      yUpperBackground =0;
      yBottomBackground =0;
      yTrig=0;	     
      //    
      //
    jumpev:
      debug = false;
      //
    };
    //
    // Here you may want to clear some variables before processing another run  
    //
    delete dbtime;
  }; // process all the runs
  //
  if (verbose) printf("\n Finished processing data \n");
  //
 closeandexit:
  //
  // we have finished processing the run(s). If we processed a single run now we must copy all the events after our run from the old tree to the new one and delete the old tree.
  //
  if ( !reprocall && reproc && code >= 0 ){
    if ( totfileentries > noaftrun ){
      if (verbose) {
      printf("\n Post-processing: copying events from the old tree after the processed run\n");   
      printf(" Copying %i events in the file which are after the end of the run %i \n",(int)(totfileentries-noaftrun),(int)run);
      printf(" Start copying at event number %i end copying at event number %i \n",(int)noaftrun,(int)totfileentries);
      }
      for (UInt_t j = noaftrun; j < totfileentries; j++ ){
	//
	// Get entry from old tree
	//
	NDtrclone->GetEntry(j);	  
	//
	// copy ndclone to nd
	//
	nd->Clear();
	memcpy(&nd,&ndclone,sizeof(ndclone));
	//
	// Fill entry in the new tree
	//
	NDtr->Fill();
      };
      if (verbose) printf(" Finished successful copying!\n");
    };
  };
  //
  // Close files, delete old tree(s), write and close level2 file 
  //
  if ( l0File ) l0File->Close();
  if ( tempfile ) tempfile->Close();            
  gSystem->Unlink(tempname.str().c_str());
  //
  if ( runinfo ) runinfo->Close();    
  if ( NDtr ) NDtr->SetName("NeutronD");    
  if ( file ){
    file->cd();
    file->Write();
  };
  //
  gSystem->Unlink(NDfolder.str().c_str());
  //
  // the end
  //
  if ( verbose ) printf("\n Exiting...\n");
  if ( NDtr ) NDtr->Delete();
  //
  if ( nd ) delete nd;
  if ( ndclone ) delete ndclone;
  if ( glroot ) delete glroot;
  if ( runinfo ) delete runinfo; 
  //
  if(code < 0)  throw code;
  return(code);
}



