/**
 * \file inc/NDLevel2.h
 */
#ifndef NDLevel2_h
#define NDLevel2_h
//
#include <TObject.h>
#include <NDStruct.h>
//

/**
 * \brief ND level2 class
 *
 * This class contains level2 ND variables
 *
**/
class NDLevel2 : public TObject {
 private:

 public:
  //
  // general variables
  //
  Int_t unpackError; // emiliano
  //
  // ND variables
  //
  Float_t upperBack; ///< number of neutrons in the upper part of the detector between two triggers
  Float_t bottomBack; ///< number of neutrons in the bottom part of the detector between two triggers
  Float_t trigPhysics; ///< number of neutrons during trigger
  //
  // constructor
  //
  NDLevel2();///< Constructor.
  //
  NDLevel2*   GetNDLevel2(){return this;};  // <<<ELENA
  //
  // METHODS
  //
  void SetFromLevel2Struct(cNDLevel2 *l2);
  //
  void GetLevel2Struct(cNDLevel2 *l2) const;
  //
  void Clear(); // emiliano
  //
  ClassDef(NDLevel2, 2)
};
#endif
