#ifndef gltables_h
#define gltables_h

#include <TString.h>
#include <TObject.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
#include <GLTablesStruct.h>
// ==================================================================
/**
 * \brief Class to store GL_RUN data
 */
class GL_RUN : public TObject {
 private:
    
 public:
    //
    ULong64_t ID;
    ULong64_t ID_REG_RUN;
    ULong64_t ID_REG_RUN_L2;
    ULong64_t RUNHEADER_TIME;
    ULong64_t RUNTRAILER_TIME;
    Int_t EV_REG_PHYS_FROM; 
    Int_t EV_REG_PHYS_TO;  
    Int_t EV_REG_RUNHEADER;  
    Int_t EV_REG_RUNTRAILER;  
    Int_t TRK_CALIB_USED;
    Int_t EFF_WRK_SCHEDULE;
    Int_t PRH_VAR_TRG_MODE_A;
    Int_t PRH_VAR_TRG_MODE_B;
    Int_t ACQ_BUILD_INFO;
    Int_t ACQ_VAR_INFO;

    GL_RUN();
    
    Int_t Query_GL_RUN(ULong64_t, TSQLServer*);

    void GetLevel2Struct(cGLRun *l2) const;

    ClassDef(GL_RUN,1);
};
// ==================================================================
/**
 * \brief Class to store GL_ROOT 
 */
class GL_ROOT : public TObject{
 private:
    
 public:
    //
    ULong64_t ID;
    ULong64_t ID_RAW;
    TString   PATH;
    TString   NAME;

    GL_ROOT();

    Int_t Query_GL_ROOT(ULong64_t id, TSQLServer *dbc);

    ClassDef(GL_ROOT,1);
};
// ==================================================================
/**
 * \brief Class to store GL_PARAM data
 */
class GL_PARAM : public TObject{
 private:
    
 public:
    //
    ULong64_t ID;
    TString   PATH;
    TString   NAME;
    TString   DESCR;
    ULong64_t FROM_TIME;
    ULong64_t TO_TIME;

    GL_PARAM();

    Int_t Query_GL_PARAM(ULong64_t time, TString descr, TSQLServer *dbc);
 
    ClassDef(GL_PARAM,1);
};
// ==================================================================
/**
 * \brief Class to store GL_TRK_CALIB data
 */
class GL_TRK_CALIB : public TObject{
 private:
    
 public:
    //
    ULong64_t ID;
    ULong64_t ID_REG_CALIBTRK;
    Int_t EV_REG_CALIBTRK1 ;
    Int_t EV_REG_CALIBTRK2 ;
    ULong64_t FROM_TIME;
    ULong64_t TO_TIME;

    GL_TRK_CALIB();

    Int_t Query_GL_TRK_CALIB(ULong64_t time, TSQLServer *dbc);

    ClassDef(GL_TRK_CALIB,1);
};

// ==================================================================
/**
 * \brief Class to store GL_CALO_CALIB data
 */
class GL_CALO_CALIB : public TObject{
 private:
    
 public:
    //
    ULong64_t ID;
    ULong64_t ID_REG_CALIBCALPED;
    Int_t     EV_REG_CALIBCALPED ;
    ULong64_t FROM_TIME;
    ULong64_t TO_TIME;
    Int_t     SECTION;

    GL_CALO_CALIB();

    Int_t Query_GL_CALO_CALIB(ULong64_t time, Int_t section, TSQLServer *dbc);

    ClassDef(GL_CALO_CALIB,1);
};
// ==================================================================
/**
 * \brief Class to store GL_S4_CALIB data
 */
class GL_S4_CALIB : public TObject{
 private:
    
 public:
    //
    ULong64_t ID;
    ULong64_t ID_REG_CALIBS4;
    Int_t     EV_REG_CALIBS4 ;
    ULong64_t FROM_TIME;
    ULong64_t TO_TIME;
    Double_t PARAM_FIT0;
    Double_t PARAM_FIT1;

    GL_S4_CALIB();

    Int_t Query_GL_S4_CALIB(ULong64_t time, TSQLServer *dbc);

    ClassDef(GL_S4_CALIB,1);
};

#endif
