      SUBROUTINE NSHOWER(IERR,RNUMX,RNUMY,ENERGIAX,ENERGIAY)
C----------------------------------------------------------------------
C-
C-   Purpose and Methods : IT IDENTIFIES ELECTROMAGNETIC SHOWERS USING :
C-   CENTER OF GRAVITY IN THE FIRST HALF - SECOND HALF OF THE CALORIMETER .
C-   RNUMX AND RNUMY (X AND Y VIEW) ARE THE DISTANCES IN mm OF THE CLUSTERS
C-   CLOSEST TO THE TRACK NORMALIZED TO THE TRACK .  
C-   ENERGIAX AND ENERGIAY ARE THE ENERGY OF THESE CLUSTERS .
C-   THE CENTERS OF GRAVITY AND THE CLUSTERS COME FROM THE ROUTINE CLUSTER2 .
C-
C-   Inputs  :
C-   Outputs :
C-   Controls:
C-
C-   Created   3-NOV-1993   MIRKO BOEZIO
C-
C----------------------------------------------------------------------
      INCLUDE 'INTEST.TXT'
C
      INTEGER LK(2)
      INTEGER IBAR(2,NPLAV)
      INTEGER ITL,I,LPIANO
      REAL RX(2),RY(2)
      REAL RIL(NCHA/2)
      REAL BAR(2,NPLAV)
      REAL TG(2)
      REAL DAD
      COMMON / VARIE / MAX
      SAVE / VARIE /
      COMMON / INIZIO / INPIA
      SAVE / INIZIO /
      COMMON / IMPULSO / QUAMOT
      SAVE / IMPULSO /
      COMMON / DOVE / NX, NY, LUNGH
      SAVE / DOVE /
      COMMON / TANGENTI / TG
      SAVE / TANGENTI /
      COMMON / ANGOLO / BAR, IBAR
      SAVE / ANGOLO /
      DATA DAD / 0. /
C
      LPIANO = NPLA / 2 
c
      CALL CLUSTER2
C
      ITL = 0
      IALFA = 0
      CONTINUE
C
      DO I = 1,NCHA/2
        RIL(I) = 1000.
      ENDDO
C
      DAD = 0.
      RX(1) = 0.
      RX(2) = 0.
      RY(1) = 0.
      RY(2) = 0.      
C
      DO M = 1,2
        DO J = 1,2
C
          DO I = 1,NCHA/2
            RIL(I) = 1000.
          ENDDO
C
          LK(J) = 0
C
          IF (J.EQ.1) ITL = (LPIANO + 1) / 2
          IF (J.EQ.2) ITL = (NPLA + LPIANO + 1) / 2
C
          DAD = BAR(M,ITL) 
C
C     EM
C       
          IF (DAD.LT.-6..OR.DAD.GT.246.) GOTO 555 
C
C     END EM
C   
          NGIR = NCL2(M,J)
          IF (NGIR.EQ.0) GO TO 555
          DO L = 1,NGIR
            RIL(L) = ABS(DAD - CLUS2(M,J,L))
          ENDDO
          MM = NCHA/2
          LK(J) = LVMIN(RIL,MM)
C
          IF (CLUS2(M,J,LK(J)+NCHA/2).GT.EMIN) THEN
            IF (M.EQ.1) THEN
              ENERGIAX = ENERGIAX + CLUS2(M,J,LK(J)+NCHA/2)
              RX(J) = CLUS2(M,J,LK(J)) - DAD
            ENDIF
            IF (M.EQ.2) THEN
              ENERGIAY = ENERGIAY + CLUS2(M,J,LK(J)+NCHA/2)
              RY(J) = CLUS2(M,J,LK(J)) - DAD
            ENDIF
          ENDIF
C
  555     CONTINUE
        ENDDO
C
        IF (M.EQ.1) RNUMX = ABS( RX(2) - RX(1) ) 
        IF (M.EQ.2) RNUMY = ABS( RY(2) - RY(1) ) 
C
      ENDDO
C
      ESOGLIATOT = 50.
      EINT = 10.
C
      IF (ENERGIAX.EQ.0.OR.ENERGIAY.EQ.0) THEN
        II = 1
      ENDIF
C
      EINF = ENERGIAX - EINT
      ESUP = ENERGIAX + EINT
      ETOT = ENERGIAX + ENERGIAY
C
      IF (ENERGIAY.LT.EINF.OR.ENERGIAY.GT.ESUP.OR.
     &    ETOT.LT.ESOGLIATOT) GO TO 2
C
      GO TO 10
C
    2 IERR = 1
C
   10 CONTINUE

      RETURN
      END
